/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.network.delayed;

import java.util.Collection;
import java.util.Map;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.util.Direction;
import org.eclipse.viatra.query.runtime.matchers.util.Signed;
import org.eclipse.viatra.query.runtime.matchers.util.timeline.Timeline;
import org.eclipse.viatra.query.runtime.rete.network.Receiver;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;
import org.eclipse.viatra.query.runtime.rete.network.communication.CommunicationTracker;
import org.eclipse.viatra.query.runtime.rete.network.communication.Timestamp;
import org.eclipse.viatra.query.runtime.rete.network.mailbox.Mailbox;

public abstract class DelayedCommand
implements Runnable {
    protected final Supplier supplier;
    protected final Receiver receiver;
    protected final Direction direction;
    protected final ReteContainer container;

    public DelayedCommand(Supplier supplier, Receiver receiver, Direction direction, ReteContainer container) {
        this.supplier = supplier;
        this.receiver = receiver;
        this.direction = direction;
        this.container = container;
    }

    @Override
    public void run() {
        CommunicationTracker tracker = this.container.getCommunicationTracker();
        Mailbox mailbox = tracker.proxifyMailbox(this.supplier, this.receiver.getMailbox());
        if (this.isTimestampAware()) {
            Map<Tuple, Timeline<Timestamp>> contents = this.container.pullContentsWithTimeline(this.supplier, false);
            for (Map.Entry<Tuple, Timeline<Timestamp>> entry : contents.entrySet()) {
                for (Signed change : entry.getValue().asChangeSequence()) {
                    mailbox.postMessage(change.getDirection().multiply(this.direction), entry.getKey(), (Timestamp)change.getPayload());
                }
            }
        } else {
            Collection<Tuple> contents = this.container.pullContents(this.supplier, false);
            for (Tuple tuple : contents) {
                mailbox.postMessage(this.direction, tuple, Timestamp.ZERO);
            }
        }
    }

    public String toString() {
        return String.valueOf(this.supplier) + " -> " + this.receiver.toString();
    }

    protected abstract boolean isTimestampAware();
}

