/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.runtime.emf.transformation.batch;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.viatra.query.runtime.api.GenericQueryGroup;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;
import org.eclipse.viatra.transformation.evm.api.Context;
import org.eclipse.viatra.transformation.evm.api.Executor;
import org.eclipse.viatra.transformation.evm.api.IExecutor;
import org.eclipse.viatra.transformation.evm.api.RuleEngine;
import org.eclipse.viatra.transformation.evm.api.adapter.AdaptableEVM;
import org.eclipse.viatra.transformation.evm.api.adapter.AdaptableEVMFactory;
import org.eclipse.viatra.transformation.evm.api.adapter.AdaptableExecutor;
import org.eclipse.viatra.transformation.evm.api.adapter.IAdapterConfiguration;
import org.eclipse.viatra.transformation.evm.api.adapter.IEVMAdapter;
import org.eclipse.viatra.transformation.evm.api.adapter.IEVMListener;
import org.eclipse.viatra.transformation.evm.specific.RuleEngines;
import org.eclipse.viatra.transformation.runtime.emf.rules.BatchTransformationRuleGroup;
import org.eclipse.viatra.transformation.runtime.emf.rules.TransformationRuleGroup;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;
import org.eclipse.viatra.transformation.runtime.emf.transformation.batch.BatchTransformationStatements;

public class BatchTransformation {
    protected final RuleEngine ruleEngine;
    protected final ViatraQueryEngine queryEngine;
    protected final IExecutor executor;
    protected final Context context;
    protected Set<BatchTransformationRule<?, ?>> rules = new HashSet();

    public static BatchTransformationBuilder forScope(EMFScope scope) {
        return BatchTransformation.forEngine(ViatraQueryEngine.on((QueryScope)scope));
    }

    public static BatchTransformationBuilder forEngine(ViatraQueryEngine engine) {
        return new BatchTransformationBuilder().setQueryEngine(engine);
    }

    public BatchTransformationStatements getTransformationStatements() {
        return new BatchTransformationStatements(this, this.executor);
    }

    private BatchTransformation(RuleEngine ruleEngine, ViatraQueryEngine queryEngine, IExecutor executor) {
        this.ruleEngine = ruleEngine;
        this.queryEngine = queryEngine;
        this.executor = executor;
        this.context = executor.getContext();
        Preconditions.checkState((this.context != null ? 1 : 0) != 0, (String)"Executor must return a non-null context.");
    }

    public void addRule(BatchTransformationRule rule) {
        this.rules.add(rule);
    }

    public void addRules(TransformationRuleGroup<BatchTransformationRule> ruleGroup) {
        for (BatchTransformationRule rule : ruleGroup) {
            this.rules.add(rule);
        }
    }

    public void addRules(BatchTransformationRuleGroup ruleGroup) {
        for (BatchTransformationRule rule : ruleGroup) {
            this.rules.add(rule);
        }
    }

    public BatchTransformationRuleGroup getTransformationRuleGroup() {
        return new BatchTransformationRuleGroup(this.rules.toArray(new BatchTransformationRule[this.rules.size()]));
    }

    public RuleEngine getRuleEngine() {
        return this.ruleEngine;
    }

    public ViatraQueryEngine getQueryEngine() {
        return this.queryEngine;
    }

    public Context getContext() {
        return this.context;
    }

    public void dispose() {
        this.ruleEngine.dispose();
    }

    public static class BatchTransformationBuilder {
        private ViatraQueryEngine engine;
        private Set<BatchTransformationRule<?, ?>> rules = new HashSet();
        private List<IEVMListener> listeners = new ArrayList<IEVMListener>();
        private List<IEVMAdapter> adapters = new ArrayList<IEVMAdapter>();

        public BatchTransformationBuilder setQueryEngine(ViatraQueryEngine engine) {
            this.engine = engine;
            return this;
        }

        public BatchTransformationBuilder addRule(BatchTransformationRule<?, ?> rule) {
            this.rules.add(rule);
            return this;
        }

        public BatchTransformationBuilder addAdapter(IEVMAdapter adapter) {
            this.adapters.add(adapter);
            return this;
        }

        public BatchTransformationBuilder addListener(IEVMListener listener) {
            this.listeners.add(listener);
            return this;
        }

        public BatchTransformationBuilder addAdapterConfiguration(IAdapterConfiguration config) {
            this.listeners.addAll(config.getListeners());
            this.adapters.addAll(config.getAdapters());
            return this;
        }

        public BatchTransformationBuilder addRules(BatchTransformationRuleGroup ruleGroup) {
            for (BatchTransformationRule rule : ruleGroup) {
                this.rules.add(rule);
            }
            return this;
        }

        public BatchTransformation build() {
            Preconditions.checkState((this.engine != null ? 1 : 0) != 0, (String)"ViatraQueryEngine must be set.");
            BatchTransformation transformation = this.listeners.size() > 0 || this.adapters.size() > 0 ? this.debugBuild() : this.doBuild();
            this.initializeIndexes(this.engine);
            transformation.rules = this.rules;
            return transformation;
        }

        private BatchTransformation doBuild() {
            Executor executor = new Executor();
            RuleEngine ruleEngine = RuleEngines.createViatraQueryRuleEngine((ViatraQueryEngine)this.engine);
            return new BatchTransformation(ruleEngine, this.engine, (IExecutor)executor);
        }

        private BatchTransformation debugBuild() {
            AdaptableEVM vm = AdaptableEVMFactory.getInstance().createAdaptableEVM();
            vm.addAdapters(this.adapters);
            vm.addListeners(this.listeners);
            AdaptableExecutor executor = new AdaptableExecutor((IExecutor)new Executor(), vm);
            RuleEngine ruleEngine = vm.createAdaptableRuleEngine(this.engine);
            BatchTransformation batchTransformation = new BatchTransformation(ruleEngine, this.engine, (IExecutor)executor);
            vm.initialize(this.engine);
            return batchTransformation;
        }

        private void initializeIndexes(ViatraQueryEngine queryEngine) {
            GenericQueryGroup.of(this.rules.stream().map(BatchTransformationRule::getPrecondition)).prepare(queryEngine);
        }
    }
}

