/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.api;

import org.eclipse.viatra.dse.api.strategy.impl.BestFirstStrategy;
import org.eclipse.viatra.dse.api.strategy.impl.BreadthFirstStrategy;
import org.eclipse.viatra.dse.api.strategy.impl.DepthFirstStrategy;
import org.eclipse.viatra.dse.api.strategy.impl.FixedPriorityStrategy;
import org.eclipse.viatra.dse.api.strategy.impl.HillClimbingStrategy;

public final class Strategies {
    private Strategies() {
    }

    public static DepthFirstStrategy createDfsStrategy() {
        return new DepthFirstStrategy();
    }

    public static DepthFirstStrategy createDfsStrategy(int depthLimit) {
        return new DepthFirstStrategy(depthLimit);
    }

    public static FixedPriorityStrategy createFixedPriorityStrategy() {
        return Strategies.createFixedPriorityStrategy(-1);
    }

    public static FixedPriorityStrategy createFixedPriorityStrategy(int depthLimit) {
        return new FixedPriorityStrategy().withDepthLimit(depthLimit);
    }

    public static BreadthFirstStrategy createBfsStrategy() {
        return new BreadthFirstStrategy();
    }

    public static BreadthFirstStrategy createBfsStrategy(int depthLimit) {
        return new BreadthFirstStrategy(depthLimit);
    }

    public static HillClimbingStrategy creatHillClimbingStrategy() {
        return new HillClimbingStrategy();
    }

    public static BestFirstStrategy createBestFirstStrategy() {
        return new BestFirstStrategy();
    }

    public static BestFirstStrategy createBestFirstStrategy(int depthLimit) {
        return new BestFirstStrategy(depthLimit);
    }
}

