/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.CheckOperationExecutor;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;

public class ContainmentCheck
implements ISearchOperation {
    int childPosition;
    int containerPosition;
    private boolean transitive;

    public ContainmentCheck(int childPosition, int containerPosition, boolean transitive) {
        this.childPosition = childPosition;
        this.containerPosition = containerPosition;
        this.transitive = transitive;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "check     containment +" + variableMapping.apply(this.containerPosition) + " <>--> +" + this.childPosition + (this.transitive ? " transitively" : " directly");
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.childPosition, this.containerPosition);
    }

    private class Executor
    extends CheckOperationExecutor {
        private Executor() {
        }

        @Override
        protected boolean check(MatchingFrame frame, ISearchContext context) {
            try {
                EObject child = (EObject)frame.getValue(ContainmentCheck.this.childPosition);
                EObject container = (EObject)frame.getValue(ContainmentCheck.this.containerPosition);
                if (ContainmentCheck.this.transitive) {
                    return EcoreUtil.isAncestor((EObject)container, (EObject)child);
                }
                return child.eContainer().equals(container);
            }
            catch (ClassCastException e) {
                throw new LocalSearchException("Invalid type of variable", e);
            }
        }

        @Override
        public ISearchOperation getOperation() {
            return ContainmentCheck.this;
        }
    }
}

