/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.matcher.integration;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.CallWithAdornment;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.matcher.LocalSearchMatcher;
import org.eclipse.viatra.query.runtime.localsearch.matcher.MatcherReference;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.IAdornmentProvider;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchBackend;
import org.eclipse.viatra.query.runtime.localsearch.matcher.integration.LocalSearchHints;
import org.eclipse.viatra.query.runtime.localsearch.plan.IPlanDescriptor;
import org.eclipse.viatra.query.runtime.localsearch.plan.IPlanProvider;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlan;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlanForBody;
import org.eclipse.viatra.query.runtime.localsearch.planner.compiler.IOperationCompiler;
import org.eclipse.viatra.query.runtime.matchers.backend.IMatcherCapability;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackend;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.backend.IUpdateable;
import org.eclipse.viatra.query.runtime.matchers.backend.QueryEvaluationHint;
import org.eclipse.viatra.query.runtime.matchers.backend.ResultProviderRequestor;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryBackendContext;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryRuntimeContext;
import org.eclipse.viatra.query.runtime.matchers.context.IndexingService;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.planning.helpers.FunctionalDependencyHelper;
import org.eclipse.viatra.query.runtime.matchers.psystem.IQueryReference;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicenumerables.PositivePatternCall;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQueries;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.psystem.rewriters.IFlattenCallPredicate;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.util.Accuracy;

public abstract class AbstractLocalSearchResultProvider
implements IQueryResultProvider {
    protected final LocalSearchBackend backend;
    protected final IQueryBackendContext backendContext;
    protected final IQueryRuntimeContext runtimeContext;
    protected final PQuery query;
    protected final QueryEvaluationHint userHints;
    protected final Map<PQuery, LocalSearchHints> hintCache = new HashMap<PQuery, LocalSearchHints>();
    protected final IPlanProvider planProvider;
    private static final String PLAN_CACHE_KEY = AbstractLocalSearchResultProvider.class.getName() + "#planCache";
    private final Map<MatcherReference, IPlanDescriptor> planCache;
    protected final ISearchContext searchContext;
    protected ResultProviderRequestor resultProviderRequestor;
    private static final double ESTIMATE_CEILING = 5.764607523034235E17;

    public AbstractLocalSearchResultProvider(LocalSearchBackend backend, IQueryBackendContext context, PQuery query, IPlanProvider planProvider, QueryEvaluationHint userHints) {
        this.backend = backend;
        this.backendContext = context;
        this.query = query;
        this.planProvider = planProvider;
        this.userHints = userHints;
        this.runtimeContext = context.getRuntimeContext();
        this.resultProviderRequestor = backend.getResultProviderRequestor(query, userHints);
        this.searchContext = new ISearchContext.SearchContext(this.backendContext, backend.getCache(), this.resultProviderRequestor);
        this.planCache = (Map)backend.getCache().getValue((Object)PLAN_CACHE_KEY, Map.class, HashMap::new);
    }

    protected abstract IOperationCompiler getOperationCompiler(IQueryBackendContext var1, LocalSearchHints var2);

    private IQueryRuntimeContext getRuntimeContext() {
        return this.backend.getRuntimeContext();
    }

    private LocalSearchMatcher createMatcher(IPlanDescriptor plan, ISearchContext searchContext) {
        List<SearchPlan> executors = plan.getPlan().stream().map(input -> new SearchPlan(input.getBody(), input.getCompiledOperations(), input.calculateParameterMask(), input.getVariableKeys())).collect(Collectors.toList());
        return new LocalSearchMatcher(searchContext, plan, executors);
    }

    private IPlanDescriptor getOrCreatePlan(MatcherReference key, IQueryBackendContext backendContext, IOperationCompiler compiler, LocalSearchHints configuration, IPlanProvider planProvider) {
        if (this.planCache.containsKey(key)) {
            return this.planCache.get(key);
        }
        IPlanDescriptor plan = planProvider.getPlan(backendContext, compiler, this.resultProviderRequestor, configuration, key);
        this.planCache.put(key, plan);
        return plan;
    }

    private IPlanDescriptor getOrCreatePlan(MatcherReference key, IPlanProvider planProvider) {
        if (this.planCache.containsKey(key)) {
            return this.planCache.get(key);
        }
        LocalSearchHints configuration = this.overrideDefaultHints(key.getQuery());
        IOperationCompiler compiler = this.getOperationCompiler(this.backendContext, configuration);
        IPlanDescriptor plan = planProvider.getPlan(this.backendContext, compiler, this.resultProviderRequestor, configuration, key);
        this.planCache.put(key, plan);
        return plan;
    }

    private LocalSearchHints overrideDefaultHints(PQuery pQuery) {
        if (this.hintCache.containsKey(pQuery)) {
            return this.hintCache.get(pQuery);
        }
        LocalSearchHints hint = LocalSearchHints.getDefaultOverriddenBy(this.computeOverridingHints(pQuery));
        this.hintCache.put(pQuery, hint);
        return hint;
    }

    private QueryEvaluationHint computeOverridingHints(PQuery pQuery) {
        return this.backendContext.getHintProvider().getQueryEvaluationHint(pQuery).overrideBy(this.userHints);
    }

    public void prepare() {
        try {
            this.runtimeContext.coalesceTraversals(() -> {
                LocalSearchHints configuration = this.overrideDefaultHints(this.query);
                if (configuration.isUseBase()) {
                    this.indexInitializationBeforePlanning();
                }
                this.prepareDirectDependencies();
                this.runtimeContext.executeAfterTraversal(this::preparePlansForExpectedAdornments);
                return null;
            });
        }
        catch (InvocationTargetException e) {
            throw new QueryProcessingException("Error while building required indexes: {1}", new String[]{e.getTargetException().getMessage()}, "Error while building required indexes.", (Object)this.query, (Throwable)e);
        }
    }

    protected void preparePlansForExpectedAdornments() {
        for (Set<PParameter> adornment : this.overrideDefaultHints(this.query).getAdornmentProvider().getAdornments(this.query)) {
            MatcherReference reference = new MatcherReference(this.query, adornment, this.userHints);
            LocalSearchHints configuration = this.overrideDefaultHints(this.query);
            IOperationCompiler compiler = this.getOperationCompiler(this.backendContext, configuration);
            IPlanDescriptor plan = this.getOrCreatePlan(reference, this.backendContext, compiler, configuration, this.planProvider);
            try {
                if (configuration.isUseBase()) {
                    this.indexKeys(plan.getIteratedKeys());
                }
            }
            catch (InvocationTargetException e) {
                throw new QueryProcessingException(e.getMessage(), null, e.getMessage(), (Object)this.query, (Throwable)e);
            }
            for (SearchPlanForBody body : plan.getPlan()) {
                for (CallWithAdornment dependency : body.getDependencies()) {
                    this.searchContext.getMatcher(dependency);
                }
            }
        }
    }

    protected void prepareDirectDependencies() {
        IAdornmentProvider adornmentProvider = input -> Collections.emptySet();
        QueryEvaluationHint adornmentHint = IAdornmentProvider.toHint(adornmentProvider);
        for (IQueryReference call : this.getDirectDependencies()) {
            this.resultProviderRequestor.requestResultProvider(call, adornmentHint);
        }
    }

    protected void indexInitializationBeforePlanning() {
    }

    protected void indexReferredTypesOfQuery(PQuery query, IndexingService requiredIndexingServices) {
        PQueries.directlyRequiredTypesOfQuery((PQuery)query, (boolean)true).forEach(inputKey -> this.runtimeContext.ensureIndexed(inputKey, requiredIndexingServices));
    }

    private Set<IQueryReference> getDirectDependencies() {
        IFlattenCallPredicate flattenPredicate = this.overrideDefaultHints(this.query).getFlattenCallPredicate();
        LinkedList<PQuery> queue = new LinkedList<PQuery>();
        HashSet<PQuery> visited = new HashSet<PQuery>();
        HashSet<IQueryReference> result = new HashSet<IQueryReference>();
        queue.add(this.query);
        while (!queue.isEmpty()) {
            PQuery next = (PQuery)queue.poll();
            visited.add(next);
            for (PBody body : next.getDisjunctBodies().getBodies()) {
                for (IQueryReference call : body.getConstraintsOfType(IQueryReference.class)) {
                    if (call instanceof PositivePatternCall && flattenPredicate.shouldFlatten((PositivePatternCall)call)) {
                        PQuery dep = ((PositivePatternCall)call).getReferredQuery();
                        if (visited.contains(dep)) continue;
                        queue.add(dep);
                        continue;
                    }
                    result.add(call);
                }
            }
        }
        return result;
    }

    private LocalSearchMatcher initializeMatcher(Object[] parameters) {
        return this.newLocalSearchMatcher(parameters);
    }

    private LocalSearchMatcher initializeMatcher(TupleMask parameterSeedMask) {
        return this.newLocalSearchMatcher(parameterSeedMask.transformUnique(this.query.getParameters()));
    }

    public LocalSearchMatcher newLocalSearchMatcher(ITuple parameters) {
        HashSet<PParameter> adornment = new HashSet<PParameter>();
        int i = 0;
        while (i < parameters.getSize()) {
            if (parameters.get(i) != null) {
                adornment.add((PParameter)this.query.getParameters().get(i));
            }
            ++i;
        }
        return this.newLocalSearchMatcher(adornment);
    }

    public LocalSearchMatcher newLocalSearchMatcher(Object[] parameters) {
        HashSet<PParameter> adornment = new HashSet<PParameter>();
        int i = 0;
        while (i < parameters.length) {
            if (parameters[i] != null) {
                adornment.add((PParameter)this.query.getParameters().get(i));
            }
            ++i;
        }
        return this.newLocalSearchMatcher(adornment);
    }

    private LocalSearchMatcher newLocalSearchMatcher(Set<PParameter> adornment) {
        MatcherReference reference = new MatcherReference(this.query, adornment, this.userHints);
        IPlanDescriptor plan = this.getOrCreatePlan(reference, this.planProvider);
        if (this.overrideDefaultHints(reference.getQuery()).isUseBase()) {
            try {
                this.indexKeys(plan.getIteratedKeys());
            }
            catch (InvocationTargetException e) {
                throw new LocalSearchException("Could not index keys", e);
            }
        }
        LocalSearchMatcher matcher = this.createMatcher(plan, this.searchContext);
        matcher.addAdapters(this.backend.getAdapters());
        return matcher;
    }

    private void indexKeys(final Iterable<IInputKey> keys) throws InvocationTargetException {
        final IQueryRuntimeContext qrc = this.getRuntimeContext();
        qrc.coalesceTraversals((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                for (IInputKey key : keys) {
                    if (!key.isEnumerable()) continue;
                    qrc.ensureIndexed(key, IndexingService.INSTANCES);
                }
                return null;
            }
        });
    }

    public boolean hasMatch(Object[] parameters) {
        LocalSearchMatcher matcher = this.initializeMatcher(parameters);
        return matcher.streamMatches(parameters).findAny().isPresent();
    }

    public boolean hasMatch(TupleMask parameterSeedMask, ITuple parameters) {
        LocalSearchMatcher matcher = this.initializeMatcher(parameterSeedMask);
        return matcher.streamMatches(parameterSeedMask, parameters).findAny().isPresent();
    }

    public Optional<Tuple> getOneArbitraryMatch(Object[] parameters) {
        LocalSearchMatcher matcher = this.initializeMatcher(parameters);
        return matcher.streamMatches(parameters).findAny();
    }

    public Optional<Tuple> getOneArbitraryMatch(TupleMask parameterSeedMask, ITuple parameters) {
        LocalSearchMatcher matcher = this.initializeMatcher(parameterSeedMask);
        return matcher.streamMatches(parameterSeedMask, parameters).findAny();
    }

    public int countMatches(Object[] parameters) {
        LocalSearchMatcher matcher = this.initializeMatcher(parameters);
        return (int)matcher.streamMatches(parameters).count();
    }

    public int countMatches(TupleMask parameterSeedMask, ITuple parameters) {
        LocalSearchMatcher matcher = this.initializeMatcher(parameterSeedMask);
        return (int)matcher.streamMatches(parameterSeedMask, parameters).count();
    }

    public Optional<Long> estimateCardinality(TupleMask groupMask, Accuracy requiredAccuracy) {
        if (Accuracy.BEST_UPPER_BOUND.atLeastAsPreciseAs(requiredAccuracy)) {
            List parameters = this.query.getParameters();
            Map dependencies = this.backendContext.getQueryAnalyzer().getProjectedFunctionalDependencies(this.query, false);
            List projectionIndices = groupMask.getIndicesAsList();
            return this.estimateParameterCombinations(requiredAccuracy, parameters, dependencies, projectionIndices, Collections.emptySet()).map(Double::longValue);
        }
        return Optional.empty();
    }

    public Optional<Double> estimateAverageBucketSize(TupleMask groupMask, Accuracy requiredAccuracy) {
        if (Accuracy.BEST_UPPER_BOUND.atLeastAsPreciseAs(requiredAccuracy)) {
            List parameters = this.query.getParameters();
            Map dependencies = this.backendContext.getQueryAnalyzer().getProjectedFunctionalDependencies(this.query, false);
            List<Integer> allParameterIndices = IntStream.range(0, parameters.size()).boxed().collect(Collectors.toList());
            Set boundOrImplied = FunctionalDependencyHelper.closureOf((Collection)groupMask.getIndicesAsList(), (Map)dependencies);
            return this.estimateParameterCombinations(requiredAccuracy, parameters, dependencies, allParameterIndices, boundOrImplied);
        }
        return Optional.empty();
    }

    public double estimateCost(TupleMask inputBindingMask) {
        HashSet<PParameter> adornment = new HashSet<PParameter>(inputBindingMask.transform(this.query.getParameters()));
        MatcherReference reference = new MatcherReference(this.query, adornment, this.userHints);
        IPlanDescriptor plan = this.getOrCreatePlan(reference, this.planProvider);
        return plan.getPlan().stream().mapToDouble(SearchPlanForBody::getCost).sum();
    }

    private Optional<Double> estimateParameterCombinations(Accuracy requiredAccuracy, List<PParameter> parameters, Map<Set<Integer>, Set<Integer>> functionalDependencies, Collection<Integer> parameterIndicesToEstimate, Set<Integer> otherDeterminingIndices) {
        LinkedHashSet<Integer> freeParameterIndices = new LinkedHashSet<Integer>(parameterIndicesToEstimate);
        freeParameterIndices.removeAll(otherDeterminingIndices);
        for (Integer candidateForRemoval : new ArrayList<Integer>(freeParameterIndices)) {
            List others = Stream.concat(otherDeterminingIndices.stream(), freeParameterIndices.stream().filter(index -> !Objects.equals(index, candidateForRemoval))).collect(Collectors.toList());
            Set othersClosure = FunctionalDependencyHelper.closureOf(others, functionalDependencies);
            if (!othersClosure.contains(candidateForRemoval)) continue;
            freeParameterIndices.remove(candidateForRemoval);
        }
        Optional<Double> result = Optional.of(1.0);
        int i = 0;
        while (i < parameters.size()) {
            IInputKey type = parameters.get(i).getDeclaredUnaryType();
            if (freeParameterIndices.contains(i) && type != null) {
                result = result.flatMap(accumulator -> this.runtimeContext.estimateCardinality(type, TupleMask.identity((int)1), requiredAccuracy).map(multiplier -> Math.min(accumulator * (double)multiplier.longValue(), 5.764607523034235E17)));
            }
            ++i;
        }
        return result;
    }

    public Stream<Tuple> getAllMatches(Object[] parameters) {
        LocalSearchMatcher matcher = this.initializeMatcher(parameters);
        return matcher.streamMatches(parameters);
    }

    public Stream<Tuple> getAllMatches(TupleMask parameterSeedMask, ITuple parameters) {
        LocalSearchMatcher matcher = this.initializeMatcher(parameterSeedMask);
        return matcher.streamMatches(parameterSeedMask, parameters);
    }

    public IQueryBackend getQueryBackend() {
        return this.backend;
    }

    public void addUpdateListener(IUpdateable listener, Object listenerTag, boolean fireNow) {
    }

    public void removeUpdateListener(Object listenerTag) {
    }

    public IMatcherCapability getCapabilites() {
        LocalSearchHints configuration = this.overrideDefaultHints(this.query);
        return configuration;
    }

    public void forgetAllPlans() {
        this.planCache.clear();
    }

    public IPlanDescriptor getSearchPlan(Set<PParameter> adornment) {
        return this.planCache.get(new MatcherReference(this.query, adornment));
    }
}

