/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.command.ChangeCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.viatra.dse.api.DSEException;
import org.eclipse.viatra.dse.api.SolutionTrajectory;
import org.eclipse.viatra.dse.base.ActivationCodesConflictSet;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.designspace.api.IDesignSpace;
import org.eclipse.viatra.dse.designspace.api.TrajectoryInfo;
import org.eclipse.viatra.dse.objectives.ActivationFitnessProcessor;
import org.eclipse.viatra.dse.statecode.IStateCoder;
import org.eclipse.viatra.dse.visualizer.IExploreEventHandler;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.transformation.evm.api.Activation;
import org.eclipse.viatra.transformation.evm.api.Context;
import org.eclipse.viatra.transformation.evm.api.resolver.ChangeableConflictSet;
import org.eclipse.viatra.transformation.runtime.emf.rules.batch.BatchTransformationRule;

public class DesignSpaceManager {
    private final IStateCoder stateCoder;
    private final EditingDomain domain;
    private Notifier model;
    private IDesignSpace designSpace;
    private final TrajectoryInfo trajectory;
    private List<IExploreEventHandler> handlers;
    private final Context evmContext = Context.create();
    private Logger logger = Logger.getLogger(this.getClass());
    private boolean isNewState = false;
    private Map<BatchTransformationRule<?, ?>, ActivationFitnessProcessor> activationFitnessProcessors;
    private Map<BatchTransformationRule<?, ?>, String> activationFitnessProcessorNames;
    private ThreadContext context;
    private ActivationCodesConflictSet activationCodes;
    private ChangeableConflictSet conflictSet;
    private Random random = new Random();

    public DesignSpaceManager(ThreadContext context) {
        this.context = context;
        this.model = context.getModel();
        this.designSpace = context.getGlobalContext().getDesignSpace();
        this.domain = context.getEditingDomain();
        this.conflictSet = context.getConflictResolver().getLastCreatedConflictSet();
        this.stateCoder = context.getStateCoder();
        Object initialStateId = this.stateCoder.createStateCode();
        this.designSpace.addState(null, null, initialStateId);
        this.activationCodes = context.getActivationCodesConflictSet();
        this.trajectory = new TrajectoryInfo(initialStateId);
        this.logger.debug((Object)("DesignSpaceManager initialized with initial model: " + String.valueOf(initialStateId)));
    }

    public void fireActivation(Object transition) {
        if (this.fireActivationSilent(transition)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("A retrieved Transition SHOULD have a matching Activation. Possible causes: the state serializer is faulty; the algorithm choosed a wrong Transition.");
        sb.append("\nSought transition: ");
        sb.append(transition);
        Object currentStateId = this.getCurrentState();
        sb.append("\nCurrent known state: ");
        sb.append(currentStateId);
        Object actualStateId = this.stateCoder.createStateCode();
        sb.append("\nActual state: ");
        sb.append(actualStateId.equals(currentStateId) ? "same as current" : actualStateId);
        sb.append("\n");
        sb.append(this.trajectory);
        sb.append("\nAvailable transitions:");
        for (Activation act : this.conflictSet.getNextActivations()) {
            IPatternMatch match = (IPatternMatch)act.getAtom();
            Object code = this.generateMatchCode(match);
            sb.append("\n\t");
            sb.append(code);
        }
        throw new DSEException(sb.toString());
    }

    public boolean tryFireActivation(Object transition) {
        return this.fireActivationSilent(transition);
    }

    private boolean fireActivationSilent(Object transition) {
        final Activation<?> activation = this.getActivationById(transition);
        if (activation == null) {
            return false;
        }
        BatchTransformationRule<?, ?> rule = this.getRuleByActivation(activation);
        HashMap<String, Double> measureCosts = new HashMap<String, Double>();
        if (this.activationFitnessProcessors != null && this.activationFitnessProcessors.containsKey(rule)) {
            IPatternMatch match = (IPatternMatch)activation.getAtom();
            ActivationFitnessProcessor processor = this.activationFitnessProcessors.get(rule);
            double fitness = processor.process(match);
            measureCosts.put(this.activationFitnessProcessorNames.get(rule), fitness);
        }
        ChangeCommand rc = new ChangeCommand(this.model){

            protected void doExecute() {
                activation.fire(DesignSpaceManager.this.evmContext);
            }
        };
        Object previousState = this.trajectory.getCurrentStateId();
        this.domain.getCommandStack().execute((Command)rc);
        Object newStateId = this.stateCoder.createStateCode();
        this.activationCodes.updateActivationCodes();
        if (this.designSpace != null) {
            this.isNewState = !this.designSpace.isTraversed(newStateId);
            this.designSpace.addState(previousState, transition, newStateId);
        }
        this.trajectory.addStep(transition, rule, newStateId, measureCosts);
        if (this.handlers != null) {
            for (IExploreEventHandler iExploreEventHandler : this.handlers) {
                iExploreEventHandler.transitionFired(transition);
            }
        }
        this.logger.debug((Object)("Executed activation: " + String.valueOf(transition)));
        return true;
    }

    public boolean executeRandomActivationId() {
        Collection<Object> transitions = this.getTransitionsFromCurrentState();
        int size = transitions.size();
        if (size == 0) {
            return false;
        }
        int index = this.random.nextInt(size);
        Iterator<Object> iterator = transitions.iterator();
        int i = 0;
        while (i < index) {
            iterator.next();
            ++i;
        }
        Object transition = iterator.next();
        this.fireActivation(transition);
        return true;
    }

    public int executeTrajectory(Object[] trajectoryToExecute) {
        return this.executeTrajectory(trajectoryToExecute, 0, trajectoryToExecute.length, false, true);
    }

    public int executeTrajectory(Object[] trajectoryToExecute, int fromIncludedIndex, int toExcludedIndex) {
        return this.executeTrajectory(trajectoryToExecute, fromIncludedIndex, toExcludedIndex, false, true);
    }

    public int executeTrajectoryByTrying(Object[] trajectoryToExecute) {
        return this.executeTrajectory(trajectoryToExecute, 0, trajectoryToExecute.length, true, true);
    }

    public int executeTrajectoryByTrying(Object[] trajectoryToExecute, int fromIncludedIndex, int toExcludedIndex) {
        return this.executeTrajectory(trajectoryToExecute, fromIncludedIndex, toExcludedIndex, true, true);
    }

    public int executeTrajectoryWithoutStateCoding(Object[] trajectoryToExecute) {
        return this.executeTrajectory(trajectoryToExecute, 0, trajectoryToExecute.length, false, false);
    }

    public int executeTrajectoryWithoutStateCoding(Object[] trajectoryToExecute, int fromIncludedIndex, int toExcludedIndex) {
        return this.executeTrajectory(trajectoryToExecute, fromIncludedIndex, toExcludedIndex, false, false);
    }

    public int executeTrajectoryByTryingWithoutStateCoding(Object[] trajectoryToExecute) {
        return this.executeTrajectory(trajectoryToExecute, 0, trajectoryToExecute.length, true, false);
    }

    public int executeTrajectoryByTryingWithoutStateCoding(Object[] trajectoryToExecute, int fromIncludedIndex, int toExcludedIndex) {
        return this.executeTrajectory(trajectoryToExecute, fromIncludedIndex, toExcludedIndex, true, false);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int executeTrajectory(Object[] trajectoryToExecute, int fromIncludedIndex, int toExcludedIndex, boolean tryAllActivations, boolean createStateCode) {
        this.logger.debug((Object)"Executing trajectory.");
        int unsuccesfulIndex = -1;
        if (tryAllActivations) {
            unsuccesfulIndex = 0;
        }
        int i = fromIncludedIndex;
        while (i < toExcludedIndex) {
            block8: {
                Object activationId = trajectoryToExecute[i];
                final Activation<?> activation = this.getActivationById(activationId);
                if (activation == null) {
                    this.logger.debug((Object)("Couldn't execute activation: " + String.valueOf(activationId)));
                    if (tryAllActivations) {
                        ++unsuccesfulIndex;
                        break block8;
                    } else {
                        unsuccesfulIndex = i;
                        this.logger.debug((Object)("Trajectory execution stopped at index " + i + "/" + trajectoryToExecute.length));
                        break;
                    }
                }
                BatchTransformationRule<?, ?> rule = this.getRuleByActivation(activation);
                HashMap<String, Double> measureCosts = new HashMap<String, Double>();
                if (this.activationFitnessProcessors != null && this.activationFitnessProcessors.containsKey(rule)) {
                    IPatternMatch match = (IPatternMatch)activation.getAtom();
                    ActivationFitnessProcessor processor = this.activationFitnessProcessors.get(rule);
                    double fitness = processor.process(match);
                    measureCosts.put(this.activationFitnessProcessorNames.get(rule), fitness);
                }
                ChangeCommand rc = new ChangeCommand(this.model){

                    protected void doExecute() {
                        activation.fire(DesignSpaceManager.this.evmContext);
                    }
                };
                this.domain.getCommandStack().execute((Command)rc);
                Object newStateId = null;
                if (createStateCode) {
                    newStateId = this.stateCoder.createStateCode();
                }
                this.activationCodes.updateActivationCodes();
                this.trajectory.addStep(activationId, rule, newStateId, measureCosts);
                this.logger.debug((Object)("Activation executed: " + String.valueOf(activationId)));
            }
            ++i;
        }
        if (!createStateCode) {
            this.trajectory.modifyLastStateCode(this.stateCoder.createStateCode());
        }
        this.logger.debug((Object)"Trajectory execution finished.");
        return unsuccesfulIndex;
    }

    public Object getTransitionByActivation(Activation<?> activation) {
        return this.activationCodes.getActivationId(activation);
    }

    public Activation<?> getActivationById(Object activationId) {
        return this.activationCodes.getActivation(activationId);
    }

    public BatchTransformationRule<?, ?> getRuleByActivation(Activation<?> activation) {
        return this.context.getGlobalContext().getSpecificationRuleMap().get(activation.getInstance().getSpecification());
    }

    public BatchTransformationRule<?, ?> getRuleByActivationId(Object activationId) {
        return this.getRuleByActivation(this.getActivationById(activationId));
    }

    public boolean isNewModelStateAlreadyTraversed() {
        return !this.isNewState;
    }

    public List<Object> getTrajectoryFromRoot() {
        return this.trajectory.getTrajectory();
    }

    public Collection<Object> getTransitionsFromCurrentState() {
        return this.activationCodes.getCurrentActivationCodes();
    }

    public Collection<Object> getUntraversedTransitionsFromCurrentState() {
        if (this.designSpace == null) {
            throw new DSEException("Unsupported without a design space");
        }
        Object currentState = this.trajectory.getCurrentStateId();
        Collection<Object> traversedIds = this.designSpace.getActivationIds(currentState);
        ArrayList<Object> untraversedTransitions = new ArrayList<Object>();
        for (Object activationId : this.activationCodes.getCurrentActivationCodes()) {
            if (traversedIds.contains(activationId)) continue;
            untraversedTransitions.add(activationId);
        }
        return untraversedTransitions;
    }

    public boolean undoLastTransformation() {
        if (!this.trajectory.canStepBack()) {
            return false;
        }
        this.domain.getCommandStack().undo();
        this.activationCodes.updateActivationCodes();
        Object lastActivationId = this.trajectory.getLastActivationId();
        this.trajectory.backtrack();
        if (this.handlers != null) {
            for (IExploreEventHandler iExploreEventHandler : this.handlers) {
                iExploreEventHandler.undo(lastActivationId);
            }
        }
        this.logger.debug((Object)"Backtrack.");
        return true;
    }

    public void backtrackXTimes(int steps) {
        int i = steps;
        while (i > 0) {
            this.domain.getCommandStack().undo();
            this.trajectory.backtrack();
            --i;
        }
        this.activationCodes.updateActivationCodes();
        this.logger.debug((Object)("Backtracked " + steps + " times."));
    }

    public int backtrackUntilLastCommonActivation(Object[] newTrajectory) {
        int numberOfBacktracks;
        Iterator<Object> currentTrajectoryIterator = this.trajectory.getTrajectory().iterator();
        if (!currentTrajectoryIterator.hasNext()) {
            return 0;
        }
        int indexOfLastCommonActivation = 0;
        Object[] objectArray = newTrajectory;
        int n = newTrajectory.length;
        int n2 = 0;
        while (n2 < n) {
            Object activationCodeFromCurrent;
            Object activationCode = objectArray[n2];
            if (!currentTrajectoryIterator.hasNext() || !(activationCodeFromCurrent = currentTrajectoryIterator.next()).equals(activationCode)) break;
            ++indexOfLastCommonActivation;
            ++n2;
        }
        if ((numberOfBacktracks = this.trajectory.getDepth() - indexOfLastCommonActivation) > 0) {
            int i = numberOfBacktracks;
            while (i > 0) {
                this.domain.getCommandStack().undo();
                this.trajectory.backtrack();
                --i;
            }
            this.activationCodes.updateActivationCodes();
        }
        this.logger.debug((Object)("Backtracked " + numberOfBacktracks + " times."));
        return indexOfLastCommonActivation;
    }

    public void executeTrajectoryWithMinimalBacktrack(Object[] trajectory) {
        this.executeTrajectoryWithMinimalBacktrack(trajectory, trajectory.length);
    }

    public void executeTrajectoryWithMinimalBacktrack(Object[] trajectory, int toExcludedIndex) {
        int fromIndex = this.backtrackUntilLastCommonActivation(trajectory);
        this.executeTrajectory(trajectory, fromIndex, toExcludedIndex, false, true);
    }

    public void executeTrajectoryWithMinimalBacktrackWithoutStateCoding(Object[] trajectory) {
        this.executeTrajectoryWithMinimalBacktrackWithoutStateCoding(trajectory, trajectory.length);
    }

    public void executeTrajectoryWithMinimalBacktrackWithoutStateCoding(Object[] trajectory, int toExcludedIndex) {
        int fromIndex = this.backtrackUntilLastCommonActivation(trajectory);
        this.executeTrajectory(trajectory, fromIndex, toExcludedIndex, false, false);
        Object stateCode = this.stateCoder.createStateCode();
        this.trajectory.modifyLastStateCode(stateCode);
    }

    public void undoUntilRoot() {
        while (this.trajectory.canStepBack()) {
            this.domain.getCommandStack().undo();
            this.trajectory.backtrack();
        }
        this.activationCodes.updateActivationCodes();
        this.logger.debug((Object)"Backtracked to root.");
    }

    private Object generateMatchCode(IPatternMatch match) {
        return this.stateCoder.createActivationCode(match);
    }

    public Object getCurrentState() {
        return this.trajectory.getCurrentStateId();
    }

    public SolutionTrajectory createSolutionTrajectroy() {
        return this.trajectory.createSolutionTrajectory(this.context.getGlobalContext().getStateCoderFactory());
    }

    public TrajectoryInfo getTrajectoryInfo() {
        return this.trajectory;
    }

    public void setDesignSpace(IDesignSpace designSpace) {
        this.designSpace = designSpace;
    }

    public IDesignSpace getDesignSpace() {
        return this.designSpace;
    }

    public void registerExploreEventHandler(IExploreEventHandler handler) {
        if (handler == null) {
            return;
        }
        if (this.handlers == null) {
            this.handlers = new ArrayList<IExploreEventHandler>();
        }
        this.handlers.add(handler);
    }

    public void deregisterExploreEventHandler(IExploreEventHandler handler) {
        if (handler == null) {
            return;
        }
        if (this.handlers != null) {
            this.handlers.remove(handler);
        }
    }

    public void registerActivationCostProcessor(String name, BatchTransformationRule<?, ?> rule, ActivationFitnessProcessor activationFitnessProcessor) {
        if (this.activationFitnessProcessors == null || this.activationFitnessProcessorNames == null) {
            this.activationFitnessProcessors = new HashMap();
            this.activationFitnessProcessorNames = new HashMap();
        }
        this.activationFitnessProcessors.put(rule, activationFitnessProcessor);
        this.activationFitnessProcessorNames.put(rule, name);
    }

    public boolean isCurentStateInTrajectory() {
        Object currentStateId = this.trajectory.getCurrentStateId();
        List<Object> stateTrajectory = this.trajectory.getStateTrajectory();
        int size = stateTrajectory.size();
        int i = 0;
        while (i < size - 1) {
            Object stateId = stateTrajectory.get(i);
            if (currentStateId.equals(stateId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public IStateCoder getStateCoder() {
        return this.stateCoder;
    }
}

