/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.addon.databinding.runtime.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.core.databinding.observable.Observables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.addon.databinding.runtime.adapter.ObservableDefinition;
import org.eclipse.viatra.addon.databinding.runtime.collection.ObservablePatternMatchCollectionBuilder;
import org.eclipse.viatra.addon.databinding.runtime.observables.ObservableLabelFeature;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.emf.helper.ViatraQueryRuntimeHelper;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public final class ViatraObservables {
    public static final String OBSERVABLEVALUE_ANNOTATION = "ObservableValue";

    private ViatraObservables() {
    }

    public static <Match extends IPatternMatch, Matcher extends ViatraQueryMatcher<Match>> IObservableList observeMatchesAsList(Matcher matcher) {
        return ObservablePatternMatchCollectionBuilder.create(matcher).buildList();
    }

    public static <Match extends IPatternMatch, Matcher extends ViatraQueryMatcher<Match>> IObservableList observeMatchesAsList(IQuerySpecification<Matcher> querySpecification, ViatraQueryEngine engine) {
        return ObservablePatternMatchCollectionBuilder.create(querySpecification).setEngine(engine).buildList();
    }

    public static <Match extends IPatternMatch, Matcher extends ViatraQueryMatcher<Match>> IObservableList observeMatchesAsList(IQuerySpecification<Matcher> querySpecification, ViatraQueryEngine engine, Match filter) {
        return ObservablePatternMatchCollectionBuilder.create(querySpecification).setFilter(filter).setEngine(engine).buildList();
    }

    public static <Match extends IPatternMatch, Matcher extends ViatraQueryMatcher<Match>> IObservableSet observeMatchesAsSet(Matcher matcher) {
        return ObservablePatternMatchCollectionBuilder.create(matcher).buildSet();
    }

    public static <Match extends IPatternMatch, Matcher extends ViatraQueryMatcher<Match>> IObservableSet observeMatchesAsSet(IQuerySpecification<Matcher> querySpecification, ViatraQueryEngine engine) {
        return ObservablePatternMatchCollectionBuilder.create(querySpecification).setEngine(engine).buildSet();
    }

    public static <Match extends IPatternMatch, Matcher extends ViatraQueryMatcher<Match>> IObservableSet observeMatchesAsSet(IQuerySpecification<Matcher> querySpecification, ViatraQueryEngine engine, Match filter) {
        return ObservablePatternMatchCollectionBuilder.create(querySpecification).setFilter(filter).setEngine(engine).buildSet();
    }

    public static List<IObservableValue> observeFeatures(IPatternMatch match, IValueChangeListener changeListener, String message) {
        if (message == null) {
            return new ArrayList<IObservableValue>();
        }
        ArrayList<IObservableValue> affectedValues = new ArrayList<IObservableValue>();
        String[] tokens = message.split("\\$");
        int i = 1;
        while (i < tokens.length) {
            IObservableValue value = ViatraObservables.getObservableValue(match, tokens[i]);
            if (value != null) {
                value.addValueChangeListener(changeListener);
                affectedValues.add(value);
            }
            i += 2;
        }
        return affectedValues;
    }

    public static List<IObservableValue> observeAllAttributes(IValueChangeListener changeListener, Object object) {
        ArrayList<IObservableValue> affectedValues = new ArrayList<IObservableValue>();
        if (object instanceof EObject) {
            for (EStructuralFeature feature : ((EObject)object).eClass().getEAllStructuralFeatures()) {
                IObservableValue val = EMFProperties.value((EStructuralFeature)feature).observe(object);
                affectedValues.add(val);
                val.addValueChangeListener(changeListener);
            }
        }
        return affectedValues;
    }

    public static IObservableValue getObservableValue(IPatternMatch match, String expression) {
        IObservableValue val = null;
        String[] objectTokens = expression.split("\\.");
        if (objectTokens.length > 0) {
            EList attributes;
            Object o = null;
            EStructuralFeature feature = null;
            if (objectTokens.length == 2) {
                o = match.get(objectTokens[0]);
                feature = ViatraQueryRuntimeHelper.getFeature((Object)o, (String)objectTokens[1]);
            }
            if (objectTokens.length == 1 && (feature = ViatraQueryRuntimeHelper.getFeature((Object)(o = match.get(objectTokens[0])), (String)"name")) == null && o instanceof EObject && !(attributes = ((EObject)o).eClass().getEAllAttributes()).isEmpty()) {
                feature = (EStructuralFeature)attributes.get(0);
            }
            val = o != null && feature != null ? EMFProperties.value(feature).observe(o) : (o != null ? Observables.constantObservableValue((Object)o.toString()) : Observables.constantObservableValue((Object)expression));
        }
        return val;
    }

    public static IObservableValue getObservableLabelFeature(IPatternMatch match, String expression) {
        return ViatraObservables.getObservableLabelFeature(match, expression, null);
    }

    public static IObservableValue getObservableLabelFeature(IPatternMatch match, String expression, Object container) {
        ObservableLabelFeature value = new ObservableLabelFeature(match, expression, container);
        return value;
    }

    public static Map<String, ObservableDefinition> calculateObservableValues(IQuerySpecification<?> query) {
        HashMap<String, ObservableDefinition> propertyMap = new HashMap<String, ObservableDefinition>();
        for (String v : query.getParameterNames()) {
            ObservableDefinition def = new ObservableDefinition(v, v, ObservableDefinition.ObservableType.OBSERVABLE_FEATURE);
            propertyMap.put(v, def);
        }
        for (PAnnotation annotation : query.getAnnotationsByName(OBSERVABLEVALUE_ANNOTATION)) {
            ObservableDefinition.ObservableType type;
            String name = (String)annotation.getFirstValue("name", String.class).orElseThrow(() -> new QueryProcessingException("Invalid container annotation", (Object)query));
            Optional expr = annotation.getFirstValue("expression", String.class);
            Optional label = annotation.getFirstValue("labelExpression", String.class);
            Preconditions.checkArgument((boolean)(expr.isPresent() ^ label.isPresent()), (String)"Either expression or label expression attribute must not be empty.");
            String obsExpr = null;
            if (expr.isPresent()) {
                obsExpr = (String)expr.get();
                type = ObservableDefinition.ObservableType.OBSERVABLE_FEATURE;
            } else {
                obsExpr = (String)label.get();
                type = ObservableDefinition.ObservableType.OBSERVABLE_LABEL;
            }
            ObservableDefinition def = new ObservableDefinition(name, obsExpr, type);
            propertyMap.put(name, def);
        }
        return propertyMap;
    }
}

