/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.CheckOperationExecutor;
import org.eclipse.viatra.query.runtime.localsearch.operations.IPatternMatcherOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.util.CallInformation;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.tuple.IModifiableTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.VolatileModifiableMaskedTuple;

public class CountCheck
implements ISearchOperation,
IPatternMatcherOperation {
    private final int position;
    private final CallInformation information;

    public CountCheck(CallInformation information, int position) {
        this.information = information;
        this.position = position;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor();
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Collections.singletonList(this.position);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "check     " + variableMapping.apply(this.position) + " = count find " + this.information.toString(variableMapping);
    }

    @Override
    public CallInformation getCallInformation() {
        return this.information;
    }

    private class Executor
    extends CheckOperationExecutor {
        private final VolatileModifiableMaskedTuple maskedTuple;
        private IQueryResultProvider matcher;

        public Executor() {
            this.maskedTuple = new VolatileModifiableMaskedTuple(CountCheck.this.information.getThinFrameMask());
        }

        @Override
        public void onInitialize(MatchingFrame frame, ISearchContext context) {
            super.onInitialize(frame, context);
            this.maskedTuple.updateTuple((IModifiableTuple)frame);
            this.matcher = context.getMatcher(CountCheck.this.information.getCallWithAdornment());
        }

        @Override
        protected boolean check(MatchingFrame frame, ISearchContext context) {
            int count = this.matcher.countMatches(CountCheck.this.information.getParameterMask(), (ITuple)this.maskedTuple);
            return (Integer)frame.getValue(CountCheck.this.position) == count;
        }

        @Override
        public ISearchOperation getOperation() {
            return CountCheck.this;
        }
    }
}

