/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryregistry;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryChangeListener;
import org.eclipse.viatra.query.runtime.registry.IQuerySpecificationRegistryEntry;
import org.eclipse.viatra.query.runtime.registry.IRegistryView;
import org.eclipse.viatra.query.runtime.registry.IRegistryViewFactory;
import org.eclipse.viatra.query.runtime.registry.view.AbstractRegistryView;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeEntry;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeInputChange;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreePackage;
import org.eclipse.viatra.query.tooling.ui.queryregistry.QueryRegistryTreeSource;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;

public class QueryRegistryTreeInput {
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private Map<String, QueryRegistryTreeSource> sources = Maps.newTreeMap();
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private IQuerySpecificationRegistry registry;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private IRegistryView view;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private IQuerySpecificationRegistryChangeListener listener;

    public QueryRegistryTreeInput(IQuerySpecificationRegistry registry) {
        this.registry = registry;
        IRegistryViewFactory _function = it -> new AbstractRegistryView(registry, true){

            protected boolean isEntryRelevant(IQuerySpecificationRegistryEntry entry) {
                return true;
            }
        };
        this.view = registry.createView(_function);
        Consumer<IQuerySpecificationRegistryEntry> _function_1 = it -> {
            QueryRegistryTreeInputChange source = this.getOrCreateSource(it.getSourceIdentifier());
            QueryRegistryTreeInputChange treePackage = this.getOrCreatePackage(source.getSource(), this.getPackageName(it.getFullyQualifiedName()));
            QueryRegistryTreePackage _pckg = treePackage.getPckg();
            QueryRegistryTreeEntry entry = new QueryRegistryTreeEntry(_pckg, (IQuerySpecificationRegistryEntry)it);
            treePackage.getPckg().getEntries().put(it.getFullyQualifiedName(), entry);
        };
        this.view.getEntries().forEach(_function_1);
    }

    public void setListener(IQuerySpecificationRegistryChangeListener listener) {
        if (this.listener != null) {
            this.view.removeViewListener(this.listener);
        }
        this.listener = listener;
        if (listener != null) {
            this.view.addViewListener(listener);
        }
    }

    public QueryRegistryTreeInputChange addEntryToInput(IQuerySpecificationRegistryEntry entry) {
        QueryRegistryTreeInputChange source = this.getOrCreateSource(entry.getSourceIdentifier());
        QueryRegistryTreeInputChange treePackage = this.getOrCreatePackage(source.getSource(), this.getPackageName(entry.getFullyQualifiedName()));
        QueryRegistryTreePackage treePckg = treePackage.getPckg();
        QueryRegistryTreeEntry treeEntry = new QueryRegistryTreeEntry(treePckg, entry);
        boolean emptyPckg = treePckg.getEntries().isEmpty();
        treePackage.getPckg().getEntries().put(entry.getFullyQualifiedName(), treeEntry);
        boolean _isSourceAffected = source.isSourceAffected();
        QueryRegistryTreeSource _source = source.getSource();
        return new QueryRegistryTreeInputChange(true, treeEntry, treePackage.isPckgAffected() || emptyPckg, treePckg, _isSourceAffected, _source);
    }

    public QueryRegistryTreeInputChange removeEntry(IQuerySpecificationRegistryEntry entry) {
        boolean emptySource;
        QueryRegistryTreeInputChange sourceDTO = this.getOrCreateSource(entry.getSourceIdentifier());
        QueryRegistryTreeSource source = sourceDTO.getSource();
        QueryRegistryTreeInputChange treePackageDTO = this.getOrCreatePackage(sourceDTO.getSource(), this.getPackageName(entry.getFullyQualifiedName()));
        QueryRegistryTreePackage treePckg = treePackageDTO.getPckg();
        QueryRegistryTreeEntry treeEntry = treePckg.getEntries().remove(entry.getFullyQualifiedName());
        boolean emptyPckg = treePckg.getEntries().isEmpty();
        if (emptyPckg) {
            source.getPackages().remove(treePckg.getPackageName());
        }
        if (emptySource = source.getPackages().isEmpty()) {
            this.sources.remove(source.getSourceIdentifier());
        }
        return new QueryRegistryTreeInputChange(true, treeEntry, treePackageDTO.isPckgAffected() || emptyPckg, treePckg, sourceDTO.isSourceAffected() || emptySource, source);
    }

    public QueryRegistryTreeInputChange getOrCreateSource(String sourceIdentifier) {
        QueryRegistryTreeSource existingSource = this.sources.get(sourceIdentifier);
        if (existingSource == null) {
            QueryRegistryTreeSource newSource = new QueryRegistryTreeSource(this, sourceIdentifier);
            this.sources.put(sourceIdentifier, newSource);
            return new QueryRegistryTreeInputChange(false, null, false, null, true, newSource);
        }
        return new QueryRegistryTreeInputChange(false, null, false, null, false, existingSource);
    }

    public QueryRegistryTreeInputChange getOrCreatePackage(QueryRegistryTreeSource source, String packageName) {
        QueryRegistryTreePackage existingPackage = source.getPackages().get(packageName);
        if (existingPackage == null) {
            QueryRegistryTreePackage newPackage = new QueryRegistryTreePackage(source, packageName);
            source.getPackages().put(packageName, newPackage);
            return new QueryRegistryTreeInputChange(false, null, true, newPackage, false, null);
        }
        return new QueryRegistryTreeInputChange(false, null, false, existingPackage, false, null);
    }

    public String getPackageName(String fullyQualifiedName) {
        return fullyQualifiedName.substring(0, Math.max(0, fullyQualifiedName.lastIndexOf(".")));
    }

    protected TreePath _getTreePath(QueryRegistryTreePackage pckg) {
        QueryRegistryTreeSource _parent = pckg.getParent();
        return new TreePath(new Object[]{_parent, pckg});
    }

    protected TreePath _getTreePath(QueryRegistryTreeEntry entry) {
        return this.getTreePath(entry.getParent()).createChildPath((Object)entry);
    }

    public TreePath getTreePath(Object entry) {
        if (entry instanceof QueryRegistryTreeEntry) {
            return this._getTreePath((QueryRegistryTreeEntry)entry);
        }
        if (entry instanceof QueryRegistryTreePackage) {
            return this._getTreePath((QueryRegistryTreePackage)entry);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(entry).toString());
    }

    @Pure
    public Map<String, QueryRegistryTreeSource> getSources() {
        return this.sources;
    }

    @Pure
    public IQuerySpecificationRegistry getRegistry() {
        return this.registry;
    }

    @Pure
    public IRegistryView getView() {
        return this.view;
    }

    @Pure
    public IQuerySpecificationRegistryChangeListener getListener() {
        return this.listener;
    }
}

