/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.dse.evolutionary.crossovers;

import java.util.Random;
import org.eclipse.viatra.dse.base.ThreadContext;
import org.eclipse.viatra.dse.evolutionary.interfaces.ICrossover;
import org.eclipse.viatra.dse.objectives.TrajectoryFitness;

public class CutAndSpliceCrossover
implements ICrossover {
    private Random random = new Random();
    private Object[] parent1ts;
    private Object[] parent2ts;
    private int p1Size;
    private int p2Size;
    private int index1;
    private int index2;

    @Override
    public boolean mutate(TrajectoryFitness parent1, TrajectoryFitness parent2, ThreadContext context) {
        this.parent1ts = parent1.trajectory;
        this.parent2ts = parent2.trajectory;
        this.p1Size = this.parent1ts.length;
        this.p2Size = this.parent2ts.length;
        if (this.p1Size < 2 || this.p2Size < 2) {
            return false;
        }
        this.index1 = this.random.nextInt(this.p1Size - 1) + 1;
        this.index2 = this.random.nextInt(this.p2Size - 1) + 1;
        context.executeTrajectoryWithMinimalBacktrackWithoutStateCoding(this.parent1ts, this.index1);
        context.executeTrajectoryByTryingWithoutStateCoding(this.parent2ts, this.index2, this.p2Size);
        return true;
    }

    @Override
    public boolean mutateAlternate(TrajectoryFitness parent1, TrajectoryFitness parent2, ThreadContext context) {
        context.executeTrajectoryWithMinimalBacktrackWithoutStateCoding(this.parent2ts, this.index2);
        context.executeTrajectoryByTryingWithoutStateCoding(this.parent1ts, this.index1, this.p1Size);
        return true;
    }

    @Override
    public ICrossover createNew() {
        return new CutAndSpliceCrossover();
    }
}

