/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.plan;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.viatra.query.runtime.localsearch.operations.IIteratingSearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.plan.IPlanDescriptor;
import org.eclipse.viatra.query.runtime.localsearch.planner.util.SearchPlanForBody;
import org.eclipse.viatra.query.runtime.matchers.context.IInputKey;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQueries;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;

public class PlanDescriptor
implements IPlanDescriptor {
    private final PQuery pquery;
    private final List<SearchPlanForBody> plan;
    private final Set<PParameter> adornment;
    private Set<IInputKey> iteratedKeys = null;

    public PlanDescriptor(PQuery pquery, Collection<SearchPlanForBody> plan, Set<PParameter> adornment) {
        this.pquery = pquery;
        this.plan = Collections.unmodifiableList(Lists.newArrayList(plan));
        this.adornment = adornment;
    }

    @Override
    public PQuery getQuery() {
        return this.pquery;
    }

    @Override
    public Iterable<SearchPlanForBody> getPlan() {
        return this.plan;
    }

    @Override
    public Set<PParameter> getAdornment() {
        return this.adornment;
    }

    @Override
    public Set<IInputKey> getIteratedKeys() {
        if (this.iteratedKeys == null) {
            HashSet keys = Sets.newHashSet();
            for (SearchPlanForBody bodyPlan : this.plan) {
                for (ISearchOperation operation : bodyPlan.getCompiledOperations()) {
                    if (!(operation instanceof IIteratingSearchOperation)) continue;
                    keys.add(((IIteratingSearchOperation)operation).getIteratedInputKey());
                }
            }
            this.iteratedKeys = Collections.unmodifiableSet(keys);
        }
        return this.iteratedKeys;
    }

    public String toString() {
        return "Plan for " + this.pquery.getFullyQualifiedName() + "(" + Joiner.on((char)',').join(Iterables.transform(this.adornment, (Function)PQueries.parameterNameFunction())) + "{" + Joiner.on((String)"}\n{").join(Iterables.transform(this.plan, (Function)new Function<SearchPlanForBody, String>(){

            public String apply(SearchPlanForBody input) {
                return input.toString();
            }
        }));
    }
}

