/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.exceptions.LocalSearchException;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.ExtendOperation;

public class ExtendToEStructuralFeatureTarget
extends ExtendOperation<Object> {
    private int sourcePosition;
    private EStructuralFeature feature;

    public ExtendToEStructuralFeatureTarget(int sourcePosition, int targetPosition, EStructuralFeature feature) {
        super(targetPosition);
        this.sourcePosition = sourcePosition;
        this.feature = feature;
    }

    @Override
    public void onInitialize(MatchingFrame frame, ISearchContext context) throws LocalSearchException {
        try {
            EObject value = (EObject)frame.getValue(this.sourcePosition);
            if (!this.feature.getEContainingClass().isSuperTypeOf(value.eClass())) {
                this.it = Collections.emptyIterator();
                return;
            }
            Object featureValue = value.eGet(this.feature);
            if (this.feature.isMany()) {
                if (featureValue != null) {
                    Collection objectCollection = (Collection)featureValue;
                    this.it = objectCollection.iterator();
                } else {
                    this.it = Collections.emptyIterator();
                }
            } else {
                this.it = featureValue != null ? Iterators.singletonIterator((Object)featureValue) : Collections.emptyIterator();
            }
        }
        catch (ClassCastException e) {
            throw new LocalSearchException("Invalid feature source in parameter" + Integer.toString(this.sourcePosition), e);
        }
    }

    public String toString() {
        return "extend    " + this.feature.getEContainingClass().getName() + "." + this.feature.getName() + "(+" + this.sourcePosition + ", -" + this.position + ")";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Lists.asList((Object)this.sourcePosition, (Object)this.position, (Object[])new Integer[0]);
    }
}

