/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.junit4.ide;

import com.google.inject.Inject;
import java.io.InputStream;
import java.util.Collection;
import javax.inject.Provider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.findReferences.IReferenceFinder;
import org.eclipse.xtext.ide.editor.hierarchy.AbstractHierarchyBuilder;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyBuilder;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNode;
import org.eclipse.xtext.ide.editor.hierarchy.IHierarchyNodeReference;
import org.eclipse.xtext.junit4.validation.ValidationTestHelper;
import org.eclipse.xtext.resource.EObjectAtOffsetHelper;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.IResourceDescriptions;
import org.eclipse.xtext.resource.IResourceDescriptionsProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.resource.XtextResourceSet;
import org.eclipse.xtext.ui.editor.findrefs.SimpleLocalResourceAccess;
import org.eclipse.xtext.util.LazyStringInputStream;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.junit.Assert;

public abstract class AbstractHierarchyBuilderTest {
    @Inject
    @Extension
    private ValidationTestHelper _validationTestHelper;
    @Inject
    @Extension
    private EObjectAtOffsetHelper _eObjectAtOffsetHelper;
    @Inject
    private Provider<XtextResourceSet> resourceSetProvider;
    @Inject
    private IResourceDescriptionsProvider resourceDescriptionsProvider;

    protected void testBuildHierarchy(Procedures.Procedure1<? super HierarchyBuilderTestConfiguration> configurator) {
        HierarchyBuilderTestConfiguration configuration = new HierarchyBuilderTestConfiguration();
        configurator.apply((Object)configuration);
        ResourceSet resourceSet = this.createResourceSet(configuration);
        IHierarchyBuilder hierarchyBuilder = (IHierarchyBuilder)configuration.hierarchyBuilderProvider.apply((Object)resourceSet);
        String _xifexpression = null;
        if (configuration.resourceURI == null) {
            Pair _last = (Pair)IterableExtensions.last((Iterable)configuration.models);
            _xifexpression = (String)_last.getKey();
        } else {
            _xifexpression = configuration.resourceURI;
        }
        String resourceURI = _xifexpression;
        URI _createURI = URI.createURI((String)resourceURI);
        Resource _resource = resourceSet.getResource(_createURI, false);
        XtextResource resource = (XtextResource)_resource;
        EObject _resolveElementAt = this._eObjectAtOffsetHelper.resolveElementAt(resource, configuration.index);
        URI rootURI = EcoreUtil2.getPlatformResourceOrNormalizedURI((EObject)_resolveElementAt);
        String actualHierarchy = this.toExpectation(rootURI, hierarchyBuilder);
        Assert.assertEquals((Object)configuration.expectedHierarchy, (Object)actualHierarchy);
    }

    protected ResourceSet createResourceSet(@Extension HierarchyBuilderTestConfiguration configuration) {
        try {
            XtextResourceSet resourceSet = (XtextResourceSet)this.resourceSetProvider.get();
            for (Pair model : configuration.models) {
                String _key = (String)model.getKey();
                URI _createURI = URI.createURI((String)_key);
                Resource resource = resourceSet.createResource(_createURI);
                String _value = (String)model.getValue();
                LazyStringInputStream _lazyStringInputStream = new LazyStringInputStream(_value, "UTF-8");
                resource.load((InputStream)_lazyStringInputStream, null);
                this._validationTestHelper.assertNoIssues(resource);
            }
            return resourceSet;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected <T extends AbstractHierarchyBuilder> T configureBuilderWith(T hierarchyBuilder, ResourceSet resourceSet) {
        SimpleLocalResourceAccess _simpleLocalResourceAccess = new SimpleLocalResourceAccess(resourceSet);
        hierarchyBuilder.setResourceAccess((IReferenceFinder.IResourceAccess)_simpleLocalResourceAccess);
        IResourceDescriptions _resourceDescriptions = this.resourceDescriptionsProvider.getResourceDescriptions(resourceSet);
        hierarchyBuilder.setIndexData(_resourceDescriptions);
        return hierarchyBuilder;
    }

    protected String toExpectation(URI rootURI, IHierarchyBuilder builder) {
        StringConcatenation _builder = new StringConcatenation();
        Collection _buildRoots = builder.buildRoots(rootURI, null);
        for (IHierarchyNode root : _buildRoots) {
            String _expectation = this.toExpectation(root, builder);
            _builder.append((Object)_expectation, "");
            _builder.newLineIfNotEmpty();
        }
        return _builder.toString();
    }

    protected String toExpectation(IHierarchyNode node, IHierarchyBuilder builder) {
        StringConcatenation _builder = new StringConcatenation();
        IEObjectDescription _element = node.getElement();
        _builder.append((Object)_element, "");
        _builder.append((Object)" {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        String _internalToExpectation = this.internalToExpectation(node, builder);
        _builder.append((Object)_internalToExpectation, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder.toString();
    }

    protected String internalToExpectation(IHierarchyNode node, IHierarchyBuilder builder) {
        StringConcatenation _builder = new StringConcatenation();
        Collection _references = node.getReferences();
        for (IHierarchyNodeReference location : _references) {
            String _expectation = this.toExpectation(location);
            _builder.append((Object)_expectation, "");
            _builder.newLineIfNotEmpty();
        }
        boolean _mayHaveChildren = node.mayHaveChildren();
        if (_mayHaveChildren) {
            Collection _buildChildren = builder.buildChildren(node, null);
            for (IHierarchyNode childNode : _buildChildren) {
                String _expectation_1 = this.toExpectation(childNode, builder);
                _builder.append((Object)_expectation_1, "");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder.toString();
    }

    protected String toExpectation(IHierarchyNodeReference location) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"'");
        String _text = location.getText();
        _builder.append((Object)_text, "");
        _builder.append((Object)"' [");
        int _offset = location.getOffset();
        _builder.append((Object)_offset, "");
        _builder.append((Object)", ");
        int _length = location.getLength();
        _builder.append((Object)_length, "");
        _builder.append((Object)"]");
        return _builder.toString();
    }

    @Accessors
    protected static class HierarchyBuilderTestConfiguration {
        private Functions.Function1<? super ResourceSet, ? extends IHierarchyBuilder> hierarchyBuilderProvider;
        private Collection<Pair<String, String>> models = CollectionLiterals.newArrayList((Object[])new Pair[0]);
        private int index;
        private String resourceURI;
        private String expectedHierarchy;

        protected HierarchyBuilderTestConfiguration() {
        }

        @Pure
        public Functions.Function1<? super ResourceSet, ? extends IHierarchyBuilder> getHierarchyBuilderProvider() {
            return this.hierarchyBuilderProvider;
        }

        public void setHierarchyBuilderProvider(Functions.Function1<? super ResourceSet, ? extends IHierarchyBuilder> hierarchyBuilderProvider) {
            this.hierarchyBuilderProvider = hierarchyBuilderProvider;
        }

        @Pure
        public Collection<Pair<String, String>> getModels() {
            return this.models;
        }

        public void setModels(Collection<Pair<String, String>> models) {
            this.models = models;
        }

        @Pure
        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        @Pure
        public String getResourceURI() {
            return this.resourceURI;
        }

        public void setResourceURI(String resourceURI) {
            this.resourceURI = resourceURI;
        }

        @Pure
        public String getExpectedHierarchy() {
            return this.expectedHierarchy;
        }

        public void setExpectedHierarchy(String expectedHierarchy) {
            this.expectedHierarchy = expectedHierarchy;
        }
    }
}

