/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.ide.contentassist;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmExecutable;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmField;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmGenericArrayTypeReference;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmParameterizedTypeReference;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ide.editor.contentassist.ContentAssistEntry;
import org.eclipse.xtext.ide.editor.contentassist.IdeContentProposalCreator;
import org.eclipse.xtext.ide.editor.contentassist.IdeCrossrefProposalProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.scoping.batch.IIdentifiableElementDescription;
import org.eclipse.xtext.xbase.typesystem.references.FunctionTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReferenceFactory;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public class XbaseIdeCrossrefProposalProvider
extends IdeCrossrefProposalProvider {
    @Inject
    private CommonTypeComputationServices typeComputationServices;

    public ContentAssistEntry createProposal(final IEObjectDescription candidate, CrossReference crossRef, final ContentAssistContext context) {
        boolean _hasIdRule = this.hasIdRule(crossRef);
        if (_hasIdRule) {
            final ProposalBracketInfo bracketInfo = this.getProposalBracketInfo(candidate, context);
            IQualifiedNameConverter _qualifiedNameConverter = this.getQualifiedNameConverter();
            QualifiedName _name = candidate.getName();
            String _string = _qualifiedNameConverter.toString(_name);
            final String proposalString = String.valueOf(_string) + bracketInfo.brackets;
            int _xifexpression = 0;
            _xifexpression = candidate instanceof IIdentifiableElementDescription ? ((IIdentifiableElementDescription)candidate).getNumberOfIrrelevantParameters() : 0;
            final int insignificantParameters = _xifexpression;
            XtextResource _resource = context.getResource();
            final LightweightTypeReferenceFactory converter = this.getTypeConverter(_resource);
            final EObject objectOrProxy = candidate.getEObjectOrProxy();
            IdeContentProposalCreator _proposalCreator = this.getProposalCreator();
            Procedures.Procedure1<ContentAssistEntry> _function = new Procedures.Procedure1<ContentAssistEntry>(){

                public void apply(ContentAssistEntry result) {
                    if (objectOrProxy instanceof JvmFeature) {
                        boolean _startsWith = bracketInfo.brackets.startsWith(" =");
                        if (_startsWith) {
                            IQualifiedNameConverter _qualifiedNameConverter = XbaseIdeCrossrefProposalProvider.this.getQualifiedNameConverter();
                            QualifiedName _name = candidate.getName();
                            String _string = _qualifiedNameConverter.toString(_name);
                            String _plus = String.valueOf(_string) + bracketInfo.brackets;
                            XbaseIdeCrossrefProposalProvider.this.addNameAndDescription(result, (JvmFeature)objectOrProxy, false, insignificantParameters, _plus, converter);
                        } else {
                            boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)bracketInfo.brackets);
                            boolean _not = !_isNullOrEmpty;
                            IQualifiedNameConverter _qualifiedNameConverter_1 = XbaseIdeCrossrefProposalProvider.this.getQualifiedNameConverter();
                            QualifiedName _name_1 = candidate.getName();
                            String _string_1 = _qualifiedNameConverter_1.toString(_name_1);
                            XbaseIdeCrossrefProposalProvider.this.addNameAndDescription(result, (JvmFeature)objectOrProxy, _not, insignificantParameters, _string_1, converter);
                        }
                    } else {
                        IQualifiedNameConverter _qualifiedNameConverter_2 = XbaseIdeCrossrefProposalProvider.this.getQualifiedNameConverter();
                        QualifiedName _qualifiedName = candidate.getQualifiedName();
                        String _string_2 = _qualifiedNameConverter_2.toString(_qualifiedName);
                        IQualifiedNameConverter _qualifiedNameConverter_3 = XbaseIdeCrossrefProposalProvider.this.getQualifiedNameConverter();
                        QualifiedName _name_2 = candidate.getName();
                        String _string_3 = _qualifiedNameConverter_3.toString(_name_2);
                        XbaseIdeCrossrefProposalProvider.this.addNameAndDescription(result, objectOrProxy, _string_2, _string_3);
                    }
                    int _offset = context.getOffset();
                    String _prefix = context.getPrefix();
                    int _length = _prefix.length();
                    int _minus = _offset - _length;
                    int _length_1 = proposalString.length();
                    int offset = _minus + _length_1;
                    result.setEscapePosition(Integer.valueOf(offset + bracketInfo.caretOffset));
                    if (bracketInfo.selectionOffset != 0) {
                        int _offset_1 = offset;
                        offset = _offset_1 + bracketInfo.selectionOffset;
                        ArrayList _editPositions = result.getEditPositions();
                        TextRegion _textRegion = new TextRegion(offset, bracketInfo.selectionLength);
                        _editPositions.add(_textRegion);
                    }
                    if (objectOrProxy instanceof JvmExecutable) {
                        StringBuilder parameterList = new StringBuilder();
                        XbaseIdeCrossrefProposalProvider.this.appendParameters(parameterList, (JvmExecutable)objectOrProxy, insignificantParameters, converter);
                    }
                }
            };
            return _proposalCreator.createProposal(proposalString, context, (Procedures.Procedure1)_function);
        }
        return super.createProposal(candidate, crossRef, context);
    }

    protected boolean hasIdRule(CrossReference crossRef) {
        AbstractElement _terminal = crossRef.getTerminal();
        if (_terminal instanceof RuleCall) {
            AbstractElement _terminal_1 = crossRef.getTerminal();
            AbstractRule _rule = ((RuleCall)_terminal_1).getRule();
            String ruleName = _rule.getName();
            return Objects.equal((Object)ruleName, (Object)"IdOrSuper") || Objects.equal((Object)ruleName, (Object)"ValidID") || Objects.equal((Object)ruleName, (Object)"FeatureCallID");
        }
        return false;
    }

    protected ProposalBracketInfo getProposalBracketInfo(IEObjectDescription proposedDescription, ContentAssistContext contentAssistContext) {
        ProposalBracketInfo info = new ProposalBracketInfo();
        if (proposedDescription instanceof IIdentifiableElementDescription) {
            boolean _isExplicitOperationCall;
            JvmIdentifiableElement jvmFeature = ((IIdentifiableElementDescription)proposedDescription).getElementOrProxy();
            if (jvmFeature instanceof JvmExecutable) {
                boolean _equals;
                EList parameters = ((JvmExecutable)jvmFeature).getParameters();
                int _numberOfParameters = ((IIdentifiableElementDescription)proposedDescription).getNumberOfParameters();
                boolean bl = _equals = _numberOfParameters == 1;
                if (_equals) {
                    if (((JvmExecutable)jvmFeature).getSimpleName().startsWith("set") && !((IIdentifiableElementDescription)proposedDescription).getName().getFirstSegment().startsWith("set")) {
                        info.brackets = " = value";
                        int _length = "value".length();
                        int _minus = -_length;
                        info.selectionOffset = _minus;
                        int _length_1 = "value".length();
                        info.selectionLength = _length_1;
                        return info;
                    }
                    JvmFormalParameter _last = (JvmFormalParameter)IterableExtensions.last((Iterable)parameters);
                    JvmTypeReference parameterType = _last.getParameterType();
                    XtextResource _resource = contentAssistContext.getResource();
                    LightweightTypeReferenceFactory _typeConverter = this.getTypeConverter(_resource);
                    LightweightTypeReference light = _typeConverter.toLightweightReference(parameterType);
                    boolean _isFunctionType = light.isFunctionType();
                    if (_isFunctionType) {
                        FunctionTypeReference _asFunctionTypeReference = light.getAsFunctionTypeReference();
                        List _parameterTypes = _asFunctionTypeReference.getParameterTypes();
                        int numParameters = _parameterTypes.size();
                        if (numParameters == 1) {
                            info.brackets = "[]";
                            info.caretOffset = -1;
                            return info;
                        }
                        if (numParameters == 0) {
                            info.brackets = "[|]";
                            info.caretOffset = -1;
                            return info;
                        }
                        StringBuilder b = new StringBuilder();
                        int i = 0;
                        while (i < numParameters) {
                            if (i != 0) {
                                b.append(", ");
                            }
                            b.append("p" + Integer.valueOf(i + 1));
                            ++i;
                        }
                        String _string = b.toString();
                        String _plus = "[" + _string;
                        String _plus_1 = String.valueOf(_plus) + "|]";
                        info.brackets = _plus_1;
                        info.caretOffset = -1;
                        int _length_2 = b.length();
                        int _minus_1 = -_length_2;
                        int _minus_2 = _minus_1 - 2;
                        info.selectionOffset = _minus_2;
                        int _length_3 = b.length();
                        info.selectionLength = _length_3;
                        return info;
                    }
                }
            }
            if (_isExplicitOperationCall = this.isExplicitOperationCall((IIdentifiableElementDescription)proposedDescription)) {
                info.brackets = "()";
                info.selectionOffset = -1;
            }
        }
        return info;
    }

    protected LightweightTypeReferenceFactory getTypeConverter(XtextResource context) {
        StandardTypeReferenceOwner _standardTypeReferenceOwner = new StandardTypeReferenceOwner(this.typeComputationServices, (Resource)context);
        return new LightweightTypeReferenceFactory((ITypeReferenceOwner)_standardTypeReferenceOwner){

            public LightweightTypeReference doVisitParameterizedTypeReference(JvmParameterizedTypeReference reference) {
                LightweightTypeReference result = super.doVisitParameterizedTypeReference(reference);
                boolean _isFunctionType = result.isFunctionType();
                if (_isFunctionType) {
                    return result.tryConvertToFunctionTypeReference(false);
                }
                return result;
            }
        };
    }

    protected void addNameAndDescription(ContentAssistEntry entry, JvmFeature feature, boolean withParents, int insignificantParameters, String shortName, LightweightTypeReferenceFactory converter) {
        StringBuilder labelBuilder = new StringBuilder(shortName);
        StringBuilder descriptionBuilder = new StringBuilder();
        if (feature instanceof JvmOperation) {
            JvmTypeReference returnType;
            if (withParents) {
                labelBuilder.append("(");
                this.appendParameters(labelBuilder, (JvmExecutable)feature, insignificantParameters, converter);
                labelBuilder.append(")");
            }
            if (!Objects.equal((Object)(returnType = ((JvmOperation)feature).getReturnType()), null) && !Objects.equal((Object)returnType.getSimpleName(), null)) {
                labelBuilder.append(" : ");
                LightweightTypeReference _lightweightReference = converter.toLightweightReference(returnType);
                String _humanReadableName = _lightweightReference.getHumanReadableName();
                labelBuilder.append(_humanReadableName);
            }
            JvmDeclaredType _declaringType = ((JvmOperation)feature).getDeclaringType();
            LightweightTypeReference _plainTypeReference = converter.toPlainTypeReference((JvmType)_declaringType);
            String _humanReadableName_1 = _plainTypeReference.getHumanReadableName();
            descriptionBuilder.append(_humanReadableName_1);
            if (!withParents) {
                descriptionBuilder.append(".");
                String _simpleName = ((JvmOperation)feature).getSimpleName();
                descriptionBuilder.append(_simpleName);
                descriptionBuilder.append("()");
            }
        } else if (feature instanceof JvmField) {
            boolean _notEquals;
            labelBuilder.append(" : ");
            JvmTypeReference _type = ((JvmField)feature).getType();
            boolean bl = _notEquals = !Objects.equal((Object)_type, null);
            if (_notEquals) {
                boolean _notEquals_1;
                JvmTypeReference _type_1 = ((JvmField)feature).getType();
                LightweightTypeReference _lightweightReference_1 = converter.toLightweightReference(_type_1);
                String fieldType = _lightweightReference_1.getHumanReadableName();
                boolean bl2 = _notEquals_1 = !Objects.equal((Object)fieldType, null);
                if (_notEquals_1) {
                    labelBuilder.append(fieldType);
                }
            }
            JvmDeclaredType _declaringType_1 = ((JvmField)feature).getDeclaringType();
            LightweightTypeReference _plainTypeReference_1 = converter.toPlainTypeReference((JvmType)_declaringType_1);
            String _humanReadableName_2 = _plainTypeReference_1.getHumanReadableName();
            descriptionBuilder.append(_humanReadableName_2);
        } else if (feature instanceof JvmConstructor && withParents) {
            labelBuilder.append("(");
            this.appendParameters(labelBuilder, (JvmExecutable)feature, insignificantParameters, converter);
            labelBuilder.append(")");
        }
        String _string = labelBuilder.toString();
        entry.setLabel(_string);
        String _string_1 = descriptionBuilder.toString();
        entry.setDescription(_string_1);
    }

    protected void addNameAndDescription(ContentAssistEntry entry, EObject element, String qualifiedNameAsString, String shortName) {
        boolean _greaterThan;
        IQualifiedNameConverter _qualifiedNameConverter = this.getQualifiedNameConverter();
        QualifiedName qualifiedName = _qualifiedNameConverter.toQualifiedName(qualifiedNameAsString);
        int _segmentCount = qualifiedName.getSegmentCount();
        boolean bl = _greaterThan = _segmentCount > 1;
        if (_greaterThan) {
            String _lastSegment = qualifiedName.getLastSegment();
            entry.setLabel(_lastSegment);
            entry.setDescription(qualifiedNameAsString);
        } else {
            entry.setLabel(qualifiedNameAsString);
        }
    }

    protected void appendParameters(StringBuilder result, JvmExecutable executable, int insignificantParameters, LightweightTypeReferenceFactory ownedConverter) {
        EList declaredParameters = executable.getParameters();
        int _size = declaredParameters.size();
        int _min = Math.min(insignificantParameters, _size);
        int _size_1 = declaredParameters.size();
        List relevantParameters = declaredParameters.subList(_min, _size_1);
        int i = 0;
        while (i < relevantParameters.size()) {
            JvmFormalParameter parameter = (JvmFormalParameter)relevantParameters.get(i);
            if (i != 0) {
                result.append(", ");
            }
            if (i == relevantParameters.size() - 1 && executable.isVarArgs() && parameter.getParameterType() instanceof JvmGenericArrayTypeReference) {
                JvmTypeReference _parameterType = parameter.getParameterType();
                JvmGenericArrayTypeReference parameterType = (JvmGenericArrayTypeReference)_parameterType;
                JvmTypeReference _componentType = parameterType.getComponentType();
                LightweightTypeReference _lightweightReference = ownedConverter.toLightweightReference(_componentType);
                String _humanReadableName = _lightweightReference.getHumanReadableName();
                result.append(_humanReadableName);
                result.append("...");
            } else {
                boolean _notEquals;
                JvmTypeReference _parameterType_1 = parameter.getParameterType();
                boolean bl = _notEquals = !Objects.equal((Object)_parameterType_1, null);
                if (_notEquals) {
                    boolean _notEquals_1;
                    JvmTypeReference _parameterType_2 = parameter.getParameterType();
                    LightweightTypeReference _lightweightReference_1 = ownedConverter.toLightweightReference(_parameterType_2);
                    String simpleName = _lightweightReference_1.getHumanReadableName();
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)simpleName, null);
                    if (_notEquals_1) {
                        result.append(simpleName);
                    }
                }
            }
            result.append(" ");
            String _name = parameter.getName();
            String _valueOf = String.valueOf(_name);
            result.append(_valueOf);
            ++i;
        }
    }

    protected boolean isExplicitOperationCall(IIdentifiableElementDescription desc) {
        int _numberOfParameters = desc.getNumberOfParameters();
        return _numberOfParameters > 0;
    }

    public static class ProposalBracketInfo {
        private String brackets = "";
        private int selectionOffset = 0;
        private int selectionLength = 0;
        private int caretOffset = 0;
    }
}

