/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.wizard.project;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.Policy;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;
import org.eclipse.xtext.ui.util.JREContainerProvider;
import org.eclipse.xtext.util.JavaVersion;
import org.eclipse.xtext.xtext.ui.wizard.project.Messages;

public class WizardNewXtextProjectCreationPage
extends WizardNewProjectCreationPage {
    private Text languageNameField;
    private final IStructuredSelection selection;
    private Text extensionsField;
    private Combo breeCombo;
    private Button exeEnvButton;

    public WizardNewXtextProjectCreationPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.selection = selection;
        this.setTitle(Messages.WizardNewXtextProjectCreationPage_WindowTitle);
        this.setDescription(Messages.WizardNewXtextProjectCreationPage_Description);
    }

    public void createControl(Composite parent) {
        String projectsuffix = this.findNextValidProjectSuffix("org.xtext.example", "mydsl");
        this.setInitialProjectName("org.xtext.example." + projectsuffix);
        super.createControl(parent);
        this.createLanguageSelectionGroup((Composite)this.getControl());
        this.creatBreeGroup((Composite)this.getControl());
        this.createWorkingSetGroup((Composite)this.getControl(), this.selection, this.getWorkingSetIdents());
        this.setDefaults(projectsuffix);
        Dialog.applyDialogFont((Control)this.getControl());
    }

    protected void creatBreeGroup(Composite parent) {
        Group breeGroup = new Group(parent, 0);
        breeGroup.setFont(parent.getFont());
        breeGroup.setText(Messages.WizardNewXtextProjectCreationPage_EEGrTitle);
        breeGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        breeGroup.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite((Composite)breeGroup, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        composite.setLayout((Layout)new GridLayout(3, false));
        Label breeLabel = new Label(composite, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 1;
        breeLabel.setText(Messages.WizardNewXtextProjectCreationPage_EECombo);
        this.breeCombo = new Combo(composite, 2056);
        data = new GridData(768);
        data.horizontalSpan = 1;
        this.breeCombo.setLayoutData((Object)data);
        this.breeCombo.setFont(parent.getFont());
        this.fillBreeCombo(this.breeCombo);
        Listener modifyListener = new Listener(){

            public void handleEvent(Event event) {
                WizardNewXtextProjectCreationPage.this.setPageComplete(WizardNewXtextProjectCreationPage.this.validatePage());
            }
        };
        this.breeCombo.addListener(24, modifyListener);
        this.exeEnvButton = new Button(composite, 8);
        this.exeEnvButton.setLayoutData((Object)new GridData());
        this.exeEnvButton.setText(Messages.WizardNewXtextProjectCreationPage_EEButton);
        this.exeEnvButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                PreferencesUtil.createPreferenceDialogOn((Shell)WizardNewXtextProjectCreationPage.this.getShell(), (String)"org.eclipse.jdt.debug.ui.jreProfiles", (String[])new String[]{"org.eclipse.jdt.debug.ui.jreProfiles"}, null).open();
                WizardNewXtextProjectCreationPage.this.fillBreeCombo(WizardNewXtextProjectCreationPage.this.breeCombo);
            }
        });
    }

    protected void fillBreeCombo(Combo comboToFill) {
        HashSet brees = Sets.newHashSet((Object[])new String[]{JREContainerProvider.getDefaultBREE()});
        HashSet availableBrees = Sets.newHashSet();
        IExecutionEnvironment[] iExecutionEnvironmentArray = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
        int n = iExecutionEnvironmentArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExecutionEnvironment ee = iExecutionEnvironmentArray[n2];
            availableBrees.add(ee.getId());
            ++n2;
        }
        iExecutionEnvironmentArray = JavaVersion.values();
        n = iExecutionEnvironmentArray.length;
        n2 = 0;
        while (n2 < n) {
            String bree;
            IExecutionEnvironment supportedVersion = iExecutionEnvironmentArray[n2];
            if (supportedVersion.isAtLeast(JavaVersion.JAVA6) && availableBrees.contains(bree = supportedVersion.getBree())) {
                brees.add(bree);
            }
            ++n2;
        }
        String[] array = brees.toArray(new String[0]);
        Arrays.sort(array, Policy.getComparator());
        String selectionMemento = comboToFill.getText();
        comboToFill.setItems(array);
        int index = comboToFill.indexOf(selectionMemento);
        if (index < 0) {
            comboToFill.select(comboToFill.indexOf(JREContainerProvider.getDefaultBREE()));
        }
        comboToFill.select(index);
    }

    protected String[] getWorkingSetIdents() {
        return new String[]{"org.eclipse.jdt.ui.JavaWorkingSetPage", "org.eclipse.pde.ui.pluginWorkingSet", "org.eclipse.ui.resourceWorkingSetPage"};
    }

    protected void setDefaults(String projectSuffix) {
        this.languageNameField.setText("org.xtext.example." + projectSuffix + ".MyDsl");
        this.extensionsField.setText(projectSuffix);
        this.breeCombo.select(this.breeCombo.indexOf(JREContainerProvider.getDefaultBREE()));
        this.validatePage();
    }

    protected String findNextValidProjectSuffix(String prefix, String name) {
        String candidate = name;
        int suffix = 1;
        while (ResourcesPlugin.getWorkspace().getRoot().getProject((String.valueOf(prefix) + "." + candidate).toLowerCase()).exists()) {
            candidate = String.valueOf(name) + suffix;
            ++suffix;
        }
        return candidate;
    }

    protected boolean validatePage() {
        if (!super.validatePage()) {
            return false;
        }
        IStatus status = JavaConventions.validatePackageName((String)this.getProjectName(), (String)"1.5", (String)"1.5");
        if (!status.isOK()) {
            this.setErrorMessage(String.valueOf(Messages.WizardNewXtextProjectCreationPage_ErrorMessageProjectName) + status.getMessage());
            return false;
        }
        if (this.languageNameField == null) {
            return true;
        }
        if (this.languageNameField.getText().length() == 0) {
            return false;
        }
        status = JavaConventions.validateJavaTypeName((String)this.languageNameField.getText(), (String)"1.5", (String)"1.5");
        if (!status.isOK()) {
            this.setErrorMessage(String.valueOf(Messages.WizardNewXtextProjectCreationPage_ErrorMessageLanguageName) + status.getMessage());
            return false;
        }
        if (this.extensionsField.getText().length() == 0) {
            return false;
        }
        if (!Sets.newHashSet((Iterable)JREContainerProvider.getConfiguredBREEs()).contains(this.breeCombo.getText())) {
            this.setMessage(String.valueOf(Messages.WizardNewXtextProjectCreationPage_eeInfo_0) + this.breeCombo.getText() + Messages.WizardNewXtextProjectCreationPage_eeInfo_1, 1);
            return true;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    protected void createLanguageSelectionGroup(Composite parent) {
        Group languageGroup = new Group(parent, 0);
        languageGroup.setFont(parent.getFont());
        languageGroup.setText(Messages.WizardNewXtextProjectCreationPage_LabelLanguage);
        languageGroup.setLayoutData((Object)new GridData(4, 128, true, false));
        languageGroup.setLayout((Layout)new GridLayout(1, false));
        Composite composite = new Composite((Composite)languageGroup, 0);
        composite.setLayoutData((Object)new GridData(4, 128, true, false));
        composite.setLayout((Layout)new GridLayout(2, false));
        Label languageLabel = new Label(composite, 0);
        GridData data = new GridData(768);
        data.horizontalSpan = 1;
        languageLabel.setText(Messages.WizardNewXtextProjectCreationPage_LabelName);
        this.languageNameField = new Text(composite, 2048);
        data = new GridData(768);
        data.horizontalSpan = 1;
        this.languageNameField.setLayoutData((Object)data);
        this.languageNameField.setFont(parent.getFont());
        Label extensionsLabel = new Label(composite, 0);
        extensionsLabel.setText(Messages.WizardNewXtextProjectCreationPage_LabelExtensions);
        this.extensionsField = new Text(composite, 2048);
        GridData textData = new GridData(4, 0x1000000, true, false);
        textData.horizontalSpan = 1;
        textData.horizontalIndent = 0;
        this.extensionsField.setLayoutData((Object)textData);
        Listener modifyListener = new Listener(){

            public void handleEvent(Event event) {
                WizardNewXtextProjectCreationPage.this.setPageComplete(WizardNewXtextProjectCreationPage.this.validatePage());
            }
        };
        this.languageNameField.addListener(24, modifyListener);
        this.extensionsField.addListener(24, modifyListener);
    }

    public String getFileExtensions() {
        return this.extensionsField.getText();
    }

    public String getLanguageName() {
        return this.languageNameField.getText();
    }

    public JavaVersion getJavaVersion() {
        String selected = this.breeCombo.getText();
        JavaVersion version = JavaVersion.fromBree((String)selected);
        return version;
    }
}

