/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.ui.text.java.AbstractJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.BoldStylerProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Image;

public class JavaCompletionProposal
extends AbstractJavaCompletionProposal {
    public JavaCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, String displayString, int relevance) {
        this(replacementString, replacementOffset, replacementLength, image, new StyledString(displayString), relevance, false);
    }

    public JavaCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, StyledString displayString, int relevance) {
        this(replacementString, replacementOffset, replacementLength, image, displayString, relevance, false);
    }

    public JavaCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, StyledString displayString, int relevance, boolean inJavadoc) {
        this(replacementString, replacementOffset, replacementLength, image, displayString, relevance, inJavadoc, null);
    }

    public JavaCompletionProposal(String replacementString, int replacementOffset, int replacementLength, Image image, StyledString displayString, int relevance, boolean inJavadoc, JavaContentAssistInvocationContext invocationContext) {
        super(invocationContext);
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        this.setReplacementString(replacementString);
        this.setReplacementOffset(replacementOffset);
        this.setReplacementLength(replacementLength);
        this.setImage(image);
        this.setStyledDisplayString(displayString == null ? new StyledString(replacementString) : displayString);
        this.setRelevance(relevance);
        this.setCursorPosition(replacementString.length());
        this.setInJavadoc(inJavadoc);
        this.setSortString(displayString == null ? replacementString : displayString.getString());
    }

    @Override
    protected boolean isValidPrefix(String prefix) {
        String word = TextProcessor.deprocess((String)this.getDisplayString());
        if (this.isInJavadoc()) {
            if (word.indexOf("{@link ") == 0) {
                word = word.substring(7);
            } else if (word.indexOf("{@value ") == 0) {
                word = word.substring(8);
            } else if (word.indexOf(60) == 0) {
                boolean isClosing;
                boolean bl = isClosing = (word = word.substring(1)).indexOf(47) == 0;
                if (isClosing) {
                    word = word.substring(1);
                }
                if (prefix.indexOf(60) == 0) {
                    prefix = prefix.substring(1);
                    if (isClosing && prefix.indexOf(47) == 0) {
                        prefix = prefix.substring(1);
                    }
                }
            }
        } else if (word.indexOf("this.") != -1) {
            word = word.substring(word.indexOf("this.") + 5);
        }
        return this.isPrefix(prefix, word);
    }

    @Override
    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        String string = this.getReplacementString();
        int pos = string.indexOf(40);
        if (pos > 0) {
            return string.subSequence(0, pos);
        }
        if (string.startsWith("this.")) {
            return string.substring(5);
        }
        return string;
    }

    @Override
    public StyledString getStyledDisplayString(IDocument document, int offset, BoldStylerProvider boldStylerProvider) {
        StyledString styledDisplayString = new StyledString();
        styledDisplayString.append(this.getStyledDisplayString());
        String displayString = styledDisplayString.getString();
        if (this.isInJavadoc() && displayString.indexOf(60) == 0) {
            String pattern;
            boolean isClosing;
            boolean bl = isClosing = (displayString = displayString.substring(1)).indexOf(47) == 0;
            if (isClosing) {
                displayString = displayString.substring(1);
            }
            if ((pattern = this.getPatternToEmphasizeMatch(document, offset)) != null && pattern.length() > 0) {
                int patternMatchRule;
                int[] matchingRegions;
                if (pattern.indexOf(60) == 0) {
                    pattern = pattern.substring(1);
                    if (isClosing && pattern.indexOf(47) == 0) {
                        pattern = pattern.substring(1);
                        Strings.markMatchingRegions(styledDisplayString, 0, new int[]{1, 1}, boldStylerProvider.getBoldStyler());
                    }
                    int[] nArray = new int[2];
                    nArray[1] = 1;
                    Strings.markMatchingRegions(styledDisplayString, 0, nArray, boldStylerProvider.getBoldStyler());
                }
                if ((matchingRegions = SearchPattern.getMatchingRegions((String)pattern, (String)displayString, (int)(patternMatchRule = this.getPatternMatchRule(pattern, displayString)))) != null) {
                    int inc = isClosing ? 2 : 1;
                    int i = 0;
                    while (i < matchingRegions.length) {
                        matchingRegions[i] = matchingRegions[i] + inc;
                        i += 2;
                    }
                }
                Strings.markMatchingRegions(styledDisplayString, 0, matchingRegions, boldStylerProvider.getBoldStyler());
            }
            return styledDisplayString;
        }
        return super.getStyledDisplayString(document, offset, boldStylerProvider);
    }
}

