/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.wizards.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionStatusDialog;
import org.eclipse.ui.internal.misc.StringMatcher;
import org.eclipse.viatra.query.tooling.ui.wizards.internal.ElementSelectionDialogContentProvider;

public class ElementSelectionDialog
extends SelectionStatusDialog {
    private StyledCellLabelProvider labelProvider;
    private IStructuredContentProvider contentProvider;
    private TableViewer tableViewer;
    private List<Object> elements;
    private String filter = "";
    private Text filterText;
    private String header;
    private ImportFilter importFilter;

    public ElementSelectionDialog(Shell parent, StyledCellLabelProvider labelProvider, String header) {
        super(parent);
        this.labelProvider = labelProvider;
        this.contentProvider = new ElementSelectionDialogContentProvider();
        this.elements = new ArrayList<Object>();
        this.header = header;
    }

    public void setElements(Object[] elements) {
        this.elements.clear();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            this.elements.add(element);
            ++n2;
        }
    }

    protected void computeResult() {
        TableItem[] selection = this.tableViewer.getTable().getSelection();
        ArrayList<Object> result = new ArrayList<Object>();
        TableItem[] tableItemArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            result.add(item.getData());
            ++n2;
        }
        this.setResult(result);
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createMessageArea(contents);
        this.createFilterText(contents);
        this.createElementTable(contents);
        return contents;
    }

    private void createElementTable(Composite parent) {
        this.tableViewer = new TableViewer(parent, 68354);
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.importFilter = new ImportFilter();
        this.tableViewer.addFilter((ViewerFilter)this.importFilter);
        TableViewerColumn column = new TableViewerColumn(this.tableViewer, 0);
        column.getColumn().setWidth(400);
        column.getColumn().setText(this.header);
        column.setLabelProvider((CellLabelProvider)this.labelProvider);
        final Table table = this.tableViewer.getTable();
        table.setLayoutData((Object)new GridData(1808));
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (table.getSelectionCount() > 0) {
                    ElementSelectionDialog.this.okPressed();
                }
            }
        });
        this.tableViewer.setComparator(new ViewerComparator(){});
        this.tableViewer.setInput(this.elements);
    }

    protected Text createFilterText(Composite parent) {
        Text text = new Text(parent, 2048);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        text.setLayoutData((Object)data);
        text.setFont(parent.getFont());
        text.setText(this.filter == null ? "" : this.filter);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                ElementSelectionDialog.this.importFilter.filterString = ElementSelectionDialog.this.filterText.getText();
                ElementSelectionDialog.this.tableViewer.refresh();
            }
        };
        text.addListener(24, listener);
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    ElementSelectionDialog.this.tableViewer.getTable().setFocus();
                }
            }
        });
        this.filterText = text;
        return text;
    }

    public int open() {
        super.open();
        return this.getReturnCode();
    }

    private static class ImportFilter
    extends ViewerFilter {
        private String filterString = "";

        private ImportFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            StringMatcher matcher = new StringMatcher("*" + this.filterString + "*", true, false);
            String label = element == null ? "" : element.toString();
            return matcher.match(label);
        }
    }
}

