/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.rules;

import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Set;
import org.eclipse.viatra.examples.cps.deployment.DeploymentHost;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.queries.MonitoredHostInstanceMatch;
import org.eclipse.viatra.examples.cps.xform.m2m.incr.expl.rules.AbstractRule;
import org.eclipse.viatra.query.runtime.api.IMatchProcessor;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.transformation.evm.api.ActivationLifeCycle;
import org.eclipse.viatra.transformation.evm.api.Job;
import org.eclipse.viatra.transformation.evm.api.RuleSpecification;
import org.eclipse.viatra.transformation.evm.specific.Jobs;
import org.eclipse.viatra.transformation.evm.specific.Lifecycles;
import org.eclipse.viatra.transformation.evm.specific.Rules;
import org.eclipse.viatra.transformation.evm.specific.crud.CRUDActivationStateEnum;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class HostUpdate
extends AbstractRule<MonitoredHostInstanceMatch> {
    public HostUpdate(ViatraQueryEngine engine) {
        super(engine);
    }

    @Override
    public RuleSpecification<MonitoredHostInstanceMatch> getSpecification() {
        try {
            Job<MonitoredHostInstanceMatch> _appearedJob = this.getAppearedJob();
            Job<MonitoredHostInstanceMatch> _disappearedJob = this.getDisappearedJob();
            Job<MonitoredHostInstanceMatch> _updatedJob = this.getUpdatedJob();
            return Rules.newMatcherRuleSpecification((IQuerySpecification)this.cpsXformM2M.getMonitoredHostInstance(), (ActivationLifeCycle)Lifecycles.getDefault((boolean)true, (boolean)true), Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Job[]{_appearedJob, _disappearedJob, _updatedJob})));
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    private Job<MonitoredHostInstanceMatch> getAppearedJob() {
        IMatchProcessor<MonitoredHostInstanceMatch> _function = new IMatchProcessor<MonitoredHostInstanceMatch>(){

            public void process(MonitoredHostInstanceMatch match) {
                String hostIp = match.getHostInstance().getNodeIp();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Starting monitoring mapped host with IP: ");
                _builder.append((Object)hostIp);
                HostUpdate.this.logger.debug((Object)_builder);
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.CREATED, (IMatchProcessor)_function);
    }

    private Job<MonitoredHostInstanceMatch> getDisappearedJob() {
        IMatchProcessor<MonitoredHostInstanceMatch> _function = new IMatchProcessor<MonitoredHostInstanceMatch>(){

            public void process(MonitoredHostInstanceMatch match) {
                String hostIp = match.getHostInstance().getNodeIp();
                StringConcatenation _builder = new StringConcatenation();
                _builder.append((Object)"Stopped monitoring mapped host with IP: ");
                _builder.append((Object)hostIp);
                HostUpdate.this.logger.debug((Object)_builder);
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.DELETED, (IMatchProcessor)_function);
    }

    private Job<MonitoredHostInstanceMatch> getUpdatedJob() {
        IMatchProcessor<MonitoredHostInstanceMatch> _function = new IMatchProcessor<MonitoredHostInstanceMatch>(){

            public void process(MonitoredHostInstanceMatch match) {
                try {
                    final String hostIp = match.getHostInstance().getNodeIp();
                    StringConcatenation _builder = new StringConcatenation();
                    _builder.append((Object)"Updating mapped host with IP: ");
                    _builder.append((Object)hostIp);
                    HostUpdate.this.logger.debug((Object)_builder);
                    Set<DeploymentHost> depHosts = HostUpdate.this.cpsXformM2M.getMappedHostInstance(HostUpdate.this.engine).getAllValuesOfdepHost(match.getHostInstance());
                    Procedures.Procedure1<DeploymentHost> _function = new Procedures.Procedure1<DeploymentHost>(){

                        public void apply(DeploymentHost it) {
                            boolean _notEquals;
                            String nodeIp = it.getIp();
                            boolean bl = _notEquals = !Objects.equal((Object)nodeIp, (Object)hostIp);
                            if (_notEquals) {
                                StringConcatenation _builder = new StringConcatenation();
                                _builder.append((Object)"IP changed to ");
                                _builder.append((Object)hostIp);
                                (this).HostUpdate.this.logger.trace((Object)_builder);
                                it.setIp(hostIp);
                            }
                        }
                    };
                    IterableExtensions.forEach(depHosts, (Procedures.Procedure1)_function);
                    StringConcatenation _builder_1 = new StringConcatenation();
                    _builder_1.append((Object)"Updated mapped host with IP: ");
                    _builder_1.append((Object)hostIp);
                    HostUpdate.this.logger.debug((Object)_builder_1);
                }
                catch (Throwable _e) {
                    throw Exceptions.sneakyThrow((Throwable)_e);
                }
            }
        };
        return Jobs.newStatelessJob((CRUDActivationStateEnum)CRUDActivationStateEnum.UPDATED, (IMatchProcessor)_function);
    }
}

