/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.matchers.planning;

import com.google.common.base.Joiner;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.viatra.query.runtime.matchers.context.IQueryMetaContext;
import org.eclipse.viatra.query.runtime.matchers.planning.helpers.TypeHelper;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.POperation;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PProject;
import org.eclipse.viatra.query.runtime.matchers.planning.operations.PStart;
import org.eclipse.viatra.query.runtime.matchers.psystem.PBody;
import org.eclipse.viatra.query.runtime.matchers.psystem.PConstraint;
import org.eclipse.viatra.query.runtime.matchers.psystem.PVariable;
import org.eclipse.viatra.query.runtime.matchers.psystem.TypeJudgement;

public class SubPlan {
    private PBody body;
    private List<? extends SubPlan> parentPlans;
    private POperation operation;
    private final Set<PVariable> visibleVariables;
    private final Set<PVariable> allVariables;
    private final Set<PVariable> introducedVariables;
    private Set<PConstraint> allConstraints;
    private Set<PConstraint> deltaConstraints;
    private Set<PConstraint> externallyInferredConstraints;
    private WeakHashMap<IQueryMetaContext, Set<TypeJudgement>> allImpliedTypeJudgements = new WeakHashMap();

    public SubPlan(PBody body, POperation operation, SubPlan ... parentPlans) {
        this(body, operation, Arrays.asList(parentPlans));
    }

    public SubPlan(PBody body, POperation operation, List<? extends SubPlan> parentPlans) {
        this.body = body;
        this.parentPlans = parentPlans;
        this.operation = operation;
        this.externallyInferredConstraints = new HashSet<PConstraint>();
        this.deltaConstraints = new HashSet<PConstraint>(operation.getDeltaConstraints());
        this.allVariables = new HashSet<PVariable>();
        for (PConstraint pConstraint : this.deltaConstraints) {
            this.allVariables.addAll(pConstraint.getDeducedVariables());
        }
        this.allConstraints = new HashSet<PConstraint>(this.deltaConstraints);
        for (SubPlan subPlan : parentPlans) {
            this.allConstraints.addAll(subPlan.getAllEnforcedConstraints());
            this.allVariables.addAll(subPlan.getAllDeducedVariables());
        }
        if (operation instanceof PStart) {
            this.visibleVariables = new HashSet<PVariable>(((PStart)operation).getAPrioriVariables());
            this.allVariables.addAll(this.visibleVariables);
        } else if (operation instanceof PProject) {
            this.visibleVariables = new HashSet<PVariable>(((PProject)operation).getToVariables());
        } else {
            this.visibleVariables = new HashSet<PVariable>();
            for (SubPlan subPlan : parentPlans) {
                this.visibleVariables.addAll(subPlan.getVisibleVariables());
            }
            for (PConstraint pConstraint : this.deltaConstraints) {
                this.visibleVariables.addAll(pConstraint.getDeducedVariables());
            }
        }
        this.introducedVariables = new HashSet<PVariable>(this.visibleVariables);
        if (!parentPlans.isEmpty()) {
            this.introducedVariables.removeAll(parentPlans.get(0).getVisibleVariables());
        }
        operation.checkConsistency(this);
    }

    public String toString() {
        return this.toLongString();
    }

    public String toShortString() {
        return String.format("Plan{%s}:%s", Joiner.on((char)',').join(this.visibleVariables), this.operation.getShortName());
    }

    public String toLongString() {
        return String.format("%s<%s>", this.toShortString(), Joiner.on((String)"; ").join(this.parentPlans));
    }

    public Set<PConstraint> getAllEnforcedConstraints() {
        return this.allConstraints;
    }

    public Set<PConstraint> getDeltaEnforcedConstraints() {
        return this.deltaConstraints;
    }

    public void inferConstraint(PConstraint constraint) {
        this.externallyInferredConstraints.add(constraint);
        this.deltaConstraints.add(constraint);
        this.allConstraints.add(constraint);
    }

    public PBody getBody() {
        return this.body;
    }

    public Set<PVariable> getVisibleVariables() {
        return this.visibleVariables;
    }

    public Set<PVariable> getAllDeducedVariables() {
        return this.allVariables;
    }

    public Set<PVariable> getIntroducedVariables() {
        return this.introducedVariables;
    }

    public List<? extends SubPlan> getParentPlans() {
        return this.parentPlans;
    }

    public POperation getOperation() {
        return this.operation;
    }

    public Set<TypeJudgement> getAllImpliedTypeJudgements(IQueryMetaContext context) {
        Set<TypeJudgement> impliedJudgements = this.allImpliedTypeJudgements.get(context);
        if (impliedJudgements == null) {
            Set<TypeJudgement> equivalentJudgements = TypeHelper.getDirectJudgements(this.getAllEnforcedConstraints(), context);
            impliedJudgements = TypeHelper.typeClosure(equivalentJudgements, context);
            this.allImpliedTypeJudgements.put(context, impliedJudgements);
        }
        return impliedJudgements;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        result = 31 * result + (this.parentPlans == null ? 0 : this.parentPlans.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubPlan)) {
            return false;
        }
        SubPlan other = (SubPlan)obj;
        if (this.operation == null ? other.operation != null : !this.operation.equals(other.operation)) {
            return false;
        }
        return !(this.parentPlans == null ? other.parentPlans != null : !this.parentPlans.equals(other.parentPlans));
    }
}

