/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.retevis.views;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.layout.ILayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.SpringLayoutAlgorithm;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ui.IViewPart;
import org.eclipse.viatra.addon.viewers.runtime.extensions.ViewersComponentConfiguration;
import org.eclipse.viatra.addon.viewers.runtime.model.ViatraViewerDataModel;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerDataFilter;
import org.eclipse.viatra.addon.viewers.runtime.model.ViewerState;
import org.eclipse.viatra.addon.viewers.runtime.zest.extensions.ViatraViewersZestViewSupport;
import org.eclipse.viatra.addon.viewers.runtime.zest.sources.ZestContentProvider;
import org.eclipse.viatra.integration.zest.viewer.ModifiableZestContentViewer;
import org.eclipse.viatra.query.runtime.api.AdvancedViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.IModelConnectorTypeEnum;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngine;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.base.api.BaseIndexOptions;
import org.eclipse.viatra.query.runtime.emf.EMFScope;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryBackendFactory;
import org.eclipse.viatra.query.runtime.matchers.planning.QueryProcessingException;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.rete.matcher.ReteBackendFactory;
import org.eclipse.viatra.query.runtime.rete.matcher.ReteEngine;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.recipes.BetaRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.IndexerBasedAggregatorRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.IndexerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.MultiParentNodeRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.ProductionRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.ProjectionIndexerRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.ReteNodeRecipe;
import org.eclipse.viatra.query.runtime.rete.recipes.SingleParentNodeRecipe;
import org.eclipse.viatra.query.runtime.rete.traceability.RecipeTraceInfo;
import org.eclipse.viatra.query.tooling.ui.ViatraQueryGUIPlugin;
import org.eclipse.viatra.query.tooling.ui.retevis.views.ReteVisualizationLabelProvider;
import org.eclipse.viatra.query.tooling.ui.util.IFilteredMatcherContent;

public class ReteVisualizationViewSupport
extends ViatraViewersZestViewSupport {
    private Map<ReteNodeRecipe, Node> nodeTrace = Maps.newHashMap();

    public ReteVisualizationViewSupport(IViewPart _owner, ViewersComponentConfiguration _config, ModifiableZestContentViewer _graphViewer) {
        super(_owner, _config, IModelConnectorTypeEnum.RESOURCESET, _graphViewer);
    }

    protected void init() {
        super.init();
        this.getGraphViewer().setLayoutAlgorithm((ILayoutAlgorithm)new SpringLayoutAlgorithm());
    }

    protected EMFScope extractModelSource(List<Object> objects) throws ViatraQueryException {
        HashMap recipeToReteMap = Maps.newHashMap();
        Set<ReteNodeRecipe> recipeSet = this.computeRecipeSet(objects, recipeToReteMap);
        this.nodeTrace = recipeToReteMap;
        return this.createRecipeModel(recipeSet);
    }

    private Set<ReteNodeRecipe> computeRecipeSet(List<Object> objects, Map<ReteNodeRecipe, Node> recipeToReteMap) {
        HashSet recipeSet = Sets.newHashSet();
        for (IFilteredMatcherContent patternMatcherContent : Iterables.filter(objects, IFilteredMatcherContent.class)) {
            try {
                ViatraQueryMatcher matcher = patternMatcherContent.getMatcher();
                if (matcher == null) continue;
                ReteEngine reteEngine = (ReteEngine)((AdvancedViatraQueryEngine)matcher.getEngine()).getQueryBackend((IQueryBackendFactory)new ReteBackendFactory());
                if (recipeToReteMap.isEmpty()) {
                    Map<ReteNodeRecipe, Node> computeNodeTrace = this.computeNodeTrace(reteEngine);
                    recipeToReteMap.putAll(computeNodeTrace);
                }
                PQuery pQuery = matcher.getSpecification().getInternalQueryRepresentation();
                RecipeTraceInfo traceInfo = reteEngine.getBoundary().accessProductionTrace(pQuery);
                ReteNodeRecipe recipe = traceInfo.getRecipe();
                Set<ReteNodeRecipe> parents = this.getRecipeNodeParents(recipe);
                parents.add(recipe);
                recipeSet.addAll(parents);
            }
            catch (ViatraQueryException | QueryProcessingException e) {
                throw new RuntimeException("Failed to get query backend", e);
            }
        }
        return recipeSet;
    }

    private Map<ReteNodeRecipe, Node> computeNodeTrace(ReteEngine reteEngine) {
        HashMap recipeToNodeMap = Maps.newHashMap();
        Set recipeTraces = reteEngine.getReteNet().getRecipeTraces();
        for (RecipeTraceInfo info : recipeTraces) {
            Node node = info.getNode();
            ReteNodeRecipe recipe = info.getRecipe();
            ReteNodeRecipe shadowedRecipe = info.getShadowedRecipe();
            recipeToNodeMap.put(recipe, node);
            if (shadowedRecipe == null) continue;
            recipeToNodeMap.put(shadowedRecipe, node);
        }
        return recipeToNodeMap;
    }

    private EMFScope createRecipeModel(Set<ReteNodeRecipe> recipeSet) throws ViatraQueryException {
        if (recipeSet.isEmpty()) {
            return null;
        }
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        Resource resource = resourceSet.createResource(URI.createURI((String)"temp"));
        Iterable roots = Iterables.transform(recipeSet, (Function)new Function<ReteNodeRecipe, EObject>(){

            public EObject apply(ReteNodeRecipe input) {
                return EcoreUtil.getRootContainer((EObject)input);
            }
        });
        resource.getContents().addAll((Collection)Sets.newHashSet((Iterable)roots));
        return new EMFScope((Notifier)resourceSet, new BaseIndexOptions());
    }

    private Set<ReteNodeRecipe> getRecipeNodeParents(ReteNodeRecipe recipe) {
        HashSet parents = Sets.newHashSet();
        this.collectRecipeNodeParents(recipe, parents, true);
        return parents;
    }

    private void collectRecipeNodeParents(ReteNodeRecipe recipe, Set<ReteNodeRecipe> parents, boolean isRootRecipe) {
        Set<ReteNodeRecipe> nextParentsToCollect = this.getImmediateParentsOfRecipe(recipe, isRootRecipe);
        for (ReteNodeRecipe reteNodeRecipe : nextParentsToCollect) {
            boolean added = parents.add(reteNodeRecipe);
            if (!added) continue;
            this.collectRecipeNodeParents(reteNodeRecipe, parents, false);
        }
    }

    private Set<ReteNodeRecipe> getImmediateParentsOfRecipe(ReteNodeRecipe recipe, boolean isRootRecipe) {
        HashSet nextParentsToCollect = Sets.newHashSet();
        if (recipe instanceof IndexerBasedAggregatorRecipe) {
            ProjectionIndexerRecipe aggregatorParent = ((IndexerBasedAggregatorRecipe)recipe).getParent();
            nextParentsToCollect.add(aggregatorParent);
        } else if (recipe instanceof BetaRecipe) {
            ProjectionIndexerRecipe leftParent = ((BetaRecipe)recipe).getLeftParent();
            nextParentsToCollect.add(leftParent);
            IndexerRecipe rightParent = ((BetaRecipe)recipe).getRightParent();
            nextParentsToCollect.add(rightParent);
        } else if (recipe instanceof MultiParentNodeRecipe) {
            boolean traverseProductionRecipe;
            boolean isProductionRecipe = recipe instanceof ProductionRecipe;
            boolean traverseSubpatternCallMode = ViatraQueryGUIPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.viatra.query.tooling.ui.retevis.displayCalledNetworks");
            boolean bl = traverseProductionRecipe = isRootRecipe || traverseSubpatternCallMode;
            if (!isProductionRecipe || traverseProductionRecipe) {
                EList multiParentNodeParents = ((MultiParentNodeRecipe)recipe).getParents();
                nextParentsToCollect.addAll(multiParentNodeParents);
            }
        } else if (recipe instanceof SingleParentNodeRecipe) {
            ReteNodeRecipe reteNodeRecipeParent = ((SingleParentNodeRecipe)recipe).getParent();
            nextParentsToCollect.add(reteNodeRecipeParent);
        }
        return nextParentsToCollect;
    }

    protected void bindModel() {
        ViatraQueryEngine engine;
        Assert.isNotNull((Object)this.configuration);
        Assert.isNotNull((Object)this.configuration.getPatterns());
        if (this.state != null && !this.state.isDisposed()) {
            this.state.dispose();
        }
        if ((engine = this.getEngine()) != null) {
            this.state = ViatraViewerDataModel.newViewerState((ViatraQueryEngine)engine, (Collection)this.configuration.getPatterns(), (ViewerDataFilter)this.configuration.getFilter(), (Collection)ImmutableSet.of((Object)ViewerState.ViewerStateFeature.EDGE, (Object)ViewerState.ViewerStateFeature.CONTAINMENT));
            ModifiableZestContentViewer viewer = (ModifiableZestContentViewer)this.jfaceViewer;
            viewer.setContentProvider((IContentProvider)new ZestContentProvider());
            viewer.setLabelProvider((IBaseLabelProvider)new ReteVisualizationLabelProvider(this.state, this.nodeTrace, viewer.getControl().getDisplay()));
            viewer.setInput((Object)this.state);
        }
    }
}

