/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.rete.index;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuples;
import org.eclipse.viatra.query.runtime.rete.index.IndexerListener;
import org.eclipse.viatra.query.runtime.rete.index.SpecializedProjectionIndexer;
import org.eclipse.viatra.query.runtime.rete.network.Direction;
import org.eclipse.viatra.query.runtime.rete.network.Node;
import org.eclipse.viatra.query.runtime.rete.network.ReteContainer;
import org.eclipse.viatra.query.runtime.rete.network.Supplier;

public abstract class NullIndexer
extends SpecializedProjectionIndexer {
    static Tuple nullSignature = Tuples.staticArityFlatTupleOf();
    static Collection<Tuple> nullSingleton = Collections.singleton(nullSignature);
    static Collection<Tuple> emptySet = Collections.emptySet();

    protected abstract Collection<Tuple> getTuples();

    public NullIndexer(ReteContainer reteContainer, int tupleWidth, Supplier parent, Node activeNode, List<SpecializedProjectionIndexer.ListenerSubscription> sharedSubscriptionList) {
        super(reteContainer, TupleMask.linear((int)0, (int)tupleWidth), parent, activeNode, sharedSubscriptionList);
    }

    @Override
    public Collection<Tuple> get(Tuple signature) {
        if (nullSignature.equals((Object)signature)) {
            return this.isEmpty() ? null : this.getTuples();
        }
        return null;
    }

    @Override
    public Collection<Tuple> getSignatures() {
        return this.isEmpty() ? emptySet : nullSingleton;
    }

    protected boolean isEmpty() {
        return this.getTuples().isEmpty();
    }

    protected boolean isSingleElement() {
        return this.getTuples().size() == 1;
    }

    @Override
    public Iterator<Tuple> iterator() {
        return this.getTuples().iterator();
    }

    @Override
    public void propagateToListener(IndexerListener listener, Direction direction, Tuple updateElement) {
        boolean radical = direction == Direction.REVOKE && this.isEmpty() || direction == Direction.INSERT && this.isSingleElement();
        listener.notifyIndexerUpdate(direction, updateElement, nullSignature, radical);
    }
}

