/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.generator.utils;

import com.google.common.base.Objects;
import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eclipse.viatra.examples.cps.cyberPhysicalSystem.CyberPhysicalSystem;
import org.eclipse.viatra.examples.cps.generator.CPSPlanBuilder;
import org.eclipse.viatra.examples.cps.generator.CPSPlans;
import org.eclipse.viatra.examples.cps.generator.dtos.CPSFragment;
import org.eclipse.viatra.examples.cps.generator.dtos.CPSGeneratorInput;
import org.eclipse.viatra.examples.cps.generator.dtos.GeneratorPlan;
import org.eclipse.viatra.examples.cps.generator.dtos.constraints.ICPSConstraints;
import org.eclipse.viatra.examples.cps.generator.dtos.constraints.IConstraints;
import org.eclipse.viatra.examples.cps.generator.utils.CPSModelBuilderUtil;
import org.eclipse.viatra.examples.cps.planexecutor.PlanExecutor;
import org.eclipse.viatra.examples.cps.planexecutor.api.IPlan;
import org.eclipse.viatra.examples.cps.planexecutor.api.Initializer;
import org.eclipse.viatra.examples.cps.traceability.CPSToDeployment;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;

public class CPSGeneratorBuilder {
    @Extension
    protected static Logger logger = Logger.getLogger((String)"cps.generator.impl.CPSGeneratorBuilder");

    public static CPSFragment buildAndGenerateModel(long seed, ICPSConstraints constraints) {
        return CPSGeneratorBuilder.buildAndGenerateModel(seed, constraints, CPSPlans.DEFAULT);
    }

    public static CPSFragment buildAndGenerateModel(long seed, ICPSConstraints constraints, CPSPlans cpsplan) {
        try {
            CPSModelBuilderUtil mb = new CPSModelBuilderUtil();
            long _nanoTime = System.nanoTime();
            String _plus = "testModel" + Long.valueOf(_nanoTime);
            CPSToDeployment cps2dep = mb.prepareEmptyModel(_plus);
            if (!Objects.equal((Object)cps2dep, null) && !Objects.equal((Object)cps2dep.getCps(), null)) {
                return CPSGeneratorBuilder.buildAndGenerateModel(seed, constraints, cps2dep.getCps(), cpsplan);
            }
            logger.info((Object)"!!! Error: Cannot create CPS model");
            CPSGeneratorInput _cPSGeneratorInput = new CPSGeneratorInput(seed, (IConstraints)constraints, null);
            return new CPSFragment(_cPSGeneratorInput);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static CPSFragment buildAndGenerateModel(long seed, ICPSConstraints constraints, CyberPhysicalSystem model) {
        return CPSGeneratorBuilder.buildAndGenerateModel(seed, constraints, model, CPSPlans.DEFAULT);
    }

    public static CPSFragment buildAndGenerateModel(long seed, ICPSConstraints constraints, CyberPhysicalSystem model, CPSPlans cpsplan) {
        CPSGeneratorInput input = new CPSGeneratorInput(seed, (IConstraints)constraints, model);
        GeneratorPlan _switchResult = null;
        if (cpsplan != null) {
            switch (cpsplan) {
                case STATISTICS_BASED: {
                    _switchResult = CPSPlanBuilder.buildCharacteristicBasedPlan();
                    break;
                }
                default: {
                    _switchResult = CPSPlanBuilder.buildDefaultPlan();
                    break;
                }
            }
        } else {
            _switchResult = CPSPlanBuilder.buildDefaultPlan();
        }
        GeneratorPlan plan = _switchResult;
        PlanExecutor generator = new PlanExecutor();
        Stopwatch generateTime = Stopwatch.createStarted();
        CPSFragment out = (CPSFragment)generator.process((IPlan)plan, (Initializer)input);
        generateTime.stop();
        long _elapsed = generateTime.elapsed(TimeUnit.MILLISECONDS);
        String _plus = "Generating time: " + Long.valueOf(_elapsed);
        String _plus_1 = String.valueOf(_plus) + " ms";
        logger.info((Object)_plus_1);
        return out;
    }
}

