/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.ide.autoedit;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class RichStringPartionIndentationStrategy
extends DefaultIndentLineAutoEditStrategy {
    public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
        if (c.text.length() > 1 && !((List)Conversions.doWrapArray((Object)d.getLegalLineDelimiters())).contains(c.text)) {
            try {
                String _string;
                boolean _lessThan;
                String lineIndentation = this.getLineIndentation(d, c.offset);
                String[] _legalLineDelimiters = d.getLegalLineDelimiters();
                Functions.Function1<String, Integer> _function = new Functions.Function1<String, Integer>(){

                    public Integer apply(String s) {
                        return s.length();
                    }
                };
                List _sortBy = IterableExtensions.sortBy((Iterable)((Iterable)Conversions.doWrapArray((Object)_legalLineDelimiters)), (Functions.Function1)_function);
                List legalLineDelimiters = ListExtensions.reverseView((List)_sortBy);
                String defaultLineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)d);
                Functions.Function1<String, CharSequence> _function_1 = new Functions.Function1<String, CharSequence>(){

                    public CharSequence apply(String delimiter) {
                        return Pattern.quote(delimiter);
                    }
                };
                String regex = IterableExtensions.join((Iterable)legalLineDelimiters, (CharSequence)"(", (CharSequence)")|(", (CharSequence)")", (Functions.Function1)_function_1);
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(c.text);
                StringBuilder convertedText = new StringBuilder();
                int currentStart = 0;
                int currentEnd = 0;
                while (matcher.find()) {
                    int _end;
                    int _start;
                    currentEnd = _start = matcher.start();
                    if (currentStart != 0) {
                        convertedText.append(lineIndentation);
                    }
                    String _substring = c.text.substring(currentStart, currentEnd);
                    convertedText.append(_substring);
                    convertedText.append(defaultLineDelimiter);
                    currentStart = _end = matcher.end();
                }
                int _length = c.text.length();
                boolean bl = _lessThan = currentStart < _length;
                if (_lessThan) {
                    if (currentStart != 0) {
                        convertedText.append(lineIndentation);
                    }
                    String _substring = c.text.substring(currentStart);
                    convertedText.append(_substring);
                }
                c.text = _string = convertedText.toString();
            }
            catch (Throwable _t) {
                if (_t instanceof BadLocationException) {
                    BadLocationException e = (BadLocationException)_t;
                    super.customizeDocumentCommand(d, c);
                }
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
        }
        super.customizeDocumentCommand(d, c);
    }

    public String getLineIndentation(IDocument document, int offset) throws BadLocationException {
        String _xblockexpression = null;
        int _xifexpression = 0;
        int _length = document.getLength();
        boolean _tripleEquals = offset == _length;
        _xifexpression = _tripleEquals ? offset - 1 : offset;
        int adjustedOffset = _xifexpression;
        IRegion line = document.getLineInformationOfOffset(adjustedOffset);
        int start = line.getOffset();
        int end = this.findEndOfWhiteSpace(document, start, offset);
        _xblockexpression = document.get(start, end - start);
        return _xblockexpression;
    }
}

