/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.evm.api.adapter;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.viatra.transformation.evm.api.adapter.AdaptableEVM;
import org.eclipse.viatra.transformation.evm.api.adapter.IAdaptableEVMFactoryListener;

public class AdaptableEVMFactory {
    private static AdaptableEVMFactory instance;
    private List<AdaptableEVM> adaptableEVMInstances = Lists.newArrayList();
    private List<IAdaptableEVMFactoryListener> listeners = Lists.newArrayList();

    public static AdaptableEVMFactory getInstance() {
        if (instance == null) {
            instance = new AdaptableEVMFactory();
        }
        return instance;
    }

    protected AdaptableEVMFactory() {
    }

    public List<AdaptableEVM> getAdaptableEVMInstances() {
        return this.adaptableEVMInstances;
    }

    public AdaptableEVM getAdaptableEVMInstance(String id) {
        for (AdaptableEVM adaptableEVM : this.adaptableEVMInstances) {
            if (!adaptableEVM.getIdentifier().equals(id)) continue;
            return adaptableEVM;
        }
        return null;
    }

    public AdaptableEVM createAdaptableEVM() {
        return this.createAdaptableEVM("AdaptableEVM_" + System.currentTimeMillis());
    }

    public void disposeAdaptableEVM(AdaptableEVM evm) {
        this.adaptableEVMInstances.remove(evm);
        this.notifyListeners();
    }

    public AdaptableEVM createAdaptableEVM(String id) {
        AdaptableEVM adaptableEVM = new AdaptableEVM(id);
        this.adaptableEVMInstances.add(adaptableEVM);
        this.notifyListeners();
        return adaptableEVM;
    }

    public void registerListener(IAdaptableEVMFactoryListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
            this.notifyListeners();
        }
    }

    protected void notifyListeners() {
        for (IAdaptableEVMFactoryListener adaptableEVMFactoryListener : this.listeners) {
            adaptableEVMFactoryListener.adaptableEVMPoolChanged(Lists.newArrayList(this.adaptableEVMInstances));
        }
    }

    public void unRegisterListener(IAdaptableEVMFactoryListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }
}

