/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryresult.handlers;

import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.viatra.query.patternlanguage.emf.helper.PatternLanguageHelper;
import org.eclipse.viatra.query.patternlanguage.emf.vql.Pattern;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultView;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class LoadVqlPatternHandler
extends AbstractHandler {
    @Inject
    Injector injector;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IEditorPart editorPart = HandlerUtil.getActiveEditorChecked((ExecutionEvent)event);
        IViewPart resultView = HandlerUtil.getActiveSite((ExecutionEvent)event).getPage().findView("org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultView");
        if (resultView instanceof QueryResultView) {
            QueryResultView queryResultView = (QueryResultView)resultView;
            boolean active = queryResultView.hasActiveEngine();
            if (active && editorPart instanceof XtextEditor) {
                XtextEditor xtextEditor = (XtextEditor)editorPart;
                IResource resource = xtextEditor.getResource();
                String _name = resource.getProject().getName();
                String sourceId = "dynamic:" + _name;
                IUnitOfWork _function = state -> {
                    HashSet fqns = CollectionLiterals.newHashSet((Object[])new String[0]);
                    TreeIterator iterator = state.getAllContents();
                    Procedures.Procedure1 _function_1 = pattern -> {
                        if (pattern instanceof Pattern) {
                            fqns.add(PatternLanguageHelper.getFullyQualifiedName((Pattern)((Pattern)pattern)));
                            iterator.prune();
                        }
                    };
                    IteratorExtensions.forEach((Iterator)iterator, (Procedures.Procedure1)_function_1);
                    return fqns;
                };
                Set patternFQNs = (Set)xtextEditor.getDocument().readOnly(_function);
                queryResultView.loadQueriesIntoActiveEngineInBackground(patternFQNs, sourceId);
            } else {
                MessageDialog.openError((Shell)queryResultView.getSite().getShell(), (String)"Query loading failed", (String)"Please load a model into the Query Results view before loading queries!");
            }
        }
        return null;
    }
}

