/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.check;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.check.CheckOperation;

public class InstanceOfJavaClassCheck
extends CheckOperation {
    private int position;
    private Class<?> clazz;

    public InstanceOfJavaClassCheck(int position, Class<?> clazz) {
        this.position = position;
        this.clazz = clazz;
    }

    @Override
    protected boolean check(MatchingFrame frame, ISearchContext context) {
        Objects.requireNonNull(frame.getValue(this.position), () -> String.format("Invalid plan, variable %s unbound", this.position));
        return this.clazz.isInstance(frame.getValue(this.position));
    }

    public String toString() {
        return "check     java " + this.clazz.getName() + "(+" + this.position + ")";
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.position);
    }
}

