/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.matcher;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdaptable;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ILocalSearchAdapter;
import org.eclipse.viatra.query.runtime.localsearch.plan.IPlanDescriptor;
import org.eclipse.viatra.query.runtime.localsearch.plan.SearchPlanExecutor;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.viatra.query.runtime.matchers.tuple.IModifiableTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.Tuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.TupleMask;
import org.eclipse.viatra.query.runtime.matchers.tuple.VolatileModifiableMaskedTuple;
import org.eclipse.viatra.query.runtime.matchers.util.Preconditions;

public final class LocalSearchMatcher
implements ILocalSearchAdaptable {
    private final List<SearchPlanExecutor> plan;
    private final IPlanDescriptor planDescriptor;
    private final List<ILocalSearchAdapter> adapters;

    public List<SearchPlanExecutor> getPlan() {
        return this.plan;
    }

    @Override
    public List<ILocalSearchAdapter> getAdapters() {
        return new ArrayList<ILocalSearchAdapter>(this.adapters);
    }

    public LocalSearchMatcher(IPlanDescriptor planDescriptor, SearchPlanExecutor plan) {
        this(planDescriptor, Collections.singletonList(plan));
    }

    public LocalSearchMatcher(IPlanDescriptor planDescriptor, SearchPlanExecutor[] plan) {
        this(planDescriptor, (List<SearchPlanExecutor>)new ArrayList<SearchPlanExecutor>(Arrays.asList(plan)));
    }

    public LocalSearchMatcher(IPlanDescriptor planDescriptor, Collection<SearchPlanExecutor> plan) {
        this(planDescriptor, (List<SearchPlanExecutor>)new ArrayList<SearchPlanExecutor>(plan));
    }

    private LocalSearchMatcher(IPlanDescriptor planDescriptor, List<SearchPlanExecutor> plan) {
        Preconditions.checkArgument((planDescriptor != null ? 1 : 0) != 0, (String)"Cannot initialize matcher with null query.");
        this.planDescriptor = planDescriptor;
        this.plan = plan;
        this.adapters = new LinkedList<ILocalSearchAdapter>();
    }

    @Override
    public void addAdapter(ILocalSearchAdapter adapter) {
        this.adapters.add(adapter);
        adapter.adapterRegistered(this);
    }

    @Override
    public void removeAdapter(ILocalSearchAdapter adapter) {
        this.adapters.remove(adapter);
        adapter.adapterUnregistered(this);
    }

    @Override
    public void addAdapters(List<ILocalSearchAdapter> adapters) {
        this.adapters.addAll(adapters);
        for (ILocalSearchAdapter adapter : adapters) {
            adapter.adapterRegistered(this);
        }
    }

    @Override
    public void removeAdapters(List<ILocalSearchAdapter> adapters) {
        this.adapters.removeAll(adapters);
        for (ILocalSearchAdapter adapter : adapters) {
            adapter.adapterUnregistered(this);
        }
    }

    public boolean hasMatch() {
        boolean hasMatch = this.hasMatch(new Object[0]);
        return hasMatch;
    }

    public boolean hasMatch(Object[] parameterValues) {
        this.matchingStarted();
        PlanExecutionIteratorWithArrayParameters it = new PlanExecutionIteratorWithArrayParameters(this.plan.iterator(), parameterValues);
        boolean hasMatch = it.hasNext();
        this.matchingFinished();
        return hasMatch;
    }

    public boolean hasMatch(TupleMask parameterSeedMask, ITuple parameterValues) {
        this.matchingStarted();
        PlanExecutionIteratorWithTupleParameters it = new PlanExecutionIteratorWithTupleParameters(this.plan.iterator(), parameterSeedMask, parameterValues);
        boolean hasMatch = it.hasNext();
        this.matchingFinished();
        return hasMatch;
    }

    public int countMatches() {
        int countMatches = this.countMatches(new Object[0]);
        return countMatches;
    }

    public int countMatches(Object[] parameterValues) {
        this.matchingStarted();
        PlanExecutionIteratorWithArrayParameters it = new PlanExecutionIteratorWithArrayParameters(this.plan.iterator(), parameterValues);
        HashSet<Tuple> results = new HashSet<Tuple>();
        while (it.hasNext()) {
            results.add(it.next());
        }
        int result = results.size();
        this.matchingFinished();
        return result;
    }

    public int countMatches(TupleMask parameterSeedMask, ITuple parameterValues) {
        this.matchingStarted();
        PlanExecutionIteratorWithTupleParameters it = new PlanExecutionIteratorWithTupleParameters(this.plan.iterator(), parameterSeedMask, parameterValues);
        HashSet<Tuple> results = new HashSet<Tuple>();
        while (it.hasNext()) {
            results.add(it.next());
        }
        int result = results.size();
        this.matchingFinished();
        return result;
    }

    public int getParameterCount() {
        return this.planDescriptor.getQuery().getParameters().size();
    }

    public Tuple getOneArbitraryMatch() {
        return this.getOneArbitraryMatch(new Object[0]);
    }

    public Tuple getOneArbitraryMatch(TupleMask parameterSeedMask, ITuple parameterValues) {
        this.matchingStarted();
        PlanExecutionIteratorWithTupleParameters it = new PlanExecutionIteratorWithTupleParameters(this.plan.iterator(), parameterSeedMask, parameterValues);
        Tuple returnValue = null;
        if (it.hasNext()) {
            returnValue = it.next();
        }
        this.matchingFinished();
        return returnValue;
    }

    public Tuple getOneArbitraryMatch(Object[] parameterValues) {
        this.matchingStarted();
        PlanExecutionIteratorWithArrayParameters it = new PlanExecutionIteratorWithArrayParameters(this.plan.iterator(), parameterValues);
        Tuple returnValue = null;
        if (it.hasNext()) {
            returnValue = it.next();
        }
        this.matchingFinished();
        return returnValue;
    }

    public Collection<Tuple> getAllMatches() {
        return this.getAllMatches(new Object[0]);
    }

    private void matchingStarted() {
        for (ILocalSearchAdapter adapter : this.adapters) {
            adapter.patternMatchingStarted(this);
        }
    }

    private void matchingFinished() {
        for (ILocalSearchAdapter adapter : this.adapters) {
            adapter.patternMatchingFinished(this);
        }
    }

    public Collection<Tuple> getAllMatches(Object[] parameterValues) {
        this.matchingStarted();
        PlanExecutionIteratorWithArrayParameters it = new PlanExecutionIteratorWithArrayParameters(this.plan.iterator(), parameterValues);
        Set<Tuple> results = StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 1025), false).collect(Collectors.toSet());
        this.matchingFinished();
        return results;
    }

    public Iterable<Tuple> getAllMatches(TupleMask parameterSeedMask, ITuple parameterValues) {
        this.matchingStarted();
        PlanExecutionIteratorWithTupleParameters it = new PlanExecutionIteratorWithTupleParameters(this.plan.iterator(), parameterSeedMask, parameterValues);
        Set<Tuple> results = StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 1025), false).collect(Collectors.toSet());
        this.matchingFinished();
        return results;
    }

    public PQuery getQuerySpecification() {
        return this.planDescriptor.getQuery();
    }

    public IPlanDescriptor getPlanDescriptor() {
        return this.planDescriptor;
    }

    private abstract class PlanExecutionIterator
    implements Iterator<Tuple> {
        protected final Iterator<SearchPlanExecutor> planIterator;
        protected SearchPlanExecutor currentPlan;
        protected MatchingFrame frame;
        protected VolatileModifiableMaskedTuple parametersOfFrameView;
        private boolean isNextMatchCalculated;

        public PlanExecutionIterator(Iterator<SearchPlanExecutor> planIterator) {
            this.planIterator = planIterator;
            this.isNextMatchCalculated = false;
        }

        protected boolean selectNextPlan() {
            if (this.currentPlan != null) {
                this.currentPlan.removeAdapters(LocalSearchMatcher.this.adapters);
            }
            boolean validPlanSelected = false;
            SearchPlanExecutor nextPlan = null;
            while (!validPlanSelected && this.planIterator.hasNext()) {
                nextPlan = this.planIterator.next();
                nextPlan.addAdapters(LocalSearchMatcher.this.adapters);
                nextPlan.resetPlan();
                validPlanSelected = this.initializeMatchingFrame(nextPlan);
            }
            if (validPlanSelected) {
                for (ILocalSearchAdapter adapter : LocalSearchMatcher.this.adapters) {
                    adapter.planChanged(this.currentPlan, nextPlan);
                }
                this.currentPlan = nextPlan;
                return true;
            }
            this.currentPlan = null;
            return false;
        }

        protected abstract boolean initializeMatchingFrame(SearchPlanExecutor var1);

        @Override
        public boolean hasNext() {
            if (this.isNextMatchCalculated) {
                return true;
            }
            if (this.currentPlan == null) {
                return false;
            }
            boolean foundMatch = this.currentPlan.execute(this.frame);
            while (!foundMatch && this.planIterator.hasNext()) {
                boolean bl = foundMatch = this.selectNextPlan() && this.currentPlan.execute(this.frame);
            }
            this.isNextMatchCalculated = foundMatch;
            return foundMatch;
        }

        @Override
        public Tuple next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No more matches available.");
            }
            this.isNextMatchCalculated = false;
            return this.parametersOfFrameView.toImmutable();
        }
    }

    private class PlanExecutionIteratorWithArrayParameters
    extends PlanExecutionIterator {
        private final Object[] parameterValues;

        public PlanExecutionIteratorWithArrayParameters(Iterator<SearchPlanExecutor> planIterator, Object[] parameterValues) {
            super(planIterator);
            this.parameterValues = parameterValues;
            this.selectNextPlan();
        }

        @Override
        protected boolean initializeMatchingFrame(SearchPlanExecutor nextPlan) {
            this.frame = new MatchingFrame(nextPlan.getVariableMapping().size());
            this.parametersOfFrameView = new VolatileModifiableMaskedTuple((IModifiableTuple)this.frame, nextPlan.getParameterMask());
            int i = 0;
            while (i < this.parameterValues.length) {
                Object valueToSet = this.parameterValues[i];
                if (valueToSet != null) {
                    Object oldValue = this.parametersOfFrameView.get(i);
                    if (oldValue == null) {
                        this.parametersOfFrameView.set(i, valueToSet);
                    } else if (!Objects.equals(valueToSet, oldValue)) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
    }

    private class PlanExecutionIteratorWithTupleParameters
    extends PlanExecutionIterator {
        private final ITuple parameterValues;
        private final TupleMask parameterSeedMask;

        public PlanExecutionIteratorWithTupleParameters(Iterator<SearchPlanExecutor> planIterator, TupleMask parameterSeedMask, ITuple parameterValues) {
            super(planIterator);
            this.parameterSeedMask = parameterSeedMask;
            this.parameterValues = parameterValues;
            this.selectNextPlan();
        }

        @Override
        protected boolean initializeMatchingFrame(SearchPlanExecutor nextPlan) {
            this.frame = new MatchingFrame(nextPlan.getVariableMapping().size());
            this.parametersOfFrameView = new VolatileModifiableMaskedTuple((IModifiableTuple)this.frame, nextPlan.getParameterMask());
            int i = 0;
            while (i < this.parameterSeedMask.getSize()) {
                int index = this.parameterSeedMask.indices[i];
                Object valueToSet = this.parameterValues.get(i);
                if (valueToSet != null) {
                    Object oldValue = this.parametersOfFrameView.get(index);
                    if (oldValue == null) {
                        this.parametersOfFrameView.set(index, valueToSet);
                    } else if (!Objects.equals(valueToSet, oldValue)) {
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }
    }
}

