/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.examples.cps.planexecutor;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.log4j.Logger;
import org.eclipse.viatra.examples.cps.planexecutor.api.IOperation;
import org.eclipse.viatra.examples.cps.planexecutor.api.IPhase;
import org.eclipse.viatra.examples.cps.planexecutor.api.IPlan;
import org.eclipse.viatra.examples.cps.planexecutor.api.Initializer;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Extension;

public class PlanExecutor<FragmentType, InputType extends Initializer<FragmentType>> {
    @Extension
    protected Logger logger = Logger.getLogger((String)"cps.generator.Generator");

    public FragmentType process(IPlan<FragmentType> plan, InputType input) {
        Object fragment = input.getInitialFragment();
        this.continueProcessing(plan, fragment);
        return fragment;
    }

    public void continueProcessing(IPlan<FragmentType> plan, FragmentType fragment) {
        Consumer<IPhase> _function = phase -> {
            boolean _isDebugEnabled = this.logger.isDebugEnabled();
            if (_isDebugEnabled) {
                String _simpleName = phase.getClass().getSimpleName();
                String _plus = "<< Begin Phase: " + _simpleName;
                String _plus_1 = String.valueOf(_plus) + " >>";
                this.logger.debug((Object)_plus_1);
            }
            Stopwatch phaseSw = Stopwatch.createStarted();
            Consumer<IOperation> _function_1 = operation -> {
                try {
                    boolean _isDebugEnabled_1 = this.logger.isDebugEnabled();
                    if (_isDebugEnabled_1) {
                        String _simpleName_1 = operation.getClass().getSimpleName();
                        String _plus_2 = "< OPERATION " + _simpleName_1;
                        String _plus_3 = String.valueOf(_plus_2) + " >";
                        this.logger.debug((Object)_plus_3);
                    }
                    operation.execute(fragment);
                    boolean _isDebugEnabled_2 = this.logger.isDebugEnabled();
                    if (_isDebugEnabled_2) {
                        this.logger.debug((Object)"<-------------------- END OPERATION ----------------------->");
                    }
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception e = (Exception)_t;
                        this.logger.info((Object)e.getMessage());
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            };
            phase.getOperations(fragment).forEach(_function_1);
            phaseSw.stop();
            String _simpleName_1 = phase.getClass().getSimpleName();
            String _plus_2 = "<< Done " + _simpleName_1;
            String _plus_3 = String.valueOf(_plus_2) + " phase in ";
            long _elapsed = phaseSw.elapsed(TimeUnit.MILLISECONDS);
            String _plus_4 = String.valueOf(_plus_3) + Long.valueOf(_elapsed);
            String _plus_5 = String.valueOf(_plus_4) + " ms >>";
            this.logger.info((Object)_plus_5);
        };
        plan.getPhases().forEach(_function);
    }
}

