/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.layout.algorithms;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.gef4.layout.algorithms.NodeWrapper;
import org.eclipse.gef4.layout.interfaces.CrossingReducer;
import org.eclipse.gef4.layout.interfaces.NodeLayout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SplitCrossingReducer
implements CrossingReducer {
    private final Map<NodeLayout, NodeWrapper> map = new IdentityHashMap<NodeLayout, NodeWrapper>();

    private ArrayList<NodeLayout> unionOfNodes(NodeLayout[] a, NodeLayout[] b) {
        ArrayList<NodeLayout> res = new ArrayList<NodeLayout>();
        int i = 0;
        while (i < a.length) {
            res.add(a[i]);
            ++i;
        }
        i = 0;
        while (i < b.length) {
            if (!res.contains(b[i])) {
                res.add(b[i]);
            }
            ++i;
        }
        return res;
    }

    private int numberOfCrosses(NodeWrapper nodeA, NodeWrapper nodeB) {
        int numOfCrosses = 0;
        if (nodeA.equals(nodeB)) {
            return 0;
        }
        ArrayList<NodeLayout> adjacentNodesOfA = this.unionOfNodes(nodeA.node.getPredecessingNodes(), nodeA.node.getSuccessingNodes());
        ArrayList<NodeLayout> adjacentNodesOfB = this.unionOfNodes(nodeB.node.getPredecessingNodes(), nodeB.node.getSuccessingNodes());
        for (NodeLayout aNode : adjacentNodesOfA) {
            ArrayList<Integer> alreadyCrossed = new ArrayList<Integer>();
            NodeWrapper aNodeWrapper = this.map.get(aNode);
            int i = 0;
            while (i < adjacentNodesOfB.size()) {
                NodeWrapper nw = this.map.get(adjacentNodesOfB.get(i));
                if (!alreadyCrossed.contains(i) && nw != null && (nw.layer > nodeA.layer && aNodeWrapper.layer > nodeA.layer || nw.layer < nodeA.layer && aNodeWrapper.layer < nodeA.layer)) {
                    if (nodeA.index < nodeB.index) {
                        if (aNodeWrapper.index > nw.index) {
                            ++numOfCrosses;
                            alreadyCrossed.add(i);
                        } else if (nw.index == aNodeWrapper.index) {
                            if (nodeA.index >= nw.index) {
                                if (aNodeWrapper.layer > nw.layer && nodeA.layer < nw.layer || aNodeWrapper.layer < nw.layer && nw.layer < nodeA.layer) {
                                    ++numOfCrosses;
                                    alreadyCrossed.add(i);
                                }
                            } else if (nodeB.index <= nw.index && (aNodeWrapper.layer > nw.layer && aNodeWrapper.layer < nodeB.layer || aNodeWrapper.layer < nw.layer && aNodeWrapper.layer > nodeB.layer)) {
                                ++numOfCrosses;
                                alreadyCrossed.add(i);
                            }
                        }
                    } else if (nodeA.index > nodeB.index) {
                        if (aNodeWrapper.index < nw.index) {
                            ++numOfCrosses;
                            alreadyCrossed.add(i);
                        } else if (nw.index == aNodeWrapper.index) {
                            if (nodeB.index >= nw.index) {
                                if (aNodeWrapper.layer > nw.layer && nodeB.layer > aNodeWrapper.layer || aNodeWrapper.layer < nw.layer && aNodeWrapper.layer > nodeB.layer) {
                                    ++numOfCrosses;
                                    alreadyCrossed.add(i);
                                }
                            } else if (nodeA.index <= nw.index && (aNodeWrapper.layer > nw.layer && nw.layer > nodeA.layer || aNodeWrapper.layer < nw.layer && nw.layer < nodeA.layer)) {
                                ++numOfCrosses;
                                alreadyCrossed.add(i);
                            }
                        }
                    }
                }
                ++i;
            }
        }
        return numOfCrosses;
    }

    private List<NodeWrapper> splitHeuristic(List<NodeWrapper> layer) {
        ArrayList<NodeWrapper> left = new ArrayList<NodeWrapper>();
        ArrayList<NodeWrapper> right = new ArrayList<NodeWrapper>();
        if (layer.size() < 1) {
            return layer;
        }
        Random random = new Random();
        NodeWrapper pivot = layer.get(random.nextInt(layer.size()));
        for (NodeWrapper node : layer) {
            int num2;
            if (node.equals(pivot) || node.node == null || pivot.node == null) continue;
            int num1 = this.numberOfCrosses(node, pivot);
            if (num1 < (num2 = this.numberOfCrosses(pivot, node))) {
                left.add(node);
                continue;
            }
            if (num1 > num2) {
                right.add(node);
                continue;
            }
            if (num1 == num2 && num1 > 0) {
                int tmpindex = this.map.get((Object)pivot.node).index;
                this.map.get((Object)pivot.node).index = this.map.get((Object)node.node).index;
                this.map.get((Object)node.node).index = tmpindex;
            }
            if (node.index < pivot.index) {
                left.add(node);
                continue;
            }
            right.add(node);
        }
        ArrayList<NodeWrapper> res = new ArrayList<NodeWrapper>();
        res.addAll(this.splitHeuristic(left));
        res.add(pivot);
        res.addAll(this.splitHeuristic(right));
        return res;
    }

    @Override
    public void crossReduction(List<List<NodeWrapper>> nodes) {
        for (List<NodeWrapper> layer : nodes) {
            for (NodeWrapper nw : layer) {
                this.map.put(nw.node, nw);
            }
        }
        int i = 0;
        while (i < nodes.size()) {
            if (!nodes.get(i).isEmpty()) {
                this.splitHeuristic(nodes.get(i));
            }
            ++i;
        }
    }
}

