/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.variant;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.event.types.IDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.VariantDeclaration;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeDeclaratorParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;

public final class VariantDeclarationParser
extends AbstractScopedCommonTreeParser {
    public static final VariantDeclarationParser INSTANCE = new VariantDeclarationParser();

    private VariantDeclarationParser() {
    }

    @Override
    public VariantDeclaration parse(ICTFMetadataNode declaration, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        VariantDeclaration variant = ((Param)param).fVariant;
        DeclarationScope scope = ((Param)param).fDeclarationScope;
        ICTFMetadataNode typeSpecifierListNode = declaration.getFirstChildWithType(CTFParser.tokenNames[117]);
        if (typeSpecifierListNode == null) {
            throw new ParseException("Variant need type specifiers");
        }
        ICTFMetadataNode typeDeclaratorListNode = declaration.getFirstChildWithType(CTFParser.tokenNames[116]);
        if (typeDeclaratorListNode == null) {
            throw new ParseException("Cannot have empty variant");
        }
        List<ICTFMetadataNode> typeDeclaratorList = typeDeclaratorListNode.getChildren();
        for (ICTFMetadataNode typeDeclaratorNode : typeDeclaratorList) {
            StringBuilder identifierSB = new StringBuilder();
            CTFTrace trace = ((Param)param).fTrace;
            IDeclaration decl = TypeDeclaratorParser.INSTANCE.parse(typeDeclaratorNode, new TypeDeclaratorParser.Param(trace, typeSpecifierListNode, scope, identifierSB));
            String name = identifierSB.toString();
            if (variant.hasField(name)) {
                throw new ParseException("variant: duplicate field " + name);
            }
            scope.registerIdentifier(name, decl);
            variant.addField(name, decl);
        }
        return variant;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final VariantDeclaration fVariant;
        private final DeclarationScope fDeclarationScope;
        private final CTFTrace fTrace;

        public Param(VariantDeclaration variant, CTFTrace trace, DeclarationScope scope) {
            this.fVariant = variant;
            this.fTrace = trace;
            this.fDeclarationScope = scope;
        }
    }
}

