/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.analysis.os.linux.core.swslatency;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import org.eclipse.tracecompass.analysis.os.linux.core.model.OsStrings;
import org.eclipse.tracecompass.datastore.core.interval.IHTIntervalReader;
import org.eclipse.tracecompass.datastore.core.serialization.ISafeByteBufferWriter;
import org.eclipse.tracecompass.datastore.core.serialization.SafeByteBufferFactory;
import org.eclipse.tracecompass.segmentstore.core.ISegment;
import org.eclipse.tracecompass.segmentstore.core.segment.interfaces.INamedSegment;
import org.eclipse.tracecompass.tmf.core.model.ICoreElementResolver;

public final class SchedWS
implements INamedSegment,
ICoreElementResolver {
    private static final long serialVersionUID = 4183872871733170072L;
    public static final IHTIntervalReader<ISegment> READER = buffer -> new SchedWS(buffer.getLong(), buffer.getLong(), buffer.getString(), buffer.getInt(), buffer.getInt());
    private final long fStartTime;
    private final long fEndTime;
    private final String fName;
    private final int fTid;
    private final int fPriority;

    public SchedWS(InitialInfo info, long endTime, int priority) {
        this.fStartTime = info.fStartTime;
        this.fName = info.fName;
        this.fEndTime = endTime;
        this.fTid = info.fTid;
        this.fPriority = priority;
    }

    private SchedWS(long startTime, long endTime, String name, int tid, int priority) {
        this.fStartTime = startTime;
        this.fEndTime = endTime;
        this.fName = name;
        this.fTid = tid;
        this.fPriority = priority;
    }

    public long getStart() {
        return this.fStartTime;
    }

    public long getEnd() {
        return this.fEndTime;
    }

    public String getName() {
        return this.fName;
    }

    public int getTid() {
        return this.fTid;
    }

    public int getPriority() {
        return this.fPriority;
    }

    public int getSizeOnDisk() {
        return 16 + SafeByteBufferFactory.getStringSizeInBuffer((String)this.fName) + 8;
    }

    public void writeSegment(ISafeByteBufferWriter buffer) {
        buffer.putLong(this.fStartTime);
        buffer.putLong(this.fEndTime);
        buffer.putString(this.fName);
        buffer.putInt(this.fTid);
        buffer.putInt(this.fPriority);
    }

    public int compareTo(ISegment o) {
        int ret = super.compareTo(o);
        if (ret != 0) {
            return ret;
        }
        return this.toString().compareTo(o.toString());
    }

    public String toString() {
        return "Start Time = " + this.getStart() + "; End Time = " + this.getEnd() + "; Duration = " + this.getLength() + "; Name = " + this.getName();
    }

    public Multimap<String, Object> getMetadata() {
        HashMultimap map = HashMultimap.create();
        map.put((Object)OsStrings.tid(), (Object)this.fTid);
        return map;
    }

    public static class InitialInfo {
        private long fStartTime;
        private String fName;
        private int fTid;

        public InitialInfo(long startTime, String name, int tid) {
            this.fStartTime = startTime;
            this.fName = name.intern();
            this.fTid = tid;
        }
    }
}

