/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene94;

import java.io.IOException;
import org.apache.lucene.index.FilterVectorValues;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.util.BytesRef;

public class ExpandingVectorValues
extends FilterVectorValues {
    private final float[] value;

    protected ExpandingVectorValues(VectorValues in) {
        super(in);
        this.value = new float[in.dimension()];
    }

    @Override
    public float[] vectorValue() throws IOException {
        BytesRef binaryValue = this.binaryValue();
        byte[] bytes = binaryValue.bytes;
        int i = 0;
        int j = binaryValue.offset;
        while (i < this.value.length) {
            this.value[i] = bytes[j];
            ++i;
            ++j;
        }
        return this.value;
    }
}

