/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.dialogs;

import java.util.Hashtable;
import java.util.List;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;

public class NamespaceInfoErrorHelper {
    protected List errorList;

    public String computeErrorMessage(List namespaceInfoList, URIResolver idResolver) {
        String result = null;
        Hashtable<String, NamespaceInfo> prefixTable = new Hashtable<String, NamespaceInfo>();
        Hashtable<String, NamespaceInfo> uriTable = new Hashtable<String, NamespaceInfo>();
        for (NamespaceInfo nsInfo : namespaceInfoList) {
            nsInfo.normalize();
            String urikey = nsInfo.uri != null ? nsInfo.uri : "";
            NamespaceInfo nsInfo2 = null;
            nsInfo2 = (NamespaceInfo)uriTable.get(urikey);
            if (nsInfo2 != null) {
                if (nsInfo.uri != null && nsInfo.uri.equals(nsInfo2.uri)) {
                    result = String.valueOf(XMLUIMessages._UI_WARNING_MORE_THAN_ONE_NS_WITH_NAME) + "'" + nsInfo.uri + "'";
                    break;
                }
                result = XMLUIMessages._UI_WARNING_MORE_THAN_ONE_NS_WITHOUT_NAME;
                break;
            }
            uriTable.put(urikey, nsInfo);
            if (nsInfo.uri != null) {
                String grammarURI;
                String key;
                String string = key = nsInfo.prefix != null ? nsInfo.prefix : "";
                if (prefixTable.get(key) != null) {
                    if (nsInfo.prefix != null) {
                        result = String.valueOf(XMLUIMessages._UI_WARNING_MORE_THAN_ONE_NS_WITH_PREFIX) + "'" + nsInfo.prefix + "'";
                        break;
                    }
                    result = XMLUIMessages._UI_WARNING_MORE_THAN_ONE_NS_WITHOUT_PREFIX;
                    break;
                }
                prefixTable.put(key, nsInfo);
                if (nsInfo.locationHint != null && idResolver != null && !URIHelper.isReadableURI((String)(grammarURI = idResolver.resolve(null, nsInfo.locationHint, nsInfo.locationHint)), (boolean)false)) {
                    result = String.valueOf(XMLUIMessages._UI_WARNING_SCHEMA_CAN_NOT_BE_LOCATED) + " '" + nsInfo.locationHint + "'";
                    break;
                }
                if (idResolver == null || nsInfo.locationHint != null || nsInfo.uri.equals("http://www.w3.org/2001/XMLSchema-instance")) continue;
                result = String.valueOf(XMLUIMessages._UI_WARNING_LOCATION_HINT_NOT_SPECIFIED) + " '" + nsInfo.uri + "'";
                break;
            }
            if (nsInfo.prefix == null) continue;
            result = String.valueOf(XMLUIMessages._UI_WARNING_NAMESPACE_NAME_NOT_SPECIFIED) + " '" + nsInfo.prefix + "'";
            break;
        }
        if (result == null) {
            for (NamespaceInfo nsInfo : namespaceInfoList) {
                nsInfo.normalize();
                if (nsInfo.uri == null || !nsInfo.isPrefixRequired || nsInfo.prefix != null) continue;
                result = String.valueOf(XMLUIMessages._UI_WARNING_PREFIX_NOT_SPECIFIED) + " '" + nsInfo.uri + "'";
                break;
            }
        }
        return result;
    }
}

