/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.filetransfer;

import java.io.File;
import java.io.Serializable;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.ecf.filetransfer.IFileTransferInfo;

public class FileTransferInfo
implements IFileTransferInfo,
Serializable {
    private static final long serialVersionUID = 8354226751625912190L;
    protected File file;
    protected Map properties;
    protected String description;
    protected String mimeType = null;

    public FileTransferInfo(File file) {
        this(file, null);
    }

    public FileTransferInfo(File file, Map properties) {
        this(file, properties, null);
    }

    public FileTransferInfo(File file, Map properties, String description) {
        this(file, properties, description, null);
    }

    public FileTransferInfo(File file, Map properties, String description, String mimeType) {
        Assert.isNotNull((Object)file, (String)"file must not be null");
        this.file = file;
        this.properties = properties == null ? new HashMap() : properties;
        this.description = description;
        this.mimeType = mimeType;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public Map getProperties() {
        return this.properties;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    @Override
    public long getFileSize() {
        return this.file.length();
    }

    @Override
    public String getMimeType() {
        if (this.mimeType == null) {
            return URLConnection.getFileNameMap().getContentTypeFor(this.file.getAbsolutePath());
        }
        return this.mimeType;
    }
}

