/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.trace;

import com.google.common.collect.ImmutableMap;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.EnumDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.FloatDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IntegerDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.SimpleDatatypeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StringDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.ctf.core.trace.ICTFPacketDescriptor;

public class StreamInputPacketIndexEntry
implements ICTFPacketDescriptor {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("\\D*(\\d+)");
    private final long fOffsetBits;
    private final long fOffsetBytes;
    private final long fPacketSizeBits;
    private final long fContentSizeBits;
    private final long fTimestampBegin;
    private final long fTimestampEnd;
    private final long fLostEvents;
    private final String fTarget;
    private final long fTargetID;
    private final @NonNull Map<String, Object> fAttributes;
    private final long fEndPacketHeaderBits;
    private final StructDefinition fStreamPacketContextDef;

    public StreamInputPacketIndexEntry(long dataOffsetBits, long fileSizeBytes) {
        this.fAttributes = Collections.emptyMap();
        this.fContentSizeBits = fileSizeBytes * 8L;
        this.fPacketSizeBits = fileSizeBytes * 8L;
        this.fOffsetBits = dataOffsetBits;
        this.fOffsetBytes = StreamInputPacketIndexEntry.bitsToBytes(dataOffsetBits);
        this.fLostEvents = 0L;
        this.fTarget = "";
        this.fTargetID = 0L;
        this.fTimestampBegin = 0L;
        this.fTimestampEnd = Long.MAX_VALUE;
        this.fEndPacketHeaderBits = dataOffsetBits;
        this.fStreamPacketContextDef = null;
    }

    private static long bitsToBytes(long value) {
        return (long)Math.ceil((double)value / 8.0);
    }

    public StreamInputPacketIndexEntry(long dataOffsetBits, StructDefinition streamPacketContextDef, long fileSizeBytes, long lostSoFar) {
        this(dataOffsetBits, streamPacketContextDef, fileSizeBytes, lostSoFar, dataOffsetBits);
    }

    public StreamInputPacketIndexEntry(long dataOffsetBits, StructDefinition streamPacketContextDef, long fileSizeBytes, long lostSoFar, long endPacketHeaderBits) {
        this.fStreamPacketContextDef = streamPacketContextDef;
        this.fEndPacketHeaderBits = endPacketHeaderBits;
        this.fAttributes = StreamInputPacketIndexEntry.computeAttributeMap(streamPacketContextDef);
        this.fContentSizeBits = this.computeContentSize(fileSizeBytes);
        this.fPacketSizeBits = this.computePacketSize(fileSizeBytes);
        this.fTimestampBegin = this.computeTsBegin();
        this.fTimestampEnd = this.computeTsEnd();
        this.fOffsetBits = dataOffsetBits;
        this.fOffsetBytes = StreamInputPacketIndexEntry.bitsToBytes(dataOffsetBits);
        Target target = this.lookupTarget(streamPacketContextDef);
        this.fTarget = target.getLabel();
        this.fTargetID = target.getNumber();
        this.fLostEvents = this.computeLostEvents(lostSoFar);
    }

    public StreamInputPacketIndexEntry(ICTFPacketDescriptor entryToAdd, long newTimestampEnd) {
        this.fStreamPacketContextDef = entryToAdd instanceof StreamInputPacketIndexEntry ? ((StreamInputPacketIndexEntry)entryToAdd).getStreamPacketContextDef() : null;
        this.fEndPacketHeaderBits = entryToAdd.getPayloadStartBits();
        this.fAttributes = entryToAdd.getAttributes();
        this.fContentSizeBits = entryToAdd.getContentSizeBits();
        this.fPacketSizeBits = entryToAdd.getPacketSizeBits();
        this.fTimestampBegin = entryToAdd.getTimestampBegin();
        this.fTimestampEnd = newTimestampEnd;
        this.fOffsetBits = entryToAdd.getOffsetBits();
        this.fOffsetBytes = entryToAdd.getOffsetBits();
        this.fTarget = entryToAdd.getTarget();
        this.fTargetID = entryToAdd.getTargetId();
        this.fLostEvents = entryToAdd.getLostEvents();
    }

    private static @NonNull Map<String, Object> computeAttributeMap(StructDefinition streamPacketContextDef) {
        ImmutableMap.Builder attributeBuilder = ImmutableMap.builder();
        for (String field : streamPacketContextDef.getDeclaration().getFieldsList()) {
            Definition id = streamPacketContextDef.lookupDefinition(field);
            if (id instanceof IntegerDefinition) {
                attributeBuilder.put((Object)field, (Object)((IntegerDefinition)id).getValue());
                continue;
            }
            if (id instanceof FloatDefinition) {
                attributeBuilder.put((Object)field, (Object)((FloatDefinition)id).getValue());
                continue;
            }
            if (id instanceof EnumDefinition) {
                EnumDefinition enumDec = (EnumDefinition)id;
                attributeBuilder.put((Object)field, new AbstractMap.SimpleImmutableEntry<String, Long>((String)NonNullUtils.checkNotNull((Object)enumDec.getStringValue()), (Long)NonNullUtils.checkNotNull((Object)enumDec.getIntegerValue())));
                continue;
            }
            if (!(id instanceof StringDefinition)) continue;
            attributeBuilder.put((Object)field, (Object)((StringDefinition)id).getValue());
        }
        return attributeBuilder.build();
    }

    private Long getPacketSize() {
        return (Long)this.fAttributes.get("packet_size");
    }

    private long computeContentSize(long fileSizeBytes) {
        Long contentSize = (Long)this.fAttributes.get("content_size");
        if (contentSize != null) {
            return contentSize;
        }
        Long packetSize = this.getPacketSize();
        if (packetSize != null) {
            return packetSize;
        }
        return fileSizeBytes * 8L;
    }

    private long computePacketSize(long fileSizeBytes) {
        Long packetSize = this.getPacketSize();
        if (packetSize != null) {
            return packetSize;
        }
        long contentSizeBits = this.computeContentSize(fileSizeBytes);
        if (contentSizeBits != 0L) {
            return contentSizeBits;
        }
        return fileSizeBytes * 8L;
    }

    private long computeTsBegin() {
        Long tsBegin = (Long)this.fAttributes.get("timestamp_begin");
        if (tsBegin != null) {
            return tsBegin;
        }
        return 0L;
    }

    private long computeTsEnd() {
        Long tsEnd = (Long)this.fAttributes.get("timestamp_end");
        if (tsEnd != null) {
            if (tsEnd == -1L) {
                return Long.MAX_VALUE;
            }
            return tsEnd;
        }
        return Long.MAX_VALUE;
    }

    private long computeLostEvents(long lostSoFar) {
        Long lostEvents = (Long)this.fAttributes.get("events_discarded");
        if (lostEvents != null) {
            return lostEvents - lostSoFar;
        }
        return 0L;
    }

    private Target lookupTarget(StructDefinition streamPacketContextDef) {
        Target ret = new Target(null, -1L);
        boolean hasDevice = this.fAttributes.containsKey("device");
        if (hasDevice) {
            StringDefinition stringDefinition;
            Matcher matcher;
            Definition def = streamPacketContextDef.lookupDefinition("device");
            if (def instanceof SimpleDatatypeDefinition) {
                SimpleDatatypeDefinition simpleDefinition = (SimpleDatatypeDefinition)def;
                ret = new Target(simpleDefinition.getStringValue(), simpleDefinition.getIntegerValue());
            } else if (def instanceof StringDefinition && (matcher = NUMBER_PATTERN.matcher((ret = new Target((stringDefinition = (StringDefinition)def).getValue(), -1L)).getLabel())).matches()) {
                String number = matcher.group(1);
                ret = new Target(ret.getLabel(), Integer.parseInt(number));
            }
        } else {
            Long cpuId = (Long)this.fAttributes.get("cpu_id");
            if (cpuId != null) {
                ret = new Target("CPU" + cpuId.toString(), cpuId);
            }
        }
        return ret;
    }

    @Override
    public boolean includes(long ts) {
        return ts >= this.fTimestampBegin && ts <= this.fTimestampEnd;
    }

    public String toString() {
        return "StreamInputPacketIndexEntry [offsetBits=" + this.fOffsetBits + ", timestampBegin=" + this.fTimestampBegin + ", timestampEnd=" + this.fTimestampEnd + "]";
    }

    @Override
    public long getOffsetBits() {
        return this.fOffsetBits;
    }

    @Override
    public long getPacketSizeBits() {
        return this.fPacketSizeBits;
    }

    @Override
    public long getContentSizeBits() {
        return this.fContentSizeBits;
    }

    @Override
    public long getTimestampBegin() {
        return this.fTimestampBegin;
    }

    @Override
    public long getTimestampEnd() {
        return this.fTimestampEnd;
    }

    @Override
    public long getLostEvents() {
        return this.fLostEvents;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.fAttributes;
    }

    @Override
    public String getTarget() {
        return this.fTarget;
    }

    @Override
    public long getTargetId() {
        return this.fTargetID;
    }

    @Override
    public long getOffsetBytes() {
        return this.fOffsetBytes;
    }

    @Override
    public long getPayloadStartBits() {
        return this.fEndPacketHeaderBits;
    }

    public StructDefinition getStreamPacketContextDef() {
        return this.fStreamPacketContextDef;
    }

    private static class Target {
        private String fLabel;
        private long fNumber;

        public Target(String target, long targetID) {
            this.fLabel = target;
            this.fNumber = targetID;
        }

        public String getLabel() {
            return this.fLabel;
        }

        public long getNumber() {
            return this.fNumber;
        }
    }
}

