/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IDiff;
import org.eclipse.core.databinding.observable.value.ValueDiff;
import org.eclipse.core.databinding.property.INativePropertyListener;
import org.eclipse.core.databinding.property.IProperty;
import org.eclipse.core.databinding.property.ISimplePropertyListener;
import org.eclipse.jface.internal.databinding.swt.WidgetBooleanValueProperty;
import org.eclipse.jface.internal.databinding.swt.WidgetListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class ControlFocusedProperty<S extends Control>
extends WidgetBooleanValueProperty<S> {
    @Override
    protected boolean doGetBooleanValue(S source) {
        return source.isFocusControl();
    }

    @Override
    protected void doSetBooleanValue(S source, boolean value) {
        if (value) {
            source.setFocus();
        }
    }

    @Override
    public INativePropertyListener<S> adaptListener(ISimplePropertyListener<S, ValueDiff<? extends Boolean>> listener) {
        int[] events = new int[]{15, 16};
        return new ControlFocusListener((IProperty)this, listener, events, null);
    }

    public String toString() {
        return "Control.focus <boolean>";
    }

    private static class ControlFocusListener<S extends Control>
    extends WidgetListener<S, ValueDiff<? extends Boolean>> {
        private ControlFocusListener(IProperty property, ISimplePropertyListener<S, ValueDiff<? extends Boolean>> listener, int[] changeEvents, int[] staleEvents) {
            super(property, listener, changeEvents, staleEvents);
        }

        @Override
        public void handleEvent(Event event) {
            switch (event.type) {
                case 15: {
                    this.fireChange((Control)event.widget, (IDiff)Diffs.createValueDiff((Object)false, (Object)true));
                    break;
                }
                case 16: {
                    this.fireChange((Control)event.widget, (IDiff)Diffs.createValueDiff((Object)true, (Object)false));
                }
            }
        }
    }
}

