/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.ctf.core.event.IEventDeclaration;
import org.eclipse.tracecompass.ctf.core.event.IEventDefinition;
import org.eclipse.tracecompass.ctf.core.event.scope.IDefinitionScope;
import org.eclipse.tracecompass.ctf.core.event.scope.ILexicalScope;
import org.eclipse.tracecompass.ctf.core.event.scope.LexicalScope;
import org.eclipse.tracecompass.ctf.core.event.types.Definition;
import org.eclipse.tracecompass.ctf.core.event.types.ICompositeDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.IDefinition;
import org.eclipse.tracecompass.ctf.core.event.types.StructDeclaration;
import org.eclipse.tracecompass.ctf.core.event.types.StructDefinition;
import org.eclipse.tracecompass.ctf.core.trace.ICTFPacketDescriptor;

public final class EventDefinition
implements IDefinitionScope,
IEventDefinition {
    private final IEventDeclaration fDeclaration;
    private final long fTimestamp;
    private final ICompositeDefinition fEventHeaderDefinition;
    private final ICompositeDefinition fEventContext;
    private final ICompositeDefinition fStreamContext;
    private final ICompositeDefinition fPacketContext;
    private final ICompositeDefinition fFields;
    private final int fCpu;
    private final @NonNull Map<String, Object> fPacketAttributes;

    public EventDefinition(IEventDeclaration declaration, int cpu, long timestamp, ICompositeDefinition eventHeaderDefinition, ICompositeDefinition streamContext, ICompositeDefinition eventContext, ICompositeDefinition packetContext, ICompositeDefinition fields, @Nullable ICTFPacketDescriptor packetDescriptor) {
        this.fDeclaration = declaration;
        this.fEventHeaderDefinition = eventHeaderDefinition;
        this.fCpu = cpu;
        this.fTimestamp = timestamp;
        this.fFields = fields;
        this.fEventContext = eventContext;
        this.fPacketContext = packetContext;
        this.fStreamContext = streamContext;
        this.fPacketAttributes = packetDescriptor != null ? packetDescriptor.getAttributes() : Collections.emptyMap();
    }

    @Override
    public ILexicalScope getScopePath() {
        String eventName = this.fDeclaration.getName();
        if (eventName == null) {
            return null;
        }
        ILexicalScope myScope = ILexicalScope.EVENT.getChild(eventName);
        if (myScope == null) {
            myScope = new LexicalScope(ILexicalScope.EVENT, eventName);
        }
        return myScope;
    }

    @Override
    public IEventDeclaration getDeclaration() {
        return this.fDeclaration;
    }

    @Override
    public ICompositeDefinition getEventHeader() {
        return this.fEventHeaderDefinition;
    }

    @Override
    public ICompositeDefinition getFields() {
        return this.fFields;
    }

    @Override
    public ICompositeDefinition getEventContext() {
        return this.fEventContext;
    }

    @Override
    public ICompositeDefinition getStreamContext() {
        return this.fStreamContext;
    }

    @Override
    public ICompositeDefinition getContext() {
        Definition definition;
        if (this.fStreamContext == null) {
            return this.fEventContext;
        }
        if (this.fEventContext == null) {
            return this.fStreamContext;
        }
        StructDeclaration mergedDeclaration = new StructDeclaration(1L);
        ArrayList<Definition> fieldValues = new ArrayList<Definition>();
        List<@NonNull String> fieldNames = this.fStreamContext.getFieldNames();
        for (String fieldName : fieldNames) {
            definition = this.fStreamContext.getDefinition(fieldName);
            mergedDeclaration.addField(fieldName, definition.getDeclaration());
            fieldValues.add(definition);
        }
        for (String fieldName : this.fEventContext.getFieldNames()) {
            definition = this.fEventContext.getDefinition(fieldName);
            mergedDeclaration.addField(fieldName, definition.getDeclaration());
            if (fieldNames.contains(fieldName)) {
                fieldValues.set(fieldNames.indexOf(fieldName), definition);
                continue;
            }
            fieldValues.add(definition);
        }
        return new StructDefinition(mergedDeclaration, (IDefinitionScope)this, "context", fieldValues.toArray(new Definition[fieldValues.size()]));
    }

    @Override
    public ICompositeDefinition getPacketContext() {
        return this.fPacketContext;
    }

    @Override
    public int getCPU() {
        return this.fCpu;
    }

    @Override
    public long getTimestamp() {
        return this.fTimestamp;
    }

    @Override
    public Map<String, Object> getPacketAttributes() {
        return this.fPacketAttributes;
    }

    @Override
    public IDefinition lookupDefinition(String lookupPath) {
        if (lookupPath.equals("context")) {
            return this.fEventContext;
        }
        if (lookupPath.equals("fields")) {
            return this.fFields;
        }
        return null;
    }

    public String toString() {
        List<String> list;
        StringBuilder retString = new StringBuilder();
        String cr = System.getProperty("line.separator");
        retString.append("Event type: ").append(this.fDeclaration.getName()).append(cr);
        retString.append("Timestamp: ").append(Long.toString(this.fTimestamp)).append(cr);
        if (this.fEventContext != null) {
            list = this.fEventContext.getFieldNames();
            for (String field : list) {
                retString.append(field).append(" : ").append(this.fEventContext.getDefinition(field).toString()).append(cr);
            }
        }
        if (this.fFields != null) {
            list = this.fFields.getFieldNames();
            for (String field : list) {
                retString.append(field).append(" : ").append(this.fFields.getDefinition(field).toString()).append(cr);
            }
        }
        return retString.toString();
    }
}

