/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.ctf.core.event;

import java.util.Objects;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;

@NonNullByDefault
public class CTFCallsite {
    private final String fEventName;
    private final String fFileName;
    private final long fIp;
    private final String fFunctionName;
    private final long fLineNumber;

    public CTFCallsite(String en, String func, long ip, String fn, long line) {
        this.fEventName = en;
        this.fFileName = fn;
        this.fFunctionName = func;
        this.fIp = ip;
        this.fLineNumber = line;
    }

    public String getEventName() {
        return this.fEventName;
    }

    public String getFileName() {
        return this.fFileName;
    }

    public long getIp() {
        return this.fIp;
    }

    public String getFunctionName() {
        return this.fFunctionName;
    }

    public long getLineNumber() {
        return this.fLineNumber;
    }

    public int hashCode() {
        return Objects.hash(this.fEventName, this.fFileName, this.fIp, this.fFunctionName, this.fLineNumber);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CTFCallsite other = (CTFCallsite)obj;
        if (!this.fEventName.equals(other.fEventName)) {
            return false;
        }
        if (!this.fFileName.equals(other.fFileName)) {
            return false;
        }
        if (!this.fFunctionName.equals(other.fFunctionName)) {
            return false;
        }
        if (this.fIp != other.fIp) {
            return false;
        }
        return this.fLineNumber == other.fLineNumber;
    }

    public String toString() {
        return String.valueOf(this.fFileName) + "/" + this.fFunctionName + ":" + this.fLineNumber;
    }
}

