/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.pcap.core.util;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.pcap.core.util.PcapTimestampScale;

public final class ConversionHelper {
    private static final char[] HEX_ARRAY = (char[])NonNullUtils.checkNotNull((Object)"0123456789abcdef".toCharArray());
    private static final String EMPTY_STRING = "";
    private static final String DEFAULT_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final DateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");

    private ConversionHelper() {
    }

    public static int unsignedByteToInt(byte n) {
        return n & 0xFF;
    }

    public static int unsignedShortToInt(short n) {
        return n & 0xFFFF;
    }

    public static long unsignedIntToLong(int n) {
        return (long)n & 0xFFFFFFFFL;
    }

    public static String bytesToHex(byte[] bytes, boolean spaced) {
        if (bytes.length == 0) {
            return EMPTY_STRING;
        }
        char[] hexChars = spaced ? new char[bytes.length * 3 - 1] : new char[bytes.length * 2];
        int delta = spaced ? 3 : 2;
        int separator = 32;
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * delta] = HEX_ARRAY[v >>> 4];
            hexChars[j * delta + 1] = HEX_ARRAY[v & 0xF];
            if (spaced && j != bytes.length - 1) {
                hexChars[j * delta + 2] = separator;
            }
            ++j;
        }
        return new String(hexChars);
    }

    public static String toMacAddress(byte[] mac) {
        if (mac.length != 6) {
            throw new IllegalArgumentException();
        }
        char separator = ':';
        return String.valueOf(String.format("%02x", mac[0])) + separator + String.format("%02x", mac[1]) + separator + String.format("%02x", mac[2]) + separator + String.format("%02x", mac[3]) + separator + String.format("%02x", mac[4]) + separator + String.format("%02x", mac[5]);
    }

    public static String toGMTTime(long ts, PcapTimestampScale scale) {
        long timestamp;
        switch (scale) {
            case MICROSECOND: {
                timestamp = ts * 1000L;
                break;
            }
            case NANOSECOND: {
                timestamp = ts;
                break;
            }
            default: {
                throw new IllegalArgumentException("The timestamp precision is not valid!");
            }
        }
        return ConversionHelper.format(timestamp);
    }

    private static String format(long value) {
        long date = value / 1000000L;
        long cs = Math.abs(value % 1000000L / 1000L);
        long ns = Math.abs(value % 1000L);
        Date dateObject = new Date(date);
        StringBuilder sb = new StringBuilder(DATE_FORMATTER.format(dateObject));
        sb.append('.').append(String.format("%03d", cs)).append('.').append(String.format("%03d", ns));
        return NonNullUtils.nullToEmptyString((Object)sb);
    }
}

