/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.bidi.internal;

import org.eclipse.equinox.bidi.advanced.IStructuredTextExpert;
import org.eclipse.equinox.bidi.custom.StructuredTextCharTypes;
import org.eclipse.equinox.bidi.custom.StructuredTextOffsets;
import org.eclipse.equinox.bidi.custom.StructuredTextTypeHandler;

public abstract class StructuredTextDelims
extends StructuredTextTypeHandler {
    public StructuredTextDelims() {
    }

    public StructuredTextDelims(String separators) {
        super(separators);
    }

    @Override
    public int indexOfSpecial(IStructuredTextExpert expert, String text, StructuredTextCharTypes charTypes, StructuredTextOffsets offsets, int caseNumber, int fromIndex) {
        char delim = this.getDelimiters().charAt((caseNumber - 1) * 2);
        return text.indexOf(delim, fromIndex);
    }

    @Override
    public int processSpecial(IStructuredTextExpert expert, String text, StructuredTextCharTypes charTypes, StructuredTextOffsets offsets, int caseNumber, int separLocation) {
        StructuredTextTypeHandler.processSeparator(text, charTypes, offsets, separLocation);
        int loc = separLocation + 1;
        char delim = this.getDelimiters().charAt(caseNumber * 2 - 1);
        loc = text.indexOf(delim, loc);
        if (loc < 0) {
            return text.length();
        }
        return loc + 1;
    }

    protected abstract String getDelimiters();
}

