/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.backend;

import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.internal.statesystem.core.backend.InMemoryBackend;
import org.eclipse.tracecompass.internal.statesystem.core.backend.NullBackend;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HistoryTreeBackend;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.ThreadedHistoryTreeBackend;
import org.eclipse.tracecompass.statesystem.core.backend.IStateHistoryBackend;

@NonNullByDefault
public final class StateHistoryBackendFactory {
    private StateHistoryBackendFactory() {
    }

    public static IStateHistoryBackend createNullBackend(String ssid) {
        return new NullBackend(ssid);
    }

    public static IStateHistoryBackend createInMemoryBackend(String ssid, long startTime) {
        return new InMemoryBackend(ssid, startTime);
    }

    public static IStateHistoryBackend createHistoryTreeBackendNewFile(String ssid, File stateFile, int providerVersion, long startTime, int queueSize) throws IOException {
        if (queueSize > 0) {
            return new ThreadedHistoryTreeBackend(ssid, stateFile, providerVersion, startTime, queueSize);
        }
        return new HistoryTreeBackend(ssid, stateFile, providerVersion, startTime);
    }

    public static IStateHistoryBackend createHistoryTreeBackendExistingFile(String ssid, File stateFile, int providerVersion) throws IOException {
        return new HistoryTreeBackend(ssid, stateFile, providerVersion);
    }
}

