/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;

public interface ITmfStateSystemBuilder
extends ITmfStateSystem {
    public static final int IGNORE_PROVIDER_VERSION = -42;

    public int getQuarkAbsoluteAndAdd(String ... var1);

    public int getQuarkRelativeAndAdd(int var1, String ... var2);

    public void updateOngoingState(@NonNull ITmfStateValue var1, int var2);

    default public void updateOngoingState(@Nullable Object newValue, int attributeQuark) {
        this.updateOngoingState(TmfStateValue.newValue(newValue), attributeQuark);
    }

    public void modifyAttribute(long var1, Object var3, int var4) throws StateValueTypeException;

    public void pushAttribute(long var1, Object var3, int var4) throws StateValueTypeException;

    public ITmfStateValue popAttribute(long var1, int var3) throws StateValueTypeException;

    default public Object popAttributeObject(long t, int attributeQuark) throws StateValueTypeException {
        return this.popAttribute(t, attributeQuark).unboxValue();
    }

    public void removeAttribute(long var1, int var3);

    public void closeHistory(long var1);

    public void removeFiles();

    default public List<@Nullable Object> queryOngoing() {
        ArrayList<@Nullable Object> retVal = new ArrayList<Object>();
        int attr = 0;
        while (attr < this.getNbAttributes()) {
            retVal.add(this.queryOngoing(attr));
            ++attr;
        }
        return retVal;
    }
}

