/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.statesystem.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.statesystem.core.Activator;
import org.eclipse.tracecompass.internal.statesystem.core.Attribute;
import org.eclipse.tracecompass.internal.statesystem.core.StateSystem;

public final class AttributeTree {
    private static final int ATTRIB_TREE_MAGIC_NUMBER = 116143729;
    private static final String SERIALIZATION_WILDCARD = "*";
    private final StateSystem fSs;
    private final List<Attribute> fAttributeList;
    private final Attribute fAttributeTreeRoot;
    private final ReentrantReadWriteLock fLock = new ReentrantReadWriteLock();

    public AttributeTree(StateSystem ss) {
        this.fSs = ss;
        this.fAttributeList = new ArrayList<Attribute>();
        this.fAttributeTreeRoot = new Attribute(null, "root", -1);
    }

    public AttributeTree(StateSystem ss, FileInputStream fis) throws IOException {
        this(ss);
        ArrayList attribList;
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(fis));
        int res = ois.readInt();
        if (res != 116143729) {
            throw new IOException("The attribute tree file section is either invalid or corrupted.");
        }
        try {
            ArrayList list;
            attribList = list = (ArrayList)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new IOException("Unrecognizable attribute list");
        }
        String[] prevFullAttribute = null;
        for (String[] attrib : attribList) {
            String[] curFullAttribute = AttributeTree.decodeFullAttribute(prevFullAttribute, attrib);
            this.getQuarkAndAdd(-1, curFullAttribute);
            prevFullAttribute = curFullAttribute;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeSelf(File file, long pos) {
        this.fLock.readLock().lock();
        try {
            try {
                Throwable throwable = null;
                Object var5_6 = null;
                try {
                    FileOutputStream fos = new FileOutputStream(file, true);
                    try {
                        try (FileChannel fc = fos.getChannel();){
                            fc.position(pos);
                            Throwable throwable2 = null;
                            Object var9_13 = null;
                            try (ObjectOutputStream oos = new ObjectOutputStream(fos);){
                                oos.writeInt(116143729);
                                ArrayList<String[]> list = new ArrayList<String[]>(this.fAttributeList.size());
                                String[] prevFullAttribute = null;
                                for (Attribute entry : this.fAttributeList) {
                                    String[] curFullAttribute = entry.getFullAttribute();
                                    String[] curEncodedAttribute = AttributeTree.encodeFullAttribute(prevFullAttribute, entry.getFullAttribute());
                                    list.add(curEncodedAttribute);
                                    prevFullAttribute = curFullAttribute;
                                }
                                oos.writeObject(list);
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                    throw throwable2;
                                } else {
                                    if (throwable2 == throwable3) throw throwable2;
                                    throwable2.addSuppressed(throwable3);
                                }
                                throw throwable2;
                            }
                        }
                        if (fos == null) return;
                    }
                    catch (Throwable throwable4) {
                        if (throwable == null) {
                            throwable = throwable4;
                        } else if (throwable != throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                        if (fos == null) throw throwable;
                        fos.close();
                        throw throwable;
                    }
                    fos.close();
                    return;
                }
                catch (Throwable throwable5) {
                    if (throwable == null) {
                        throwable = throwable5;
                        throw throwable;
                    } else {
                        if (throwable == throwable5) throw throwable;
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Activator.getDefault().logError("Error writing the file " + file, e);
                this.fLock.readLock().unlock();
            }
            return;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    private static String[] encodeFullAttribute(String[] prevPath, String[] curPath) {
        if (prevPath == null) {
            return curPath;
        }
        String[] diff = new String[curPath.length];
        int i = 0;
        while (i < curPath.length) {
            diff[i] = i < prevPath.length && prevPath[i].equals(curPath[i]) ? SERIALIZATION_WILDCARD : curPath[i];
            ++i;
        }
        return diff;
    }

    private static String[] decodeFullAttribute(String[] prevPath, String[] curPath) {
        if (prevPath == null) {
            return curPath;
        }
        String[] diff = new String[curPath.length];
        int i = 0;
        while (i < curPath.length) {
            diff[i] = i < prevPath.length && curPath[i].equals(SERIALIZATION_WILDCARD) ? prevPath[i] : curPath[i];
            ++i;
        }
        return diff;
    }

    public int getNbAttributes() {
        this.fLock.readLock().lock();
        try {
            int n = this.fAttributeList.size();
            return n;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    public int getQuarkDontAdd(int startingNodeQuark, String ... subPath) {
        if (subPath == null || subPath.length == 0) {
            return startingNodeQuark;
        }
        this.fLock.readLock().lock();
        try {
            Attribute startingNode = this.getAttribute(startingNodeQuark);
            int n = startingNode.getSubAttributeQuark(subPath);
            return n;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    public int getQuarkAndAdd(int startingNodeQuark, String ... subPath) {
        this.fLock.writeLock().lock();
        try {
            Attribute prevNode = this.getAttribute(startingNodeQuark);
            int knownQuark = prevNode.getSubAttributeQuark(subPath);
            if (knownQuark == -2) {
                String[] stringArray = subPath;
                int n = subPath.length;
                int n2 = 0;
                while (n2 < n) {
                    String curDirectory = stringArray[n2];
                    Attribute nextNode = prevNode.getSubAttributeNode(curDirectory);
                    if (nextNode == null) {
                        nextNode = new Attribute(prevNode, (String)NonNullUtils.checkNotNull((Object)curDirectory), this.fAttributeList.size());
                        prevNode.addSubAttribute(nextNode);
                        this.fAttributeList.add(nextNode);
                        this.fSs.addEmptyAttribute();
                    }
                    prevNode = nextNode;
                    ++n2;
                }
                int n3 = this.fAttributeList.size() - 1;
                return n3;
            }
            int n = knownQuark;
            return n;
        }
        finally {
            this.fLock.writeLock().unlock();
        }
    }

    public @NonNull List<@NonNull Integer> getSubAttributes(int attributeQuark, boolean recursive) {
        this.fLock.readLock().lock();
        try {
            ArrayList<@NonNull Integer> listOfChildren = new ArrayList<Integer>();
            Attribute startingAttribute = this.getAttribute(attributeQuark);
            this.addSubAttributes(listOfChildren, startingAttribute, recursive);
            ArrayList<Integer> arrayList = listOfChildren;
            return arrayList;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    private Attribute getAttribute(int startingNodeQuark) {
        if (startingNodeQuark == -1) {
            return this.fAttributeTreeRoot;
        }
        return this.fAttributeList.get(startingNodeQuark);
    }

    public int getParentAttributeQuark(int quark) {
        if (quark == -1) {
            return quark;
        }
        this.fLock.readLock().lock();
        try {
            int n = this.fAttributeList.get(quark).getParentAttributeQuark();
            return n;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    private void addSubAttributes(List<Integer> list, Attribute curAttribute, boolean recursive) {
        for (Attribute childNode : curAttribute.getSubAttributes()) {
            list.add(childNode.getQuark());
            if (!recursive) continue;
            this.addSubAttributes(list, childNode, true);
        }
    }

    public @NonNull String getAttributeName(int quark) {
        this.fLock.readLock().lock();
        try {
            String string = this.fAttributeList.get(quark).getName();
            return string;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    public @NonNull String getFullAttributeName(int quark) {
        this.fLock.readLock().lock();
        try {
            String string = this.fAttributeList.get(quark).getFullAttributeName();
            return string;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    public String @NonNull [] getFullAttributePathArray(int quark) {
        this.fLock.readLock().lock();
        try {
            String[] stringArray = this.fAttributeList.get(quark).getFullAttribute();
            return stringArray;
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }

    public void debugPrint(PrintWriter writer) {
        this.fLock.readLock().lock();
        try {
            this.fAttributeTreeRoot.debugPrint(writer);
        }
        finally {
            this.fLock.readLock().unlock();
        }
    }
}

