/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.container;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleContainer;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleRequirement;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.eclipse.osgi.container.ModuleRevisions;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.container.ModuleWiring;
import org.eclipse.osgi.framework.util.ObjectPool;
import org.eclipse.osgi.internal.container.Capabilities;
import org.eclipse.osgi.internal.container.ComputeNodeOrder;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.Version;
import org.osgi.resource.Requirement;

public class ModuleDatabase {
    final ModuleContainerAdaptor adaptor;
    private final Map<String, Module> modulesByLocations;
    private final Map<Long, Module> modulesById;
    final Map<ModuleRevision, ModuleWiring> wirings;
    final AtomicLong nextId;
    final AtomicLong revisionsTimeStamp;
    final AtomicLong allTimeStamp;
    final long constructionTime;
    private final Capabilities capabilities;
    final Map<Long, EnumSet<Module.Settings>> moduleSettings;
    private int initialModuleStartLevel = 1;
    private final ReentrantReadWriteLock monitor = new ReentrantReadWriteLock(false);

    public ModuleDatabase(ModuleContainerAdaptor adaptor) {
        this.adaptor = adaptor;
        this.modulesByLocations = new HashMap<String, Module>();
        this.modulesById = new HashMap<Long, Module>();
        this.wirings = new HashMap<ModuleRevision, ModuleWiring>();
        this.nextId = new AtomicLong(1L);
        this.constructionTime = System.currentTimeMillis();
        this.revisionsTimeStamp = new AtomicLong(this.constructionTime);
        this.allTimeStamp = new AtomicLong(this.constructionTime);
        this.moduleSettings = new HashMap<Long, EnumSet<Module.Settings>>();
        this.capabilities = new Capabilities();
    }

    final Module getModule(String location) {
        this.readLock();
        try {
            Module module = this.modulesByLocations.get(location);
            return module;
        }
        finally {
            this.readUnlock();
        }
    }

    final Module getModule(long id) {
        this.readLock();
        try {
            Module module = this.modulesById.get(id);
            return module;
        }
        finally {
            this.readUnlock();
        }
    }

    final Module install(String location, ModuleRevisionBuilder builder, Object revisionInfo) {
        this.writeLock();
        try {
            long id;
            int startlevel = "System Bundle".equals(location) ? 0 : this.getInitialModuleStartLevel();
            long l = id = "System Bundle".equals(location) ? 0L : builder.getId();
            if (id == -1L) {
                id = this.getAndIncrementNextId();
            }
            if (this.getModule(id) != null) {
                throw new IllegalStateException("Duplicate module id: " + id + " used by module: " + this.getModule(id));
            }
            EnumSet<Module.Settings> settings = this.getActivationPolicySettings(builder);
            Module module = this.load(location, builder, revisionInfo, id, settings, startlevel);
            long currentTime = System.currentTimeMillis();
            module.setlastModified(currentTime);
            this.setSystemLastModified(currentTime);
            this.incrementTimestamps(true);
            Module module2 = module;
            return module2;
        }
        finally {
            this.writeUnlock();
        }
    }

    private EnumSet<Module.Settings> getActivationPolicySettings(ModuleRevisionBuilder builder) {
        if ((builder.getTypes() & 1) != 0) {
            return null;
        }
        for (ModuleRevisionBuilder.GenericInfo info : builder.getCapabilities()) {
            String compatibilityStartLazy;
            if (!"equinox.module.data".equals(info.getNamespace())) continue;
            if ("lazy".equals(info.getAttributes().get("activation.policy")) && ((compatibilityStartLazy = this.adaptor.getProperty("osgi.compatibility.eagerStart.LazyActivation")) == null || Boolean.valueOf(compatibilityStartLazy).booleanValue())) {
                EnumSet<Module.Settings> settings = EnumSet.noneOf(Module.Settings.class);
                settings.add(Module.Settings.USE_ACTIVATION_POLICY);
                settings.add(Module.Settings.AUTO_START);
                return settings;
            }
            return null;
        }
        return null;
    }

    final Module load(String location, ModuleRevisionBuilder builder, Object revisionInfo, long id, EnumSet<Module.Settings> settings, int startlevel) {
        this.checkWrite();
        if (this.modulesByLocations.containsKey(location)) {
            throw new IllegalArgumentException("Location is already used: " + location);
        }
        if (this.modulesById.containsKey(id)) {
            throw new IllegalArgumentException("Id is already used: " + id);
        }
        Module module = id == 0L ? this.adaptor.createSystemModule() : this.adaptor.createModule(location, id, settings, startlevel);
        builder.addRevision(module, revisionInfo);
        this.modulesByLocations.put(location, module);
        this.modulesById.put(id, module);
        if (settings != null) {
            this.moduleSettings.put(id, settings);
        }
        ModuleRevision newRevision = module.getCurrentRevision();
        this.addCapabilities(newRevision);
        return module;
    }

    final void uninstall(Module module) {
        this.writeLock();
        try {
            ModuleRevisions uninstalling = module.getRevisions();
            uninstalling.uninstall();
            this.modulesByLocations.remove(module.getLocation());
            this.modulesById.remove(module.getId());
            this.moduleSettings.remove(module.getId());
            List<ModuleRevision> revisions = uninstalling.getModuleRevisions();
            for (ModuleRevision revision : revisions) {
                ModuleWiring oldWiring = this.wirings.get(revision);
                if (oldWiring != null) continue;
                module.getRevisions().removeRevision(revision);
                this.removeCapabilities(revision);
            }
            this.cleanupRemovalPending();
            long currentTime = System.currentTimeMillis();
            module.setlastModified(currentTime);
            this.setSystemLastModified(currentTime);
            this.incrementTimestamps(true);
        }
        finally {
            this.writeUnlock();
        }
    }

    final void update(Module module, ModuleRevisionBuilder builder, Object revisionInfo) {
        this.writeLock();
        try {
            ModuleRevision oldRevision = module.getCurrentRevision();
            ModuleRevision newRevision = builder.addRevision(module, revisionInfo);
            this.addCapabilities(newRevision);
            ModuleWiring oldWiring = this.wirings.get(oldRevision);
            if (oldWiring == null) {
                module.getRevisions().removeRevision(oldRevision);
                this.removeCapabilities(oldRevision);
            }
            this.cleanupRemovalPending();
            long currentTime = System.currentTimeMillis();
            module.setlastModified(currentTime);
            this.setSystemLastModified(currentTime);
            this.incrementTimestamps(true);
        }
        finally {
            this.writeUnlock();
        }
    }

    void cleanupRemovalPending() {
        this.checkWrite();
        Collection<ModuleRevision> removalPending = this.getRemovalPending();
        for (ModuleRevision removed : removalPending) {
            if (this.wirings.get(removed) == null) continue;
            Collection<ModuleRevision> dependencyClosure = ModuleContainer.getDependencyClosure(removed, this.wirings);
            boolean allPendingRemoval = true;
            for (ModuleRevision pendingRemoval : dependencyClosure) {
                if (!pendingRemoval.isCurrent()) continue;
                allPendingRemoval = false;
                break;
            }
            if (!allPendingRemoval) continue;
            ArrayList<ModuleWiring> toRemoveWirings = new ArrayList<ModuleWiring>();
            HashMap<ModuleWiring, ArrayList<ModuleWire>> toRemoveWireLists = new HashMap<ModuleWiring, ArrayList<ModuleWire>>();
            for (ModuleRevision moduleRevision : dependencyClosure) {
                ModuleWiring removedWiring = this.wirings.get(moduleRevision);
                if (removedWiring == null) continue;
                toRemoveWirings.add(removedWiring);
                List<ModuleWire> removedWires = removedWiring.getRequiredModuleWires(null);
                for (ModuleWire wire : removedWires) {
                    ArrayList<ModuleWire> providerWires = (ArrayList<ModuleWire>)toRemoveWireLists.get(wire.getProviderWiring());
                    if (providerWires == null) {
                        providerWires = new ArrayList<ModuleWire>();
                        toRemoveWireLists.put(wire.getProviderWiring(), providerWires);
                    }
                    providerWires.add(wire);
                }
            }
            for (ModuleRevision moduleRevision : dependencyClosure) {
                moduleRevision.getRevisions().removeRevision(moduleRevision);
                this.removeCapabilities(moduleRevision);
                this.wirings.remove(moduleRevision);
            }
            for (Map.Entry entry : toRemoveWireLists.entrySet()) {
                List<ModuleWire> provided = ((ModuleWiring)entry.getKey()).getProvidedModuleWires(null);
                provided.removeAll((Collection)entry.getValue());
                ((ModuleWiring)entry.getKey()).setProvidedWires(provided);
                for (ModuleWire removedWire : (Collection)entry.getValue()) {
                    removedWire.invalidate();
                }
            }
            for (ModuleWiring moduleWiring : toRemoveWirings) {
                moduleWiring.invalidate();
            }
        }
    }

    final Collection<ModuleRevision> getRemovalPending() {
        ArrayList<ModuleRevision> removalPending = new ArrayList<ModuleRevision>();
        this.readLock();
        try {
            for (ModuleWiring wiring : this.wirings.values()) {
                if (wiring.isCurrent()) continue;
                removalPending.add(wiring.getRevision());
            }
        }
        finally {
            this.readUnlock();
        }
        return removalPending;
    }

    final ModuleWiring getWiring(ModuleRevision revision) {
        this.readLock();
        try {
            ModuleWiring moduleWiring = this.wirings.get(revision);
            return moduleWiring;
        }
        finally {
            this.readUnlock();
        }
    }

    final Map<ModuleRevision, ModuleWiring> getWiringsCopy() {
        this.readLock();
        try {
            HashMap<ModuleRevision, ModuleWiring> hashMap = new HashMap<ModuleRevision, ModuleWiring>(this.wirings);
            return hashMap;
        }
        finally {
            this.readUnlock();
        }
    }

    final Map<ModuleRevision, ModuleWiring> getWiringsClone() {
        this.readLock();
        try {
            HashMap<ModuleRevision, ModuleWiring> clonedWirings = new HashMap<ModuleRevision, ModuleWiring>();
            for (Map.Entry<ModuleRevision, ModuleWiring> entry : this.wirings.entrySet()) {
                ModuleWiring wiring = new ModuleWiring(entry.getKey(), entry.getValue().getModuleCapabilities(null), entry.getValue().getModuleRequirements(null), entry.getValue().getProvidedModuleWires(null), entry.getValue().getRequiredModuleWires(null), entry.getValue().getSubstitutedNames());
                clonedWirings.put(entry.getKey(), wiring);
            }
            HashMap<ModuleRevision, ModuleWiring> hashMap = clonedWirings;
            return hashMap;
        }
        finally {
            this.readUnlock();
        }
    }

    final void setWiring(Map<ModuleRevision, ModuleWiring> newWiring) {
        this.writeLock();
        try {
            this.wirings.clear();
            this.wirings.putAll(newWiring);
            this.incrementTimestamps(true);
        }
        finally {
            this.writeUnlock();
        }
    }

    final void mergeWiring(Map<ModuleRevision, ModuleWiring> deltaWiring) {
        this.writeLock();
        try {
            this.wirings.putAll(deltaWiring);
            this.incrementTimestamps(true);
        }
        finally {
            this.writeUnlock();
        }
    }

    final List<Module> getModules() {
        return this.getSortedModules(new Sort[0]);
    }

    final List<Module> getSortedModules(Sort ... sortOptions) {
        this.readLock();
        try {
            ArrayList<Module> modules = new ArrayList<Module>(this.modulesByLocations.values());
            this.sortModules(modules, sortOptions);
            ArrayList<Module> arrayList = modules;
            return arrayList;
        }
        finally {
            this.readUnlock();
        }
    }

    final void sortModules(List<Module> modules, Sort ... sortOptions) {
        if (modules.size() < 2) {
            return;
        }
        if (sortOptions == null || Sort.BY_ID.isContained(sortOptions) || sortOptions.length == 0) {
            Collections.sort(modules, new Comparator<Module>(){

                @Override
                public int compare(Module m1, Module m2) {
                    return m1.getId().compareTo(m2.getId());
                }
            });
            return;
        }
        if (Sort.BY_START_LEVEL.isContained(sortOptions)) {
            Collections.sort(modules);
        }
        if (Sort.BY_DEPENDENCY.isContained(sortOptions)) {
            if (Sort.BY_START_LEVEL.isContained(sortOptions)) {
                int currentSL = modules.get(0).getStartLevel();
                int currentSLindex = 0;
                boolean lazy = false;
                int i = 0;
                while (i < modules.size()) {
                    Module module = modules.get(i);
                    if (currentSL != module.getStartLevel()) {
                        if (lazy) {
                            this.sortByDependencies(modules.subList(currentSLindex, i));
                        }
                        currentSL = module.getStartLevel();
                        currentSLindex = i;
                        lazy = false;
                    }
                    lazy |= module.isLazyActivate(new Module.StartOptions[0]);
                    ++i;
                }
                if (lazy) {
                    this.sortByDependencies(modules.subList(currentSLindex, modules.size()));
                }
            } else {
                this.sortByDependencies(modules);
            }
        }
    }

    private Collection<List<Module>> sortByDependencies(List<Module> toSort) {
        ArrayList<Module[]> references = new ArrayList<Module[]>(toSort.size());
        for (Module module : toSort) {
            ModuleWiring wiring;
            ModuleRevision current = module.getCurrentRevision();
            if (current == null || (wiring = current.getWiring()) == null) continue;
            for (ModuleWire wire : wiring.getRequiredModuleWires(null)) {
                ModuleRequirement req = wire.getRequirement();
                if ("osgi.wiring.package".equals(req.getNamespace()) && "dynamic".equals(req.getDirectives().get("resolution"))) continue;
                references.add(new Module[]{wire.getRequirer().getRevisions().getModule(), wire.getProvider().getRevisions().getModule()});
            }
        }
        Object[] sorted = toSort.toArray(new Module[toSort.size()]);
        Object[][] cycles = ComputeNodeOrder.computeNodeOrder(sorted, (Object[][])references.toArray((T[])new Module[references.size()][]));
        toSort.clear();
        toSort.addAll(Arrays.asList(sorted));
        if (cycles.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<List<Module>> moduleCycles = new ArrayList<List<Module>>(cycles.length);
        Object[][] objectArray = cycles;
        int n = cycles.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] cycle = objectArray[n2];
            ArrayList<Module> moduleCycle = new ArrayList<Module>(cycle.length);
            Object[] objectArray2 = cycle;
            int n3 = cycle.length;
            int n4 = 0;
            while (n4 < n3) {
                Object module = objectArray2[n4];
                moduleCycle.add((Module)module);
                ++n4;
            }
            moduleCycles.add(moduleCycle);
            ++n2;
        }
        return moduleCycles;
    }

    private void checkWrite() {
        if (this.monitor.getWriteHoldCount() == 0) {
            throw new IllegalMonitorStateException("Must hold the write lock.");
        }
    }

    public final long getNextId() {
        this.readLock();
        try {
            long l = this.nextId.get();
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    public final long getAndIncrementNextId() {
        this.writeLock();
        try {
            long l = this.nextId.getAndIncrement();
            return l;
        }
        finally {
            this.writeUnlock();
        }
    }

    public final long getRevisionsTimestamp() {
        this.readLock();
        try {
            long l = this.revisionsTimeStamp.get();
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    public final long getTimestamp() {
        this.readLock();
        try {
            long l = this.allTimeStamp.get();
            return l;
        }
        finally {
            this.readUnlock();
        }
    }

    private void incrementTimestamps(boolean incrementRevision) {
        this.checkWrite();
        if (incrementRevision) {
            this.revisionsTimeStamp.incrementAndGet();
        }
        this.allTimeStamp.incrementAndGet();
        this.adaptor.updatedDatabase();
    }

    private void setSystemLastModified(long currentTime) {
        this.checkWrite();
        Module systemModule = this.getModule(0L);
        if (systemModule != null) {
            systemModule.setlastModified(currentTime);
        }
    }

    public final void readLock() {
        this.monitor.readLock().lock();
    }

    public final void writeLock() {
        if (this.monitor.getReadHoldCount() > 0) {
            throw new IllegalMonitorStateException("Requesting upgrade to write lock.");
        }
        this.monitor.writeLock().lock();
    }

    public final void readUnlock() {
        this.monitor.readLock().unlock();
    }

    public final void writeUnlock() {
        this.monitor.writeLock().unlock();
    }

    final void addCapabilities(ModuleRevision revision) {
        this.checkWrite();
        Collection<String> packageNames = this.capabilities.addCapabilities(revision);
        for (ModuleWiring wiring : this.wirings.values()) {
            wiring.removeDynamicPackageMisses(packageNames);
        }
    }

    protected void removeCapabilities(ModuleRevision revision) {
        this.checkWrite();
        this.capabilities.removeCapabilities(revision);
    }

    final List<ModuleCapability> findCapabilities(Requirement requirement) {
        this.readLock();
        try {
            List<ModuleCapability> list = this.capabilities.findCapabilities(requirement);
            return list;
        }
        finally {
            this.readUnlock();
        }
    }

    public final void store(DataOutputStream out, boolean persistWirings) throws IOException {
        this.readLock();
        try {
            Persistence.store(this, out, persistWirings);
        }
        finally {
            this.readUnlock();
        }
    }

    public final void load(DataInputStream in) throws IOException {
        this.writeLock();
        try {
            if (this.allTimeStamp.get() != this.constructionTime) {
                throw new IllegalStateException("Can only load into a empty database.");
            }
            Persistence.load(this, in);
        }
        finally {
            this.writeUnlock();
        }
    }

    final void persistSettings(EnumSet<Module.Settings> settings, Module module) {
        this.writeLock();
        try {
            EnumSet<Module.Settings> existing = this.moduleSettings.get(module.getId());
            if (!settings.equals(existing)) {
                this.moduleSettings.put(module.getId(), EnumSet.copyOf(settings));
                this.incrementTimestamps(false);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    final void setStartLevel(Module module, int startlevel) {
        this.writeLock();
        try {
            module.checkValid();
            module.storeStartLevel(startlevel);
            this.incrementTimestamps(false);
        }
        finally {
            this.writeUnlock();
        }
    }

    final int getInitialModuleStartLevel() {
        this.readLock();
        try {
            int n = this.initialModuleStartLevel;
            return n;
        }
        finally {
            this.readUnlock();
        }
    }

    final void setInitialModuleStartLevel(int initialStartlevel) {
        this.writeLock();
        try {
            this.initialModuleStartLevel = initialStartlevel;
            this.incrementTimestamps(false);
        }
        finally {
            this.writeUnlock();
        }
    }

    private static class Persistence {
        private static final int VERSION = 3;
        private static final byte NULL = 0;
        private static final byte OBJECT = 1;
        private static final byte INDEX = 2;
        private static final byte LONG_STRING = 3;
        private static final byte VALUE_STRING = 0;
        private static final byte VALUE_LONG = 4;
        private static final byte VALUE_DOUBLE = 5;
        private static final byte VALUE_VERSION = 6;
        private static final byte VALUE_LIST = 8;

        private Persistence() {
        }

        private static int addToWriteTable(Object object, Map<Object, Integer> objectTable) {
            if (object == null) {
                throw new NullPointerException();
            }
            Integer cur = objectTable.get(object);
            if (cur != null) {
                throw new IllegalStateException("Object is already in the write table: " + object);
            }
            objectTable.put(object, objectTable.size());
            return objectTable.size() - 1;
        }

        /*
         * Unable to fully structure code
         */
        private static void addToReadTable(Object object, int index, List<Object> objectTable) {
            block2: {
                block1: {
                    if (index != objectTable.size()) break block1;
                    objectTable.add(object);
                    break block2;
                }
                if (index >= objectTable.size()) ** GOTO lbl12
                objectTable.set(index, object);
                break block2;
lbl-1000:
                // 1 sources

                {
                    objectTable.add(null);
lbl12:
                    // 2 sources

                    ** while (objectTable.size() < index)
                }
lbl13:
                // 1 sources

                objectTable.add(object);
            }
        }

        public static void store(ModuleDatabase moduleDatabase, DataOutputStream out, boolean persistWirings) throws IOException {
            out.writeInt(3);
            out.writeLong(moduleDatabase.getRevisionsTimestamp());
            out.writeLong(moduleDatabase.getTimestamp());
            out.writeLong(moduleDatabase.getNextId());
            out.writeInt(moduleDatabase.getInitialModuleStartLevel());
            HashSet<String> allStrings = new HashSet<String>();
            HashSet<Version> allVersions = new HashSet<Version>();
            HashSet allMaps = new HashSet();
            List<Module> modules = moduleDatabase.getModules();
            for (Module module : modules) {
                Persistence.getStringsVersionsAndMaps(module, moduleDatabase, allStrings, allVersions, allMaps);
            }
            Map<ModuleRevision, ModuleWiring> wirings = moduleDatabase.wirings;
            for (ModuleWiring wiring : wirings.values()) {
                Iterator<Object> substituted = wiring.getSubstitutedNames();
                allStrings.addAll((Collection<String>)((Object)substituted));
            }
            HashMap<Object, Integer> objectTable = new HashMap<Object, Integer>();
            allStrings.remove(null);
            out.writeInt(allStrings.size());
            for (String string : allStrings) {
                Persistence.writeString(string, out, objectTable);
                out.writeInt(Persistence.addToWriteTable(string, objectTable));
            }
            out.writeInt(allVersions.size());
            for (Version version : allVersions) {
                Persistence.writeVersion(version, out, objectTable);
                out.writeInt(Persistence.addToWriteTable(version, objectTable));
            }
            out.writeInt(allMaps.size());
            for (Map map : allMaps) {
                Persistence.writeMap(map, out, objectTable, moduleDatabase);
                out.writeInt(Persistence.addToWriteTable(map, objectTable));
            }
            out.writeInt(modules.size());
            for (Module module : modules) {
                Persistence.writeModule(module, moduleDatabase, out, objectTable);
            }
            Collection<ModuleRevision> collection = moduleDatabase.getRemovalPending();
            out.writeBoolean(persistWirings &= collection.isEmpty());
            if (!persistWirings) {
                return;
            }
            out.writeInt(wirings.size());
            for (ModuleWiring wiring : wirings.values()) {
                List<ModuleWire> requiredWires = wiring.getPersistentRequiredWires();
                out.writeInt(requiredWires.size());
                for (ModuleWire wire : requiredWires) {
                    Persistence.writeWire(wire, out, objectTable);
                }
            }
            for (ModuleWiring wiring : wirings.values()) {
                Persistence.writeWiring(wiring, out, objectTable);
            }
            out.flush();
        }

        private static void getStringsVersionsAndMaps(Module module, ModuleDatabase moduleDatabase, Set<String> allStrings, Set<Version> allVersions, Set<Map<String, ?>> allMaps) {
            ModuleRevision current = module.getCurrentRevision();
            if (current == null) {
                return;
            }
            allStrings.add(module.getLocation());
            allStrings.add(current.getSymbolicName());
            allStrings.add(current.getVersion().getQualifier());
            allVersions.add(current.getVersion());
            EnumSet<Module.Settings> settings = moduleDatabase.moduleSettings.get(module.getId());
            if (settings != null) {
                for (Module.Settings setting : settings) {
                    allStrings.add(setting.toString());
                }
            }
            List<ModuleCapability> capabilities = current.getModuleCapabilities(null);
            for (ModuleCapability capability : capabilities) {
                allStrings.add(capability.getNamespace());
                Persistence.addMap(capability.getPersistentAttributes(), allStrings, allVersions, allMaps);
                Persistence.addMap(capability.getDirectives(), allStrings, allVersions, allMaps);
            }
            List<ModuleRequirement> requirements = current.getModuleRequirements(null);
            for (ModuleRequirement requirement : requirements) {
                allStrings.add(requirement.getNamespace());
                Persistence.addMap(requirement.getAttributes(), allStrings, allVersions, allMaps);
                Persistence.addMap(requirement.getDirectives(), allStrings, allVersions, allMaps);
            }
        }

        private static void addMap(Map<String, ?> map, Set<String> allStrings, Set<Version> allVersions, Set<Map<String, ?>> allMaps) {
            if (!allMaps.add(map)) {
                return;
            }
            block4: for (Map.Entry<String, ?> entry : map.entrySet()) {
                allStrings.add(entry.getKey());
                Object value = entry.getValue();
                if (value instanceof String) {
                    allStrings.add((String)value);
                    continue;
                }
                if (value instanceof Version) {
                    allStrings.add(((Version)value).getQualifier());
                    allVersions.add((Version)value);
                    continue;
                }
                if (!(value instanceof List)) continue;
                switch (Persistence.getListType((List)value)) {
                    case 0: {
                        for (Object string : (List)value) {
                            allStrings.add((String)string);
                        }
                        continue block4;
                    }
                    case 6: {
                        for (Object version : (List)value) {
                            allStrings.add(((Version)version).getQualifier());
                            allVersions.add((Version)version);
                        }
                        continue block4;
                    }
                }
            }
        }

        public static void load(ModuleDatabase moduleDatabase, DataInputStream in) throws IOException {
            int i;
            int i2;
            int version = in.readInt();
            if (version > 3 || version / 1000 != 0) {
                throw new IllegalArgumentException("The version of the persistent framework data is not compatible: " + version + " expecting: " + 3);
            }
            long revisionsTimeStamp = in.readLong();
            long allTimeStamp = in.readLong();
            moduleDatabase.nextId.set(in.readLong());
            moduleDatabase.setInitialModuleStartLevel(in.readInt());
            ArrayList<Object> objectTable = new ArrayList<Object>();
            if (version >= 2) {
                int numStrings = in.readInt();
                int i3 = 0;
                while (i3 < numStrings) {
                    Persistence.readIndexedString(in, objectTable);
                    ++i3;
                }
                int numVersions = in.readInt();
                i2 = 0;
                while (i2 < numVersions) {
                    Persistence.readIndexedVersion(in, objectTable);
                    ++i2;
                }
                int numMaps = in.readInt();
                i = 0;
                while (i < numMaps) {
                    Persistence.readIndexedMap(in, objectTable);
                    ++i;
                }
            }
            int numModules = in.readInt();
            ModuleRevisionBuilder builder = new ModuleRevisionBuilder();
            i2 = 0;
            while (i2 < numModules) {
                Persistence.readModule(builder, moduleDatabase, in, objectTable, version);
                ++i2;
            }
            moduleDatabase.revisionsTimeStamp.set(revisionsTimeStamp);
            moduleDatabase.allTimeStamp.set(allTimeStamp);
            if (!in.readBoolean()) {
                return;
            }
            int numWirings = in.readInt();
            i = 0;
            while (i < numWirings) {
                int numWires = in.readInt();
                int j = 0;
                while (j < numWires) {
                    Persistence.readWire(in, objectTable);
                    ++j;
                }
                ++i;
            }
            HashMap<ModuleRevision, ModuleWiring> wirings = new HashMap<ModuleRevision, ModuleWiring>();
            int i4 = 0;
            while (i4 < numWirings) {
                ModuleWiring wiring = Persistence.readWiring(in, objectTable);
                wirings.put(wiring.getRevision(), wiring);
                ++i4;
            }
            moduleDatabase.setWiring(wirings);
            for (ModuleWiring wiring : wirings.values()) {
                wiring.getRevision().getRevisions().getModule().setState(Module.State.RESOLVED);
            }
            moduleDatabase.revisionsTimeStamp.set(revisionsTimeStamp);
            moduleDatabase.allTimeStamp.set(allTimeStamp);
        }

        private static void writeModule(Module module, ModuleDatabase moduleDatabase, DataOutputStream out, Map<Object, Integer> objectTable) throws IOException {
            ModuleRevision current = module.getCurrentRevision();
            if (current == null) {
                return;
            }
            out.writeInt(Persistence.addToWriteTable(current, objectTable));
            Persistence.writeString(module.getLocation(), out, objectTable);
            out.writeLong(module.getId());
            Persistence.writeString(current.getSymbolicName(), out, objectTable);
            Persistence.writeVersion(current.getVersion(), out, objectTable);
            out.writeInt(current.getTypes());
            List<ModuleCapability> capabilities = current.getModuleCapabilities(null);
            out.writeInt(capabilities.size());
            for (ModuleCapability capability : capabilities) {
                out.writeInt(Persistence.addToWriteTable(capability, objectTable));
                Persistence.writeGenericInfo(capability.getNamespace(), capability.getPersistentAttributes(), capability.getDirectives(), out, objectTable);
            }
            List<Requirement> requirements = current.getRequirements(null);
            out.writeInt(requirements.size());
            for (Requirement requirement : requirements) {
                out.writeInt(Persistence.addToWriteTable(requirement, objectTable));
                Persistence.writeGenericInfo(requirement.getNamespace(), requirement.getAttributes(), requirement.getDirectives(), out, objectTable);
            }
            EnumSet<Module.Settings> settings = moduleDatabase.moduleSettings.get(module.getId());
            out.writeInt(settings == null ? 0 : settings.size());
            if (settings != null) {
                for (Module.Settings setting : settings) {
                    Persistence.writeString(setting.name(), out, objectTable);
                }
            }
            out.writeInt(module.getStartLevel());
            out.writeLong(module.getLastModified());
        }

        private static void readModule(ModuleRevisionBuilder builder, ModuleDatabase moduleDatabase, DataInputStream in, List<Object> objectTable, int version) throws IOException {
            builder.clear();
            int moduleIndex = in.readInt();
            String location = Persistence.readString(in, objectTable);
            long id = in.readLong();
            builder.setSymbolicName(Persistence.readString(in, objectTable));
            builder.setVersion(Persistence.readVersion(in, objectTable));
            builder.setTypes(in.readInt());
            int numCapabilities = in.readInt();
            int[] capabilityIndexes = new int[numCapabilities];
            int i = 0;
            while (i < numCapabilities) {
                capabilityIndexes[i] = in.readInt();
                Persistence.readGenericInfo(true, in, builder, objectTable, version);
                ++i;
            }
            int numRequirements = in.readInt();
            int[] requirementIndexes = new int[numRequirements];
            int i2 = 0;
            while (i2 < numRequirements) {
                requirementIndexes[i2] = in.readInt();
                Persistence.readGenericInfo(false, in, builder, objectTable, version);
                ++i2;
            }
            EnumSet<Module.Settings> settings = null;
            int numSettings = in.readInt();
            if (numSettings > 0) {
                settings = EnumSet.noneOf(Module.Settings.class);
                int i3 = 0;
                while (i3 < numSettings) {
                    settings.add(Module.Settings.valueOf(Persistence.readString(in, objectTable)));
                    ++i3;
                }
            }
            int startlevel = in.readInt();
            Object revisionInfo = moduleDatabase.adaptor.getRevisionInfo(location, id);
            Module module = moduleDatabase.load(location, builder, revisionInfo, id, settings, startlevel);
            module.setlastModified(in.readLong());
            ModuleRevision current = module.getCurrentRevision();
            Persistence.addToReadTable(current, moduleIndex, objectTable);
            List<ModuleCapability> capabilities = current.getModuleCapabilities(null);
            int i4 = 0;
            while (i4 < capabilities.size()) {
                Persistence.addToReadTable(capabilities.get(i4), capabilityIndexes[i4], objectTable);
                ++i4;
            }
            List<ModuleRequirement> requirements = current.getModuleRequirements(null);
            int i5 = 0;
            while (i5 < requirements.size()) {
                Persistence.addToReadTable(requirements.get(i5), requirementIndexes[i5], objectTable);
                ++i5;
            }
        }

        private static void writeWire(ModuleWire wire, DataOutputStream out, Map<Object, Integer> objectTable) throws IOException {
            ModuleWire w = wire;
            Integer capability = objectTable.get(w.getCapability());
            Integer provider = objectTable.get(w.getProvider());
            Integer requirement = objectTable.get(w.getRequirement());
            Integer requirer = objectTable.get(w.getRequirer());
            if (capability == null || provider == null || requirement == null || requirer == null) {
                throw new NullPointerException("Could not find the expected indexes");
            }
            out.writeInt(Persistence.addToWriteTable(wire, objectTable));
            out.writeInt(capability);
            out.writeInt(provider);
            out.writeInt(requirement);
            out.writeInt(requirer);
        }

        private static void readWire(DataInputStream in, List<Object> objectTable) throws IOException {
            int wireIndex = in.readInt();
            ModuleCapability capability = (ModuleCapability)objectTable.get(in.readInt());
            ModuleRevision provider = (ModuleRevision)objectTable.get(in.readInt());
            ModuleRequirement requirement = (ModuleRequirement)objectTable.get(in.readInt());
            ModuleRevision requirer = (ModuleRevision)objectTable.get(in.readInt());
            if (capability == null || provider == null || requirement == null || requirer == null) {
                throw new NullPointerException("Could not find the expected indexes");
            }
            ModuleWire result = new ModuleWire(capability, provider, requirement, requirer);
            Persistence.addToReadTable(result, wireIndex, objectTable);
        }

        private static void writeWiring(ModuleWiring wiring, DataOutputStream out, Map<Object, Integer> objectTable) throws IOException {
            Integer revisionIndex = objectTable.get(wiring.getRevision());
            if (revisionIndex == null) {
                throw new NullPointerException("Could not find revision for wiring.");
            }
            out.writeInt(revisionIndex);
            List<ModuleCapability> capabilities = wiring.getModuleCapabilities(null);
            out.writeInt(capabilities.size());
            for (ModuleCapability capability : capabilities) {
                Integer capabilityIndex = objectTable.get(capability);
                if (capabilityIndex == null) {
                    throw new NullPointerException("Could not find capability for wiring.");
                }
                out.writeInt(capabilityIndex);
            }
            List<ModuleRequirement> requirements = wiring.getPersistentRequirements();
            out.writeInt(requirements.size());
            for (ModuleRequirement requirement : requirements) {
                Integer requirementIndex = objectTable.get(requirement);
                if (requirementIndex == null) {
                    throw new NullPointerException("Could not find requirement for wiring.");
                }
                out.writeInt(requirementIndex);
            }
            List<ModuleWire> providedWires = wiring.getPersistentProvidedWires();
            out.writeInt(providedWires.size());
            for (ModuleWire wire : providedWires) {
                Integer wireIndex = objectTable.get(wire);
                if (wireIndex == null) {
                    throw new NullPointerException("Could not find provided wire for wiring.");
                }
                out.writeInt(wireIndex);
            }
            List<ModuleWire> requiredWires = wiring.getPersistentRequiredWires();
            out.writeInt(requiredWires.size());
            for (ModuleWire wire : requiredWires) {
                Integer wireIndex = objectTable.get(wire);
                if (wireIndex == null) {
                    throw new NullPointerException("Could not find required wire for wiring.");
                }
                out.writeInt(wireIndex);
            }
            Collection<String> substituted = wiring.getSubstitutedNames();
            out.writeInt(substituted.size());
            for (String pkgName : substituted) {
                Persistence.writeString(pkgName, out, objectTable);
            }
        }

        private static ModuleWiring readWiring(DataInputStream in, List<Object> objectTable) throws IOException {
            ModuleRevision revision = (ModuleRevision)objectTable.get(in.readInt());
            if (revision == null) {
                throw new NullPointerException("Could not find revision for wiring.");
            }
            int numCapabilities = in.readInt();
            ArrayList<ModuleCapability> capabilities = new ArrayList<ModuleCapability>(numCapabilities);
            int i = 0;
            while (i < numCapabilities) {
                capabilities.add((ModuleCapability)objectTable.get(in.readInt()));
                ++i;
            }
            int numRequirements = in.readInt();
            ArrayList<ModuleRequirement> requirements = new ArrayList<ModuleRequirement>(numRequirements);
            int i2 = 0;
            while (i2 < numRequirements) {
                requirements.add((ModuleRequirement)objectTable.get(in.readInt()));
                ++i2;
            }
            int numProvidedWires = in.readInt();
            ArrayList<ModuleWire> providedWires = new ArrayList<ModuleWire>(numProvidedWires);
            int i3 = 0;
            while (i3 < numProvidedWires) {
                providedWires.add((ModuleWire)objectTable.get(in.readInt()));
                ++i3;
            }
            int numRequiredWires = in.readInt();
            ArrayList<ModuleWire> requiredWires = new ArrayList<ModuleWire>(numRequiredWires);
            int i4 = 0;
            while (i4 < numRequiredWires) {
                requiredWires.add((ModuleWire)objectTable.get(in.readInt()));
                ++i4;
            }
            int numSubstitutedNames = in.readInt();
            ArrayList<String> substituted = new ArrayList<String>(numSubstitutedNames);
            int i5 = 0;
            while (i5 < numSubstitutedNames) {
                substituted.add(Persistence.readString(in, objectTable));
                ++i5;
            }
            return new ModuleWiring(revision, capabilities, requirements, providedWires, requiredWires, substituted);
        }

        private static void writeGenericInfo(String namespace, Map<String, ?> attributes, Map<String, String> directives, DataOutputStream out, Map<Object, Integer> objectTable) throws IOException {
            Persistence.writeString(namespace, out, objectTable);
            Integer attributesIndex = objectTable.get(attributes);
            Integer directivesIndex = objectTable.get(directives);
            if (attributesIndex == null || directivesIndex == null) {
                throw new NullPointerException("Could not find the expected indexes");
            }
            out.writeInt(attributesIndex);
            out.writeInt(directivesIndex);
        }

        private static void readGenericInfo(boolean isCapability, DataInputStream in, ModuleRevisionBuilder builder, List<Object> objectTable, int version) throws IOException {
            Map directives;
            String namespace = Persistence.readString(in, objectTable);
            Map attributes = version >= 2 ? (Map)objectTable.get(in.readInt()) : Persistence.readMap(in, objectTable);
            Map map = directives = version >= 2 ? (Map)objectTable.get(in.readInt()) : Persistence.readMap(in, objectTable);
            if (attributes == null || directives == null) {
                throw new NullPointerException("Could not find the expected indexes");
            }
            if (isCapability) {
                builder.basicAddCapability(namespace, directives, attributes);
            } else {
                builder.basicAddRequirement(namespace, directives, attributes);
            }
        }

        private static void writeMap(Map<String, ?> source, DataOutputStream out, Map<Object, Integer> objectTable, ModuleDatabase moduleDatabase) throws IOException {
            if (source == null) {
                out.writeInt(0);
            } else {
                out.writeInt(source.size());
                for (String key : source.keySet()) {
                    Object value = source.get(key);
                    Persistence.writeString(key, out, objectTable);
                    if (value instanceof String) {
                        out.writeByte(0);
                        Persistence.writeString((String)value, out, objectTable);
                        continue;
                    }
                    if (value instanceof Long) {
                        out.writeByte(4);
                        out.writeLong((Long)value);
                        continue;
                    }
                    if (value instanceof Double) {
                        out.writeByte(5);
                        out.writeDouble((Double)value);
                        continue;
                    }
                    if (value instanceof Version) {
                        out.writeByte(6);
                        Persistence.writeVersion((Version)value, out, objectTable);
                        continue;
                    }
                    if (value instanceof List) {
                        out.writeByte(8);
                        Persistence.writeList(out, key, (List)value, objectTable, moduleDatabase);
                        continue;
                    }
                    moduleDatabase.adaptor.publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, moduleDatabase.getModule(0L), new BundleException("Invalid map value: " + key + " = " + value.getClass().getName() + '[' + value + ']'), new FrameworkListener[0]);
                    out.writeByte(0);
                    Persistence.writeString(String.valueOf(value), out, objectTable);
                }
            }
        }

        private static void readIndexedMap(DataInputStream in, List<Object> objectTable) throws IOException {
            Map<String, Object> result = Persistence.readMap(in, objectTable);
            Persistence.addToReadTable(result, in.readInt(), objectTable);
        }

        private static Map<String, Object> readMap(DataInputStream in, List<Object> objectTable) throws IOException {
            Map<String, Object> result;
            int count = in.readInt();
            if (count == 0) {
                result = Collections.emptyMap();
            } else if (count == 1) {
                String key = Persistence.readString(in, objectTable);
                byte type = in.readByte();
                Object value = Persistence.readMapValue(in, type, objectTable);
                result = Collections.singletonMap(key, value);
            } else {
                result = new HashMap<String, Object>(count);
                int i = 0;
                while (i < count) {
                    String key = Persistence.readString(in, objectTable);
                    byte type = in.readByte();
                    Object value = Persistence.readMapValue(in, type, objectTable);
                    result.put(key, value);
                    ++i;
                }
                result = Collections.unmodifiableMap(result);
            }
            return result;
        }

        private static Object readMapValue(DataInputStream in, int type, List<Object> objectTable) throws IOException {
            switch (type) {
                case 0: {
                    return Persistence.readString(in, objectTable);
                }
                case 4: {
                    return in.readLong();
                }
                case 5: {
                    return in.readDouble();
                }
                case 6: {
                    return Persistence.readVersion(in, objectTable);
                }
                case 8: {
                    return Persistence.readList(in, objectTable);
                }
            }
            throw new IllegalArgumentException("Invalid type: " + type);
        }

        private static void writeList(DataOutputStream out, String key, List<?> list, Map<Object, Integer> objectTable, ModuleDatabase moduleDatabase) throws IOException {
            if (list.isEmpty()) {
                out.writeInt(0);
                return;
            }
            byte type = Persistence.getListType(list);
            if (type == -1) {
                out.writeInt(0);
                return;
            }
            out.writeInt(list.size());
            out.writeByte(type == -2 ? (byte)0 : type);
            for (Object value : list) {
                switch (type) {
                    case 0: {
                        Persistence.writeString((String)value, out, objectTable);
                        break;
                    }
                    case 4: {
                        out.writeLong((Long)value);
                        break;
                    }
                    case 5: {
                        out.writeDouble((Double)value);
                        break;
                    }
                    case 6: {
                        Persistence.writeVersion((Version)value, out, objectTable);
                        break;
                    }
                    default: {
                        moduleDatabase.adaptor.publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, moduleDatabase.getModule(0L), new BundleException("Invalid list element in map: " + key + " = " + value.getClass().getName() + '[' + value + ']'), new FrameworkListener[0]);
                        Persistence.writeString(String.valueOf(value), out, objectTable);
                    }
                }
            }
        }

        private static byte getListType(List<?> list) {
            if (list.size() == 0) {
                return -1;
            }
            Object type = list.get(0);
            if (type instanceof String) {
                return 0;
            }
            if (type instanceof Long) {
                return 4;
            }
            if (type instanceof Double) {
                return 5;
            }
            if (type instanceof Version) {
                return 6;
            }
            return -2;
        }

        private static List<?> readList(DataInputStream in, List<Object> objectTable) throws IOException {
            int size = in.readInt();
            if (size == 0) {
                return Collections.emptyList();
            }
            byte listType = in.readByte();
            if (size == 1) {
                return Collections.singletonList(Persistence.readListValue(listType, in, objectTable));
            }
            ArrayList<Object> list = new ArrayList<Object>(size);
            int i = 0;
            while (i < size) {
                list.add(Persistence.readListValue(listType, in, objectTable));
                ++i;
            }
            return Collections.unmodifiableList(list);
        }

        private static Object readListValue(byte listType, DataInputStream in, List<Object> objectTable) throws IOException {
            switch (listType) {
                case 0: {
                    return Persistence.readString(in, objectTable);
                }
                case 4: {
                    return in.readLong();
                }
                case 5: {
                    return in.readDouble();
                }
                case 6: {
                    return Persistence.readVersion(in, objectTable);
                }
            }
            throw new IllegalArgumentException("Invalid type: " + listType);
        }

        private static void writeVersion(Version version, DataOutputStream out, Map<Object, Integer> objectTable) throws IOException {
            if (version == null || version.equals(Version.emptyVersion)) {
                out.writeByte(0);
                return;
            }
            Integer index = objectTable.get(version);
            if (index != null) {
                out.writeByte(2);
                out.writeInt(index);
                return;
            }
            out.writeByte(1);
            out.writeInt(version.getMajor());
            out.writeInt(version.getMinor());
            out.writeInt(version.getMicro());
            Persistence.writeQualifier(version.getQualifier(), out, objectTable);
        }

        private static void writeQualifier(String string, DataOutputStream out, Map<Object, Integer> objectTable) throws IOException {
            if (string != null && string.length() == 0) {
                string = null;
            }
            Persistence.writeString(string, out, objectTable);
        }

        private static Version readIndexedVersion(DataInputStream in, List<Object> objectTable) throws IOException {
            Version version = Persistence.readVersion0(in, objectTable, false);
            Persistence.addToReadTable(version, in.readInt(), objectTable);
            return version;
        }

        private static Version readVersion(DataInputStream in, List<Object> objectTable) throws IOException {
            return Persistence.readVersion0(in, objectTable, true);
        }

        private static Version readVersion0(DataInputStream in, List<Object> objectTable, boolean intern) throws IOException {
            byte type = in.readByte();
            if (type == 2) {
                int index = in.readInt();
                return (Version)objectTable.get(index);
            }
            if (type == 0) {
                return Version.emptyVersion;
            }
            int majorComponent = in.readInt();
            int minorComponent = in.readInt();
            int serviceComponent = in.readInt();
            String qualifierComponent = Persistence.readString(in, objectTable);
            Version version = new Version(majorComponent, minorComponent, serviceComponent, qualifierComponent);
            return intern ? ObjectPool.intern(version) : version;
        }

        private static void writeString(String string, DataOutputStream out, Map<Object, Integer> objectTable) throws IOException {
            Integer index;
            Integer n = index = string != null ? objectTable.get(string) : null;
            if (index != null) {
                out.writeByte(2);
                out.writeInt(index);
                return;
            }
            if (string == null) {
                out.writeByte(0);
            } else {
                byte[] data = string.getBytes(StandardCharsets.UTF_8);
                if (data.length > 65535) {
                    out.writeByte(3);
                    out.writeInt(data.length);
                    out.write(data);
                } else {
                    out.writeByte(1);
                    out.writeUTF(string);
                }
            }
        }

        private static String readIndexedString(DataInputStream in, List<Object> objectTable) throws IOException {
            String string = Persistence.readString0(in, objectTable, false);
            Persistence.addToReadTable(string, in.readInt(), objectTable);
            return string;
        }

        private static String readString(DataInputStream in, List<Object> objectTable) throws IOException {
            return Persistence.readString0(in, objectTable, true);
        }

        private static String readString0(DataInputStream in, List<Object> objectTable, boolean intern) throws IOException {
            String string;
            byte type = in.readByte();
            if (type == 2) {
                int index = in.readInt();
                return (String)objectTable.get(index);
            }
            if (type == 0) {
                return null;
            }
            if (type == 3) {
                int length = in.readInt();
                byte[] data = new byte[length];
                in.readFully(data);
                string = new String(data, StandardCharsets.UTF_8);
            } else {
                string = in.readUTF();
            }
            return intern ? ObjectPool.intern(string) : string;
        }
    }

    static enum Sort {
        BY_DEPENDENCY,
        BY_START_LEVEL,
        BY_ID;


        public boolean isContained(Sort ... options) {
            Sort[] sortArray = options;
            int n = options.length;
            int n2 = 0;
            while (n2 < n) {
                Sort option = sortArray[n2];
                if (this.equals((Object)option)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

