/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.navigator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.VisibilityAssistant;
import org.eclipse.ui.internal.navigator.extensions.ExtensionSequenceNumberComparator;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentDescriptor;
import org.eclipse.ui.internal.navigator.extensions.NavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentDescriptor;
import org.eclipse.ui.navigator.INavigatorSaveablesService;
import org.eclipse.ui.navigator.SaveablesProvider;
import org.osgi.framework.BundleEvent;

public class NavigatorSaveablesService
implements INavigatorSaveablesService,
VisibilityAssistant.VisibilityListener {
    private NavigatorContentService contentService;
    private static List<NavigatorSaveablesService> instances = new ArrayList<NavigatorSaveablesService>();
    private Saveable[] currentSaveables;
    private ISaveablesLifecycleListener outsideListener;
    private ISaveablesLifecycleListener saveablesLifecycleListener = new LifecycleListener();
    private ISaveablesSource saveablesSource;
    private StructuredViewer viewer;
    private SaveablesProvider[] saveablesProviders;
    private DisposeListener disposeListener = e -> {
        List<NavigatorSaveablesService> list = instances;
        synchronized (list) {
            NavigatorSaveablesService navigatorSaveablesService = this;
            synchronized (navigatorSaveablesService) {
                if (this.saveablesProviders != null) {
                    SaveablesProvider[] saveablesProviderArray = this.saveablesProviders;
                    int n = this.saveablesProviders.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SaveablesProvider saveablesProvider = saveablesProviderArray[n2];
                        saveablesProvider.dispose();
                        ++n2;
                    }
                }
                NavigatorSaveablesService.removeInstance(this);
                this.contentService = null;
                this.currentSaveables = null;
                this.outsideListener = null;
                this.saveablesLifecycleListener = null;
                this.saveablesSource = null;
                this.viewer = null;
                this.saveablesProviders = null;
                this.disposeListener = null;
            }
        }
    };
    private Map<String, List> inactivePluginsWithSaveablesProviders;
    private Map<NavigatorContentDescriptor, SaveablesProvider> saveablesProviderMap;

    public NavigatorSaveablesService(NavigatorContentService contentService) {
        this.contentService = contentService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addInstance(NavigatorSaveablesService saveablesService) {
        List<NavigatorSaveablesService> list = instances;
        synchronized (list) {
            instances.add(saveablesService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(NavigatorSaveablesService saveablesService) {
        List<NavigatorSaveablesService> list = instances;
        synchronized (list) {
            instances.remove(saveablesService);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void bundleChanged(BundleEvent event) {
        List<NavigatorSaveablesService> list = instances;
        synchronized (list) {
            if (event.getType() == 2) {
                for (NavigatorSaveablesService instance : instances) {
                    instance.handleBundleStarted(event.getBundle().getSymbolicName());
                }
            } else if (event.getType() == 4) {
                for (NavigatorSaveablesService instance : instances) {
                    instance.handleBundleStopped(event.getBundle().getSymbolicName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(ISaveablesSource saveablesSource, StructuredViewer viewer, ISaveablesLifecycleListener outsideListener) {
        List<NavigatorSaveablesService> list = instances;
        synchronized (list) {
            NavigatorSaveablesService navigatorSaveablesService = this;
            synchronized (navigatorSaveablesService) {
                this.saveablesSource = saveablesSource;
                this.viewer = viewer;
                this.outsideListener = outsideListener;
                this.currentSaveables = this.computeSaveables();
                NavigatorSaveablesService.addInstance(this);
            }
        }
        viewer.getControl().addDisposeListener(this.disposeListener);
    }

    private boolean isDisposed() {
        return this.contentService == null;
    }

    /*
     * Unable to fully structure code
     */
    private Saveable[] computeSaveables() {
        contentProvider = (ITreeContentProvider)this.viewer.getContentProvider();
        isTreepathContentProvider = contentProvider instanceof ITreePathContentProvider;
        viewerInput = this.viewer.getInput();
        result = new ArrayList<Saveable>();
        roots = new HashSet<Object>(Arrays.asList(contentProvider.getElements(viewerInput)));
        var10_7 = saveablesProviders = this.getSaveablesProviders();
        var9_8 = saveablesProviders.length;
        var8_9 = 0;
        while (var8_9 < var9_8) {
            saveablesProvider = var10_7[var8_9];
            var15_15 = saveables = saveablesProvider.getSaveables();
            var14_14 = saveables.length;
            var13_13 = 0;
            while (var13_13 < var14_14) {
                saveable = var15_15[var13_13];
                elements = saveablesProvider.getElements(saveable);
                foundRoot = false;
                k = 0;
                while (!foundRoot && k < elements.length) {
                    block9: {
                        block8: {
                            element = elements[k];
                            if (!roots.contains(element)) break block8;
                            result.add(saveable);
                            foundRoot = true;
                            break block9;
                        }
                        if (!isTreepathContentProvider) ** GOTO lbl50
                        treePathContentProvider = (ITreePathContentProvider)contentProvider;
                        parentPaths = treePathContentProvider.getParents(element);
                        l = 0;
                        while (!foundRoot && l < parentPaths.length) {
                            parentPath = parentPaths[l];
                            m = 0;
                            while (!foundRoot && m < parentPath.getSegmentCount()) {
                                if (roots.contains(parentPath.getSegment(m))) {
                                    result.add(saveable);
                                    foundRoot = true;
                                }
                                ++m;
                            }
                            ++l;
                        }
                        break block9;
lbl-1000:
                        // 1 sources

                        {
                            if (roots.contains(element)) {
                                result.add(saveable);
                                foundRoot = true;
                                continue;
                            }
                            element = contentProvider.getParent(element);
lbl50:
                            // 3 sources

                            ** while (!foundRoot && element != null)
                        }
                    }
                    ++k;
                }
                ++var13_13;
            }
            ++var8_9;
        }
        return result.toArray(new Saveable[result.size()]);
    }

    @Override
    public synchronized Saveable[] getActiveSaveables() {
        if (!this.isDisposed()) {
            ITreeContentProvider contentProvider = (ITreeContentProvider)this.viewer.getContentProvider();
            IStructuredSelection selection = this.viewer.getStructuredSelection();
            if (selection instanceof ITreeSelection) {
                return this.getActiveSaveablesFromTreeSelection((ITreeSelection)selection);
            }
            if (contentProvider instanceof ITreePathContentProvider) {
                return this.getActiveSaveablesFromTreePathProvider(selection, (ITreePathContentProvider)contentProvider);
            }
            return this.getActiveSaveablesFromTreeProvider(selection, contentProvider);
        }
        return new Saveable[0];
    }

    private Saveable[] getActiveSaveablesFromTreeSelection(ITreeSelection selection) {
        TreePath[] paths;
        HashSet<Saveable> result = new HashSet<Saveable>();
        TreePath[] treePathArray = paths = selection.getPaths();
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            Saveable saveable = this.findSaveable(path);
            if (saveable != null) {
                result.add(saveable);
            }
            ++n2;
        }
        return result.toArray(new Saveable[result.size()]);
    }

    private Saveable[] getActiveSaveablesFromTreePathProvider(IStructuredSelection selection, ITreePathContentProvider provider) {
        HashSet<Saveable> result = new HashSet<Saveable>();
        for (Object element : selection) {
            Saveable saveable = this.getSaveable(element);
            if (saveable != null) {
                result.add(saveable);
                continue;
            }
            TreePath[] paths = provider.getParents(element);
            saveable = this.findSaveable(paths);
            if (saveable == null) continue;
            result.add(saveable);
        }
        return result.toArray(new Saveable[result.size()]);
    }

    private Saveable[] getActiveSaveablesFromTreeProvider(IStructuredSelection selection, ITreeContentProvider contentProvider) {
        HashSet<Saveable> result = new HashSet<Saveable>();
        for (Object element : selection) {
            Saveable saveable = this.findSaveable(element, contentProvider);
            if (saveable == null) continue;
            result.add(saveable);
        }
        return result.toArray(new Saveable[result.size()]);
    }

    private Saveable findSaveable(Object element, ITreeContentProvider contentProvider) {
        while (element != null) {
            Saveable saveable = this.getSaveable(element);
            if (saveable != null) {
                return saveable;
            }
            element = contentProvider.getParent(element);
        }
        return null;
    }

    private Saveable findSaveable(TreePath[] paths) {
        TreePath[] treePathArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            TreePath path = treePathArray[n2];
            Saveable saveable = this.findSaveable(path);
            if (saveable != null) {
                return saveable;
            }
            ++n2;
        }
        return null;
    }

    private Saveable findSaveable(TreePath path) {
        int count = path.getSegmentCount();
        int j = count - 1;
        while (j >= 0) {
            Object parent = path.getSegment(j);
            Saveable saveable = this.getSaveable(parent);
            if (saveable != null) {
                return saveable;
            }
            --j;
        }
        return null;
    }

    private Saveable getSaveable(Object element) {
        if (this.saveablesProviderMap == null) {
            this.getSaveablesProviders();
        }
        for (Map.Entry<NavigatorContentDescriptor, SaveablesProvider> entry : this.saveablesProviderMap.entrySet()) {
            SaveablesProvider provider;
            Saveable saveable;
            NavigatorContentDescriptor descriptor = entry.getKey();
            if (!descriptor.isTriggerPoint(element) && !descriptor.isPossibleChild(element) || (saveable = (provider = entry.getValue()).getSaveable(element)) == null) continue;
            return saveable;
        }
        return null;
    }

    @Override
    public synchronized Saveable[] getSaveables() {
        return this.currentSaveables;
    }

    private SaveablesProvider[] getSaveablesProviders() {
        if (this.saveablesProviders == null) {
            if (this.isDisposed()) {
                return null;
            }
            this.inactivePluginsWithSaveablesProviders = new HashMap<String, List>();
            this.saveablesProviderMap = new TreeMap<NavigatorContentDescriptor, SaveablesProvider>(ExtensionSequenceNumberComparator.INSTANCE);
            INavigatorContentDescriptor[] descriptors = this.contentService.getActiveDescriptorsWithSaveables();
            ArrayList<SaveablesProvider> result = new ArrayList<SaveablesProvider>();
            INavigatorContentDescriptor[] iNavigatorContentDescriptorArray = descriptors;
            int n = descriptors.length;
            int n2 = 0;
            while (n2 < n) {
                INavigatorContentDescriptor iDescriptor = iNavigatorContentDescriptorArray[n2];
                NavigatorContentDescriptor descriptor = (NavigatorContentDescriptor)iDescriptor;
                String pluginId = descriptor.getContribution().getPluginId();
                if (Platform.getBundle((String)pluginId).getState() != 32) {
                    ArrayList<NavigatorContentDescriptor> inactiveDescriptors = this.inactivePluginsWithSaveablesProviders.get(pluginId);
                    if (inactiveDescriptors == null) {
                        inactiveDescriptors = new ArrayList<NavigatorContentDescriptor>();
                        this.inactivePluginsWithSaveablesProviders.put(pluginId, inactiveDescriptors);
                    }
                    inactiveDescriptors.add(descriptor);
                } else {
                    SaveablesProvider saveablesProvider = this.createSaveablesProvider(descriptor);
                    if (saveablesProvider != null) {
                        saveablesProvider.init(this.saveablesLifecycleListener);
                        result.add(saveablesProvider);
                        this.saveablesProviderMap.put(descriptor, saveablesProvider);
                    }
                }
                ++n2;
            }
            this.saveablesProviders = result.toArray(new SaveablesProvider[result.size()]);
        }
        return this.saveablesProviders;
    }

    private SaveablesProvider createSaveablesProvider(NavigatorContentDescriptor descriptor) {
        NavigatorContentExtension extension = this.contentService.getExtension(descriptor, true);
        ITreeContentProvider contentProvider = extension.getContentProvider();
        return (SaveablesProvider)Adapters.adapt((Object)contentProvider, SaveablesProvider.class);
    }

    private void recomputeSaveablesAndNotify(boolean recomputeProviders, String startedBundleIdOrNull) {
        if (recomputeProviders && startedBundleIdOrNull == null && this.saveablesProviders != null) {
            SaveablesProvider[] saveablesProviderArray = this.saveablesProviders;
            int n = this.saveablesProviders.length;
            int n2 = 0;
            while (n2 < n) {
                SaveablesProvider saveablesProvider = saveablesProviderArray[n2];
                saveablesProvider.dispose();
                ++n2;
            }
            this.saveablesProviders = null;
        } else if (startedBundleIdOrNull != null && this.inactivePluginsWithSaveablesProviders.containsKey(startedBundleIdOrNull)) {
            this.updateSaveablesProviders(startedBundleIdOrNull);
        }
        HashSet<Saveable> oldSaveables = new HashSet<Saveable>(Arrays.asList(this.currentSaveables));
        this.currentSaveables = this.computeSaveables();
        HashSet<Saveable> newSaveables = new HashSet<Saveable>(Arrays.asList(this.currentSaveables));
        HashSet<Saveable> removedSaveables = new HashSet<Saveable>(oldSaveables);
        removedSaveables.removeAll(newSaveables);
        HashSet<Saveable> addedSaveables = new HashSet<Saveable>(newSaveables);
        addedSaveables.removeAll(oldSaveables);
        if (addedSaveables.size() > 0) {
            Display.getDefault().asyncExec(() -> {
                if (this.isDisposed()) {
                    return;
                }
                this.outsideListener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)this.saveablesSource, 1, addedSaveables.toArray(new Saveable[addedSaveables.size()]), false));
            });
        }
        if (removedSaveables.size() > 0) {
            Display.getDefault().asyncExec(() -> {
                if (this.isDisposed()) {
                    return;
                }
                this.outsideListener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)this.saveablesSource, 2, removedSaveables.toArray(new Saveable[removedSaveables.size()]), true));
                this.outsideListener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)this.saveablesSource, 3, removedSaveables.toArray(new Saveable[removedSaveables.size()]), false));
            });
        }
    }

    private void updateSaveablesProviders(String startedBundleId) {
        ArrayList<SaveablesProvider> result = new ArrayList<SaveablesProvider>(Arrays.asList(this.saveablesProviders));
        List descriptors = this.inactivePluginsWithSaveablesProviders.get(startedBundleId);
        for (NavigatorContentDescriptor descriptor : descriptors) {
            SaveablesProvider saveablesProvider = this.createSaveablesProvider(descriptor);
            if (saveablesProvider == null) continue;
            saveablesProvider.init(this.saveablesLifecycleListener);
            result.add(saveablesProvider);
            this.saveablesProviderMap.put(descriptor, saveablesProvider);
        }
        this.saveablesProviders = result.toArray(new SaveablesProvider[result.size()]);
    }

    private synchronized void handleBundleStarted(String symbolicName) {
        if (!this.isDisposed() && this.inactivePluginsWithSaveablesProviders.containsKey(symbolicName)) {
            this.recomputeSaveablesAndNotify(true, symbolicName);
        }
    }

    private synchronized void handleBundleStopped(String symbolicName) {
        if (!this.isDisposed()) {
            this.recomputeSaveablesAndNotify(true, null);
        }
    }

    @Override
    public synchronized void onVisibilityOrActivationChange() {
        if (!this.isDisposed()) {
            this.recomputeSaveablesAndNotify(true, null);
        }
    }

    @Override
    public boolean hasSaveablesProvider() {
        return !this.isDisposed() && this.getSaveablesProviders() != null && this.getSaveablesProviders().length > 0;
    }

    private class LifecycleListener
    implements ISaveablesLifecycleListener {
        private LifecycleListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleLifecycleEvent(SaveablesLifecycleEvent event) {
            Saveable[] saveables = event.getSaveables();
            Saveable[] shownSaveables = null;
            List list = instances;
            synchronized (list) {
                NavigatorSaveablesService navigatorSaveablesService = NavigatorSaveablesService.this;
                synchronized (navigatorSaveablesService) {
                    if (NavigatorSaveablesService.this.isDisposed()) {
                        return;
                    }
                    switch (event.getEventType()) {
                        case 1: {
                            NavigatorSaveablesService.this.recomputeSaveablesAndNotify(false, null);
                            break;
                        }
                        case 3: {
                            NavigatorSaveablesService.this.recomputeSaveablesAndNotify(false, null);
                            break;
                        }
                        case 4: {
                            HashSet<Saveable> result = new HashSet<Saveable>(Arrays.asList(NavigatorSaveablesService.this.currentSaveables));
                            result.retainAll(Arrays.asList(saveables));
                            shownSaveables = result.toArray(new Saveable[result.size()]);
                        }
                    }
                }
            }
            if (shownSaveables != null && shownSaveables.length > 0) {
                NavigatorSaveablesService.this.outsideListener.handleLifecycleEvent(new SaveablesLifecycleEvent((Object)NavigatorSaveablesService.this.saveablesSource, 4, shownSaveables, false));
            }
        }
    }
}

