/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess.providers;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.model.LocalizationHelper;
import org.eclipse.e4.ui.model.application.MApplicationElement;
import org.eclipse.e4.ui.model.application.descriptor.basic.MPartDescriptor;
import org.eclipse.e4.ui.model.application.ui.advanced.MPlaceholder;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class ViewElement
extends QuickAccessElement {
    private MWindow window;
    private MPartDescriptor viewDescriptor;
    private ImageDescriptor imageDescriptor;
    private String viewLabel;

    public ViewElement(MWindow window, MPartDescriptor descriptor) {
        String description;
        this.window = window;
        this.viewDescriptor = descriptor;
        this.imageDescriptor = this.createImageDescriptor();
        this.viewLabel = LocalizationHelper.getLocalized((String)this.viewDescriptor.getLabel(), (MApplicationElement)this.viewDescriptor, (IEclipseContext)window.getContext());
        String categoryLabel = LocalizationHelper.getLocalized((String)this.viewDescriptor.getCategory(), (MApplicationElement)this.viewDescriptor, (IEclipseContext)window.getContext());
        if (categoryLabel != null) {
            this.viewLabel = NLS.bind((String)QuickAccessMessages.QuickAccess_ViewWithCategory, (Object)this.viewLabel, (Object)categoryLabel);
        }
        if ((description = LocalizationHelper.getLocalized((String)this.viewDescriptor.getTooltip(), (MApplicationElement)this.viewDescriptor, (IEclipseContext)window.getContext())) != null && !description.isEmpty()) {
            this.viewLabel = String.valueOf(this.viewLabel) + " - " + description;
        }
    }

    private ImageDescriptor createImageDescriptor() {
        String iconURI = this.viewDescriptor.getIconURI();
        if (iconURI == null) {
            return null;
        }
        try {
            return ImageDescriptor.createFromURL((URL)new URL(iconURI));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public void execute() {
        String id = this.viewDescriptor.getElementId();
        if (id != null) {
            if ("bundleclass://org.eclipse.ui.workbench/org.eclipse.ui.internal.e4.compatibility.CompatibilityView".equals(this.viewDescriptor.getContributionURI())) {
                IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)this.window.getContext().get(IWorkbenchWindow.class);
                IWorkbenchPage page = workbenchWindow.getActivePage();
                if (page != null) {
                    try {
                        page.showView(this.viewDescriptor.getElementId());
                    }
                    catch (PartInitException e) {
                        WorkbenchPlugin.log((Throwable)((Object)e));
                    }
                }
            } else {
                EPartService partService = (EPartService)this.window.getContext().get(EPartService.class);
                MPart part = partService.findPart(id);
                if (part == null) {
                    MPlaceholder placeholder = partService.createSharedPart(id);
                    part = (MPart)placeholder.getRef();
                }
                partService.showPart(part, EPartService.PartState.ACTIVATE);
            }
        }
    }

    @Override
    public String getId() {
        return this.viewDescriptor.getElementId();
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return this.imageDescriptor;
    }

    @Override
    public String getLabel() {
        return this.viewLabel;
    }

    public int hashCode() {
        return Objects.hashCode(this.viewDescriptor);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ViewElement other = (ViewElement)obj;
        return Objects.equals(this.viewDescriptor, other.viewDescriptor);
    }
}

