/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.control.core.model.impl;

import org.eclipse.tracecompass.internal.lttng2.control.core.model.ILoggerInfo;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.LogLevelType;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.TraceEnablement;
import org.eclipse.tracecompass.internal.lttng2.control.core.model.impl.BaseLoggerInfo;

public class LoggerInfo
extends BaseLoggerInfo
implements ILoggerInfo {
    private TraceEnablement fState = TraceEnablement.DISABLED;
    private LogLevelType fLogLevelType = LogLevelType.LOGLEVEL_ALL;

    public LoggerInfo(String name) {
        super(name);
    }

    public LoggerInfo(LoggerInfo other) {
        super(other);
        this.fState = other.fState;
        this.fLogLevelType = other.fLogLevelType;
    }

    @Override
    public TraceEnablement getState() {
        return this.fState;
    }

    @Override
    public void setState(TraceEnablement state) {
        this.fState = state;
    }

    @Override
    public void setState(String stateName) {
        this.fState = TraceEnablement.valueOfString(stateName);
    }

    @Override
    public LogLevelType getLogLevelType() {
        return this.fLogLevelType;
    }

    @Override
    public void setLogLevelType(LogLevelType type) {
        this.fLogLevelType = type;
    }

    @Override
    public void setLogLevelType(String shortName) {
        this.fLogLevelType = LogLevelType.valueOfString(shortName);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.fState == null ? 0 : this.fState.ordinal() + 1);
        result = 31 * result + (this.fLogLevelType == null ? 0 : this.fLogLevelType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LoggerInfo other = (LoggerInfo)obj;
        if (this.fState != other.fState) {
            return false;
        }
        return this.fLogLevelType == other.fLogLevelType;
    }

    @Override
    public String toString() {
        StringBuffer output = new StringBuffer();
        output.append("[LoggerInfo(");
        output.append(super.toString());
        output.append(",State=");
        output.append((Object)this.fState);
        output.append(",levelType=");
        output.append((Object)this.fLogLevelType);
        output.append(")]");
        return output.toString();
    }
}

