/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring.scripting;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ltk.core.refactoring.history.RefactoringHistory;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.internal.ui.refactoring.scripting.ScriptingMessages;
import org.eclipse.ltk.internal.ui.refactoring.scripting.ShowRefactoringHistoryWizardPage;

public final class ShowRefactoringHistoryWizard
extends Wizard {
    private static String DIALOG_SETTINGS_KEY = "ShowRefactoringHistoryWizard";
    private boolean fNewSettings;
    private RefactoringHistory fRefactoringHistory;
    private final ShowRefactoringHistoryWizardPage fWizardPage;

    public ShowRefactoringHistoryWizard() {
        this.setNeedsProgressMonitor(false);
        this.setWindowTitle(ScriptingMessages.ShowRefactoringHistoryWizard_title);
        this.setDefaultPageImageDescriptor(RefactoringPluginImages.DESC_WIZBAN_SHOW_HISTORY);
        IDialogSettings settings = RefactoringUIPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            this.fNewSettings = true;
        } else {
            this.fNewSettings = false;
            this.setDialogSettings(section);
        }
        this.fWizardPage = new ShowRefactoringHistoryWizardPage(this);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.fWizardPage);
    }

    public RefactoringHistory getRefactoringHistory() {
        return this.fRefactoringHistory;
    }

    public boolean performFinish() {
        if (this.fNewSettings) {
            IDialogSettings settings = RefactoringUIPlugin.getDefault().getDialogSettings();
            IDialogSettings section = settings.getSection(DIALOG_SETTINGS_KEY);
            section = settings.addNewSection(DIALOG_SETTINGS_KEY);
            this.setDialogSettings(section);
        }
        this.fWizardPage.performFinish();
        return true;
    }

    public void setRefactoringHistory(RefactoringHistory history) {
        Assert.isNotNull((Object)history);
        this.fRefactoringHistory = history;
    }
}

