/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.histogram;

import java.text.ParseException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestampFormat;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramTextControl;
import org.eclipse.tracecompass.tmf.ui.views.histogram.HistogramView;

public class HistogramTimeRangeControl
extends HistogramTextControl {
    public HistogramTimeRangeControl(HistogramView parentView, Composite parent, String groupLabel, long value) {
        super(parentView, parent, groupLabel, value);
    }

    @Override
    protected void updateValue() {
        if (this.getValue() == Long.MIN_VALUE) {
            this.fTextValue.setText("");
            return;
        }
        String string = this.fTextValue.getText();
        long value = this.getValue();
        try {
            value = TmfTimestampFormat.getDefaulIntervalFormat().parseValue(string);
            if (value < 1L) {
                value = this.getValue();
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (this.getValue() != value) {
            this.fParentView.updateTimeRange(value);
        } else {
            this.setValue(value);
        }
    }

    @Override
    public void setValue(long time) {
        if (time != Long.MIN_VALUE) {
            ITmfTimestamp ts = TmfTimestamp.fromNanos((long)time);
            super.setValue(time, ts.toString(TmfTimestampFormat.getDefaulIntervalFormat()));
        } else {
            super.setValue(time, "");
        }
    }

    @TmfSignalHandler
    public void intervalFormatUpdated(TmfTimestampFormatUpdateSignal signal) {
        this.setValue(this.getValue());
    }
}

