/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.memory.renderings;

import java.math.BigInteger;
import java.util.ArrayList;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.model.MemoryByte;

public class MemorySegment
extends PlatformObject {
    private BigInteger fAddress;
    private BigInteger fEndAddress;
    private MemoryByte[] fBytes;
    private int fNumAddressableUnits;

    public MemorySegment(BigInteger address, MemoryByte[] bytes, int numAddressableUnits) {
        this.fAddress = address;
        this.fBytes = bytes;
        this.fNumAddressableUnits = numAddressableUnits;
    }

    public BigInteger getAddress() {
        return this.fAddress;
    }

    public MemoryByte[] getBytes() {
        return this.fBytes;
    }

    public int getNumAddressableUnits() {
        return this.fNumAddressableUnits;
    }

    public boolean containsAddress(BigInteger address) {
        return this.getAddress().compareTo(address) <= 0 && this.getEndAddress().compareTo(address) >= 0;
    }

    public BigInteger getEndAddress() {
        if (this.fEndAddress == null) {
            this.fEndAddress = this.fAddress.add(BigInteger.valueOf(this.fNumAddressableUnits).subtract(BigInteger.ONE));
        }
        return this.fEndAddress;
    }

    public MemoryByte[] getBytes(int start, int length) {
        if (start < 0) {
            return new MemoryByte[0];
        }
        if (start + length > this.fBytes.length) {
            return new MemoryByte[0];
        }
        ArrayList<MemoryByte> ret = new ArrayList<MemoryByte>();
        int i = start;
        while (i < start + length) {
            ret.add(this.fBytes[i]);
            ++i;
        }
        return ret.toArray(new MemoryByte[ret.size()]);
    }
}

